/*
 *         Copyright (C) Argonne National Laboratory
 *
 *   Argonne does not guarantee this software in any manner and is
 *   not responsible for any damages that may result from its use.
 *   Furthermore, Argonne does not provide any formal support for this
 *   software.  This is an experimental program.  This software
 *   or any part of it may be freely copied and redistributed,
 *   provided that this paragraph is included in each source file.
 *
 */

/* Function names. */

void my_cleanup();	/* main.c */
struct clause *extract_first_cl();
struct clause *extract_last_cl();

void init();		/* misc.c */
void read_all_input();
void free_all_mem();
struct term *copy_term();
struct term *copy_term_scratch();
struct term *str_term();
void output_stats();
void append_lists();
void zap_list();
void zap_term();
void print_term();
void print_term_lisp();
void print_cl_list_lisp();

struct term *get_term(); /* av.c */
void free_term();
struct rel *get_rel();
void free_rel();
struct term_ptr *get_term_ptr();
struct list *get_list();
void free_list();
struct clause *get_clause();
void free_clause();
struct sym_ent *get_sym_ent();
void free_sym_ent();
struct literal *get_literal();
void free_literal();
struct trail *get_trail();
void free_trail();
struct clause_ptr *get_clause_ptr();
void free_clause_ptr();
struct int_ptr *get_int_ptr();
void free_int_ptr();

struct term *integrate_term();
void print_options();
struct term *next_term();

struct term_ptr *read_formula_list(); /* in formula.c */
struct term_ptr *read_list();
struct list *read_cl_list();

void print_variable(); /* in io.c */
void print_variable_lisp();
char *sn_to_str();
void str_copy();
void skip_white();
void print_error();
void reverse();
struct term *read_term();
struct term *str_atom();

/* clause.c */

struct clause *read_clause();
void print_clause();
struct clause *cl_find();
void cl_insert_tab();
void cl_delete_tab();
void rem_from_list();
void cl_insert_tab();
void cl_delete_tab();
void mark_literal();
void remove_var_syms();
void insert_clause();

/* formula.c : */

void print_formula();
void p_formula();
struct term *read_formula();
struct term *str_formula();
void negate();
struct term *nnf();
void skolemize();
void skolem();
void subst_free();
void gen_sk_sym();
int new_var_name();
int new_functor_name();
void unique_all();
void uq_all();
struct term *zap_quant();
void mark_free_var();
void flatten_top();
struct term *cnf();
struct term *distribute();
void rename_syms();
void subst_sn();
struct list *cnf_to_list();
struct clause *disj_to_clause();
void clear_scratches();
int set_vars_cl_2();
int set_vars_term_2();
struct list *clausify();
struct list *clausify_formula_list();
struct term_ptr *read_formula_list();
void print_formula_list();
int gen_subsume();
struct term *subsume_conj();
struct term *subsume_disj();
void conflict_tautology();
void ts_and_fs();

