/*
 *         Copyright (C) Argonne National Laboratory
 *
 *   Argonne does not guarantee this software in any manner and is
 *   not responsible for any damages that may result from its use.
 *   Furthermore, Argonne does not provide any formal support for this
 *   software.  This is an experimental program.  This software
 *   or any part of it may be freely copied and redistributed,
 *   provided that this paragraph is included in each source file.
 *
 */

/*************
 *
 *    Flags are boolean valued options.  To install a new flag, append
 *    a new name and index to the end of this list, then insert code to
 *    initialize it in the routine `init_options'.
 *    Example access:  if (Flags[PARA_FROM_LEFT].val) {
 *    See routine `init_options' for defaults.
 *
 *************/

#define MAX_FLAGS           6  /* increase if necessary */

#define CHECK_ARITY 1 /* require symbols to have fixed arities */
#define PROLOG_STYLE_VARIABLES 2 /* vars start with A-Z */
#define PROCESS_INPUT 3 /* process input axioms and demodulators */
#define SIMPLIFY_FOL 4 /* attempt to simplify during cnf translation */

#define FREE_ALL_MEM 5 /* free all memory to avail lists at end of run */

    /* end of Flags */

/*************
 *
 *    Statistics.  To install a new statistic, append a new name and index
 *    to the end of this list, then insert the code to output it in the
 *    routine `print_stats'.
 *    Example access:  Stats[INPUT_ERRORS]++;
 *
 *************/

#define MAX_STATS        22

#define INPUT_ERRORS      0
#define CL_INPUT          1

    /* end of Stats */

/*************
 *
 *    Clocks.  To install a new clock, append a new name and index
 *    to the end of this list, then insert the code to output it in the
 *    routine `print_times'.  Example of use: CLOCK_START(INPUT_TIME),
 *    CLOCK_STOP(INPUT_TIME),  micro_sec = clock_val(INPUT_TIME);.
 *    See files macros.h and clocks.c.  The system call to get CPU time
 *    is not portable. 
 *
 *************/

#define MAX_CLOCKS          25
 
#define INPUT_TIME           0
#define CLAUSIFY_TIME        1
#define PROCESS_INPUT_TIME   2

    /* end of clocks */

