#include "header.h"

/*
 *         Copyright (C) Argonne National Laboratory
 *
 *   Argonne does not guarantee this software in any manner and is
 *   not responsible for any damages that may result from its use.
 *   Furthermore, Argonne does not provide any formal support for this
 *   software.  This is an experimental program.  This software
 *   or any part of it may be freely copied and redistributed,
 *   provided that this paragraph is included in each source file.
 *
 */


#define TP_ALLOC_SIZE 32700  /* bytes allocated by malloc */

static char *Alloc_block;    /* location returned by most recent malloc */
static char *Alloc_pos;      /* current position in block */

/*  a list of available nodes for each type of strucure */

static struct term *term_avail;
static struct rel *rel_avail;
static struct sym_ent *sym_ent_avail;
static struct term_ptr *term_ptr_avail;

static struct literal *literal_avail;
static struct clause *clause_avail;
static struct list *list_avail;

static struct clause_ptr *clause_ptr_avail;

static int Malloc_calls;  /* number of calls to malloc */

/* # of gets, frees, and size of avail list for each type of structure */

static long term_gets, term_frees, term_avails;
static long rel_gets, rel_frees, rel_avails;
static long sym_ent_gets, sym_ent_frees, sym_ent_avails;
static long term_ptr_gets, term_ptr_frees, term_ptr_avails;

static long literal_gets, literal_frees, literal_avails;
static long clause_gets, clause_frees, clause_avails;
static long list_gets, list_frees, list_avails;
static long clause_ptr_gets, clause_ptr_frees, clause_ptr_avails;

/*************
 *
 *    tp_alloc(n) -- Allocate n contiguous bytes, aligned on integer boundry.
 *
 *************/

static char *tp_alloc(n)
int n;
{
    char *return_block;
    int scale;
    
    /* if n is not a multiple of sizeof(int), then round up so that it is */
    
    scale = sizeof(int);
    if (n % scale != 0)
	n = n + (scale - (n % scale));
    
    if (Alloc_block == NULL || Alloc_block + TP_ALLOC_SIZE - Alloc_pos < n) {
        /* try to malloc a new block */
	if (n > TP_ALLOC_SIZE) {
	    output_stats(stdout, 4);
	    fprintf(stdout, "ABEND, tp_alloc, request too big: %d\n", n);
	    fprintf(stderr, "ABEND, tp_alloc, request too big: %d\007\n", n);
	    exit(1);
	    }
	else /*B if (Parms[MAX_MEM].val != 0 &&
		 ((Malloc_calls+1)*TP_ALLOC_SIZE)/1024 > Parms[MAX_MEM].val) {
	    fprintf(stdout, "\nsearch stopped in tp_alloc by max_mem option.\n");
	    fprintf(stderr, "search stopped in tp_alloc by max_mem option.\007\n");
	    if (Flags[FREE_ALL_MEM].val) {
		fprintf(stdout, "    (free_all_mem cleared).\n");
		Flags[FREE_ALL_MEM].val = 0;
		}
	    my_cleanup();
	    exit(0);
	    }
	else E*/ {
	    Alloc_pos = Alloc_block = (char *) malloc( (unsigned) TP_ALLOC_SIZE);
	    Malloc_calls++;
	    if (Alloc_pos == NULL) {
		output_stats(stdout, 4);
		fprintf(stdout, "\nABEND, malloc returns NULL (out of memory).\n");
		fprintf(stderr, "ABEND, malloc returns NULL (out of memory).\007\n");
		exit(1);
		}
	    }
        }
    return_block = Alloc_pos;
    Alloc_pos += n;
    return(return_block);
}  /* tp_alloc */

/*************
 *
 *   struct term *get_term()
 *
 *************/

struct term *get_term()
{
    struct term *p;
    
    term_gets++;
    if (term_avail == NULL)
	p = (struct term *) tp_alloc(sizeof(struct term));
    else {
	term_avails--;
	p = term_avail;
	term_avail = (struct term *) term_avail->farg;
	}
    p->sym_num = 0;
    p->farg = NULL;
    p->occ.rel = NULL;
    p->varnum = 0;
    p->scratch = 0;
    p->scratch2 = 0;
    p->fpa_id = 0;
    return(p);
}  /* get_term */

/*************
 *
 *    free_term()
 *
 *************/

void free_term(p)
struct term *p;
{
    term_frees++;
    term_avails++;
    p->farg = (struct rel *) term_avail;
    term_avail = p;
}  /* free_term */

/*************
 *
 *    struct rel *get_rel()
 *
 *************/

struct rel *get_rel()
{
    struct rel *p;
    
    rel_gets++;
    if (rel_avail == NULL)
	p = (struct rel *) tp_alloc(sizeof(struct rel));
    else {
	rel_avails--;
	p = rel_avail;
	rel_avail = rel_avail->narg;
	}
    p->argval = NULL;
    p->argof = NULL;
    p->narg = NULL;
    p->nocc = NULL;
    /* p->path = 0;
    p->clashable = 0; */
    return(p);
}  /* get_rel */

/*************
 *
 *    free_rel()
 *
 *************/

void free_rel(p)
struct rel *p;
{
    rel_frees++;
    rel_avails++;
    p->narg = rel_avail;
    rel_avail = p;
}  /* free_rel */

/*************
 *
 *    struct sym_ent *get_sym_ent()
 *
 *************/

struct sym_ent *get_sym_ent()
{
    struct sym_ent *p;
    
    sym_ent_gets++;
    if (sym_ent_avail == NULL)
	p = (struct sym_ent *) tp_alloc(sizeof(struct sym_ent));
    else {
	sym_ent_avails--;
	p = sym_ent_avail;
	sym_ent_avail = sym_ent_avail->next;
	}
    p->next = NULL;
    return(p);
}  /* get_sym_ent */

/*************
 *
 *    free_sym_ent()
 *
 *************/

void free_sym_ent(p)
struct sym_ent *p;
{
    sym_ent_frees++;
    sym_ent_avails++;
    p->next = sym_ent_avail;
    sym_ent_avail = p;
}  /* free_sym_ent */

/*************
 *
 *    struct term_ptr *get_term_ptr()
 *
 *************/

struct term_ptr *get_term_ptr()
{
    struct term_ptr *p;
    
    term_ptr_gets++;
    if (term_ptr_avail == NULL)
	p = (struct term_ptr *) tp_alloc(sizeof(struct term_ptr));
    else {
	term_ptr_avails--;
	p = term_ptr_avail;
	term_ptr_avail = term_ptr_avail->next;
	}
    p->term = NULL;
    p->next = NULL;
    return(p);
}  /* get_term_ptr */

/*************
 *
 *    free_term_ptr()
 *
 *************/

void free_term_ptr(p)
struct term_ptr *p;
{
    term_ptr_frees++;
    term_ptr_avails++;
    p->next = term_ptr_avail;
    term_ptr_avail = p;
}  /* free_term_ptr */

/*************
 *
 *    struct literal *get_literal()
 *
 *************/

struct literal *get_literal()
{
    struct literal *p;
    
    literal_gets++;
    if (literal_avail == NULL)
	p = (struct literal *) tp_alloc(sizeof(struct literal));
    else {
	literal_avails--;
	p = literal_avail;
	literal_avail = literal_avail->next_lit;
	}
    p->container = NULL;
    p->next_lit = NULL;
    p->sign = 0;
    p->atom = NULL;
    return(p);
}  /* get_literal */

/*************
 *
 *    free_literal()
 *
 *************/

void free_literal(p)
struct literal *p;
{
    literal_frees++;
    literal_avails++;
    p->next_lit = literal_avail;
    literal_avail = p;
}  /* free_literal */

/*************
 *
 *    struct clause *get_clause()
 *
 *************/

struct clause *get_clause()
{
    struct clause *p;
    
    clause_gets++;
    if (clause_avail == NULL)
	p = (struct clause *) tp_alloc(sizeof(struct clause));
    else {
	clause_avails--;
	p = clause_avail;
	clause_avail = clause_avail->next_cl;
	}
    p->id = 0;
    p->parents = NULL;
    p->container = NULL;
    p->next_cl = NULL;
    p->prev_cl = NULL;
    p->first_lit = NULL;
    /* p->weight = 0; */
    p->type = NOT_SPECIFIED;
    return(p);
}  /* get_clause */

/*************
 *
 *    free_clause()
 *
 *************/

void free_clause(p)
struct clause *p;
{
    clause_frees++;
    clause_avails++;
    p->next_cl = clause_avail;
    clause_avail = p;
}  /* free_clause */

/*************
 *
 *    struct list *get_list()
 *
 *************/

struct list *get_list()
{
    struct list *p;
    
    list_gets++;
    if (list_avail == NULL)
	p = (struct list *) tp_alloc(sizeof(struct list));
    else {
	list_avails--;
	p = list_avail;
	list_avail = (struct list *) list_avail->first_cl;
	}
    p->first_cl = NULL;
    p->last_cl = NULL;
    /* p->name[0] = '\0'; */
    return(p);
}  /* get_list */

/*************
 *
 *    free_list()
 *
 *************/

void free_list(p)
struct list *p;
{
    list_frees++;
    list_avails++;
    p->first_cl = (struct clause *) list_avail;
    list_avail = p;
}  /* free_list */

/*************
 *
 *    struct clause_ptr *get_clause_ptr()
 *
 *************/

struct clause_ptr *get_clause_ptr()
{
    struct clause_ptr *p;
    
    clause_ptr_gets++;
    if (clause_ptr_avail == NULL)
	p = (struct clause_ptr *) tp_alloc(sizeof(struct clause_ptr));
    else {
	clause_ptr_avails--;
	p = clause_ptr_avail;
	clause_ptr_avail = clause_ptr_avail->next;
	}
    p->next = NULL;
    p->c = NULL;
    return(p);
}  /* get_clause_ptr */

/*************
 *
 *    free_clause_ptr()
 *
 *************/

void free_clause_ptr(p)
struct clause_ptr *p;
{
    clause_ptr_frees++;
    clause_ptr_avails++;
    p->next = clause_ptr_avail;
    clause_ptr_avail = p;
}  /* free_clause_ptr */

/*************
 *
 *    free_int_ptr()
 *
 *************/

void free_int_ptr(p)
struct int_ptr *p;
{
   free(p); 
}  /* free_int_ptr */

/*************
 *
 *    int total_mem() -- How many K have been dynamically allocated?
 *
 *************/

int total_mem()
{
    return( (int) (Malloc_calls * (TP_ALLOC_SIZE / 1024.)));
}  /* total_mem */

