signature IMPERATIVE =
  sig
    exception Imperative of string

    val do_until: (unit -> 'a) -> (unit -> bool) -> unit
    val while_do: (unit -> bool) -> (unit -> 'a) -> unit

    type 'a  stack
    val init_stack: '1a list -> '1a stack
    val empty_stack: 'a stack -> unit
    val is_empty: 'a stack -> bool
    val push: 'a -> 'a stack -> unit
    val peek: 'a stack -> 'a
    val pop: 'a stack -> 'a
    val is_on: ''a -> ''a stack -> bool
    val stack2list: 'a stack -> 'a list

    type 'a  mark
    val init_mark: '1a list -> '1a mark
    val empty_mark: 'a mark -> unit
    val mark: ''a -> ''a mark -> unit
    val unmark: ''a -> ''a mark -> unit
    val is_marked: ''a -> ''a mark -> bool
    val next_marked: 'a mark -> 'a option

    type ('a,'b)  table
    val init_table: ('1a * '1b) list -> ('1a,'1b) table
    val empty_table: ('a,'b) table -> unit
    val set: (''a,'b) table -> ''a -> 'b -> unit
    val get: (''a,'b) table -> ''a -> 'b

  end
