functor Imperative(structure Lists : LISTS) : IMPERATIVE =
  struct
    open Lists
    
    exception Imperative of string    
    

    (*** Iterations ***)
    
    fun do_until f p = (f(); if p() then () else do_until f p)
    fun while_do p f = if p() then (f(); while_do p f) else ()


    (*** Stacks ***)
    
    datatype 'a stack = Stack of 'a list ref
    
    fun init_stack l = (Stack (ref l))
    fun empty_stack (Stack stack) = stack := nil
    fun is_empty (Stack (ref l)) = null l
    fun push v (Stack stack) = stack := (v::(!stack))
    fun peek (Stack stack) = case !stack of
                       nil => (print ("stack: peeked from emptystack");
                               raise Imperative("stack: peeked from emptystack"))
                     | (h::_) => h
    fun pop (Stack stack) = case !stack of
                       nil => (print ("stack: pop from emptystack");
                               raise Imperative ("stack: pop from emptystack"))
                     | (h::t) => (stack:=t; h)
    fun is_on v (Stack stack) = is_in v (!stack)
    fun stack2list (Stack stack) = !stack
    
    
    (*** Marking ***)

    datatype 'a mark = Mark of 'a list ref
    
    fun init_mark l = Mark(ref l)
    fun empty_mark (Mark mark_list) = mark_list := nil
    fun is_marked a (Mark (ref l)) = is_in a l
    fun mark a (m as (Mark mark_list)) = if is_marked a m then ()
                                         else mark_list := (a::(!mark_list))
    fun unmark a (Mark mark_list) = mark_list := (remove a (!mark_list))
    fun next_marked (Mark (ref l)) = case l of
                          nil    => NONE
                        | (h::_) => SOME h
    

    (*** Simple tables ***)

    datatype ('a,'b) table = Table of ('a * 'b) list ref
    
    fun init_table l = Table(ref l)
    fun empty_table (Table arry) = arry := nil
    fun set (Table arry) idx v =
        let fun set' nil = [(idx,v)]
             |  set' ((e as (ix,_))::t) = if ix=idx then (ix,v)::t
                                             else e::(set' t)
        in
          arry := (set' (!arry))
        end
    fun get (Table arry) idx =
        let fun get' nil = raise Imperative ("get: out of bounds")
             |  get' ((e as (ix,v))::t) = if ix=idx then v else get' t
        in
          get' (!arry)
        end

  end (* functor Imperative *)
