signature DEPS =
  sig
    structure Graph : GRAPH
    structure Term : TERM
    structure Sign : SIGN
    structure Progtab : PROGTAB
    structure Constraints : CONSTRAINTS

    structure Switch : SWITCH

    (* Determine the levels for type families *)
    val level : Term.sign_entry -> int option
    val sign_levels : Sign.sign -> (string * int) list
    val print_levels : Sign.sign -> unit

    (* Determine dependencies between type families *)
    val graph_deps : Sign.sign -> string Graph.graph
    val print_graph_deps : Sign.sign -> unit
    val list_deps : Sign.sign -> string list list
    val print_list_deps : Sign.sign -> unit
    val clause_deps : Sign.sign -> (string * string * string list) list
    val print_clause_deps : Sign.sign -> unit

    (* Determine clauses in database whose head matches a query *)
    val print_progentry : Progtab.progentry -> unit
    val filter_rules : 
         (  Term.term list (* uvars *)
          * Term.term list (* evars *)
          * Term.term      (* ?x:A  *)
          * Term.term      (* A     *)
          * Term.term      (* !y..?z..D *)
          * Constraints.constraint)
      -> (Term.term * Progtab.progentry * Term.varbind list) list

  end
