(in-package 'spa)

;;;*******************************************************
;;;  input-plan NIL => ERROR!
;;;  lib-plan   NIL => let the system retrieve the library plan
;;;  debugging  NIL => no debug messages,
;;;                    don't intern plans
;;;  debugging true => debug messages, intern plans
;;;  manual-gc true => do a global GC before each planning episode.
;;;  note ....      => for the experimenter's documentation purposes:
;;;                      if non-NIL, put it on the end of the output.
;;;

;;;  Return values (a list):
;;;     Input problem name
;;;     Library problem name (NIL if generative)
;;;     Choose function name
;;;     Rank function name
;;;     Time to retrieve
;;;     Time to adapt
;;;     Queue iterations        (negative => plan incomplete)
;;;     Total nodes enqueued    (negative => plan incomplete)
;;;     Note, if any.
;;;     

(defun run-refit-experiment (&key (input-problem-name nil)
                                  (lib-problem-name nil)
                                  (choose-fun 'choose-open-first)
                                  (rank-fun 'last-goal-earliest)
                                  (debugging nil)
                                  (quietly nil)
                                  (manual-gc t)
                                  (note nil))
  (set-debug-parameters debugging)
  (when (not quietly)
    (format t "Start experiment for input ~a using library ~a~%"
          input-problem-name lib-problem-name)
    (format t "Condition choose is ~a~%" *extend-condition-chooser*))
  (setf *extend-condition-chooser* choose-fun)
  (let ((input-problem-entry (find-lib-entry input-problem-name))
        (lib-problem-entry (if (null lib-problem-name) 
                               nil 
                              (find-lib-entry lib-problem-name))))
    (when (null input-problem-entry)
      (error "Null input plan (or couldn't find it) for ~a" input-problem-name))
    (do-prelims (lib-entry-domain-name input-problem-entry) manual-gc quietly)
    (generate-library-plan lib-problem-entry quietly)
    (time-stat "Starting library refit for input problem ~a, lib problem ~a" 
               input-problem-name lib-problem-name)
    (multiple-value-bind (the-plan retrieve-time adapt-time)
                         (plan-from-library :problem-name input-problem-name
                                            :lib-hint lib-problem-name
                                            :rank-fun rank-fun)
      (when (and (null the-plan) (not quietly))
        (format t  "Warning: We didn't generate a plan!"))
      (when (not quietly)
        (format t "  Finished plan is ~a~%" the-plan))
      (let ((output-list 
             (list input-problem-name 
                   lib-problem-name 
                   choose-fun
                   rank-fun 
                   retrieve-time 
                   adapt-time 
                   (* (q-iplans-enqueued *the-queue*) (if the-plan 1 -1))
                   (* (q-iplans-dequeued *the-queue*) (if the-plan 1 -1)))))
        (if (null note) 
            output-list
            (append output-list (list note)))))))
  
;;;***************************************************

(defun run-generative-experiment (&key (problem-name nil)
                                       (choose-fun 'choose-open-first)
                                       (rank-fun 'last-goal-earliest)
                                       (debugging nil)
                                       (quietly nil)
                                       (manual-gc t)
                                       (note nil))
  (set-debug-parameters debugging)
  (when (not quietly)
    (format t "Start experiment for input ~a " problem-name)
    (format t "Condition choose is ~a~%" choose-fun))
  (setf *extend-condition-chooser* choose-fun)
  (let ((problem-entry (find-lib-entry problem-name)))
    (when (null problem-entry)
      (error "Null input plan (or couldn't find it) for ~a" problem-name))
    (do-prelims (lib-entry-domain-name problem-entry) manual-gc quietly)
    (time-stat "Starting generation for input problem ~a" problem-name)
    (multiple-value-bind (the-plan plan-time) 
        (plan-from-scratch :problem-name problem-name
                           :rank-fun rank-fun)
      (when (and (null the-plan) (not quietly))
        (format t  "Warning: We didn't generate a plan!~%"))
      (let ((output-list 
             (list problem-name 
                   nil                  ;lib problem name
                   choose-fun
                   rank-fun 
                   0                    ;adapt time
                   plan-time
                   (* (q-iplans-enqueued *the-queue*) (if the-plan 1 -1))
                   (* (q-iplans-dequeued *the-queue*) (if the-plan 1 -1)))))
        (if (null note)
            output-list
            (append output-list (list note)))))))

;;;*******************************************************************

(defun set-debug-parameters (debugging)
  (cond
   (debugging
    (setf *intern-plan-names* t)
    ;;(setf *save-cs* t)
    (add-debug :extend :retract :q))
   (t 
    (setf *intern-plan-names* nil)
    (setf *save-cs* nil)
    (un-debug))))

(defun do-prelims (domain manual-gc quietly)
  (set-gc-parameters manual-gc)
  (setq *cbr-iplan-limit* 750) 
  (setq *print-time-stat* (not quietly))
  (gc-etc manual-gc quietly)
  (load-domain domain))

(defun generate-library-plan (lib-plan-entry quietly)
  (when (not (lib-entry-stored-plan lib-plan-entry))
    (when (not quietly)
      (format t "Generating library plan ahead of time.~%"))
      (let ((the-plan (lib-entry-plan lib-plan-entry)))
        ;; this will generate the 
        ;; plan if it's not already there
        (declare (ignore the-plan))
        (when (null (lib-entry-stored-plan lib-plan-entry))
          (error "CHOKE! Library entry for ~a still not there!" lib-plan-entry))
        (when (not quietly)
          (format t "Done generating library plan.~%")))))

(defun gc-etc (manual-gc quietly)
  (when manual-gc
    (when (not quietly) (format t "Doing the prelim GC...~%"))
    (user::gc t)
    (when (not quietly) (format t "... done~%"))))

(defun set-gc-parameters (manual-gc)
;;;  (setf (sys:gsgc-parameter :generation-spread) 26)
  (setf (sys:gsgc-parameter :generation-spread) 15)
  (setf (sys:gsgc-switch :print) nil)
  (setf (sys:gsgc-switch :stats) nil)
  (setf excl:*global-gc-behavior* (if manual-gc :warn :auto)))


          
