(in-package 'spa)


(defvar *test-suite*
    '(4bs 8bs 6bs1 
      (8bs 5bs) (6bs1 3bs) (5bs 3bs1) (5bs1 4bs1)))

(defvar *rao-test-suite*)
(setf *rao-test-suite* 
  '((4bs1 3bs) (5bs1 3bs) (5bs1 4bs) (6bs1 4bs) (7bs1 5bs) 
      (8bs1 4bs1) (8bs1 4bs) (8bs1 5bs) (9bs1 6bs) (9bs1 7bs) (10bs1 4bs)
      (10bs1 7bs) (10bs1 8bs) (12bs1 3bs) (12bs1 5bs) (12bs1 10bs)))

(defvar *8bs-refit-suite*
    '(8bs (8bs 3bs) (8bs 4bs) (8bs 5bs) (8bs 6bs) (8bs 7bs) (8bs 8bs)))

(defvar *all-problems* 
    '(3bs 4bs 5bs 6bs 7bs 8bs 9bs 10bs 12bs
      3bs1 4bs1 5bs1 6bs1 7bs1 8bs1 9bs1 10bs1 12bs1      
      (8bs 3bs) (8bs 4bs) (8bs 5bs) (8bs 6bs) (8bs 7bs) (8bs 8bs)
      (8bs1 3bs) (8bs1 4bs) (8bs1 5bs) (8bs1 6bs) (8bs1 7bs) (8bs1 8bs)
      (8bs 3bs1) (8bs 4bs1) (8bs 5bs1) (8bs 6bs1) (8bs 7bs1) (8bs 8bs1)
      (8bs1 3bs1) (8bs1 4bs1) (8bs1 5bs1) (8bs1 6bs1) (8bs1 7bs1) (8bs1 8bs1)

      (6bs 3bs) (6bs 4bs) (6bs 5bs) (6bs 6bs) 
      (6bs1 3bs) (6bs1 4bs) (6bs1 5bs) (6bs1 6bs) 
      (6bs 3bs1) (6bs 4bs1) (6bs 5bs1) (6bs 6bs1) 
      (6bs1 3bs1) (6bs1 4bs1) (6bs1 5bs1) (6bs1 6bs1)))

(defvar *many-refits*)

(setf *many-refits* 
  '((6bs1 3bs) (6bs1 4bs) (6bs1 5bs) (6bs1 6bs)
    (10bs 3bs1) (10bs 4bs1) (10bs 5bs1) (10bs 6bs1) 
    (10bs 8bs1) (10bs 9bs1) (10bs 10bs)
    (8bs1 3bs1) (8bs1 4bs1) (8bs1 5bs1) (8bs1 6bs1) (8bs1 7bs1) (8bs1 8bs1)
    (8bs 3bs) (8bs 4bs) (8bs 5bs) (8bs 6bs) (8bs 7bs) (8bs 8bs)))

(defvar *generatives*)
(setf *generatives*
  '(4BS1 5BS1 6BS1 7BS1 8BS1 9BS1 10BS1 12BS1))

;;;**********************************************

(defvar *fitter*)

(defun run-single-problem (problem fitter choose-fun rank-fun)
  (setf *fitter* fitter)
  (if (symbolp problem)
      (run-generative-experiment :problem-name problem
                                 :choose-fun choose-fun
                                 :rank-fun rank-fun
                                 :debugging nil
                                 :manual-gc t
                                 :quietly t)
    (run-refit-experiment :input-problem-name (car problem)
                          :lib-problem-name (cadr problem) 
                          :choose-fun choose-fun
                          :rank-fun rank-fun
                          :debugging nil
                          :manual-gc t
                          :quietly t)))

;;;************

(defun run-experiments (&key problem-list 
                             (fitter     'bottom-up-fitter)
                             (choose-fun 'lge-open-first)
                             (rank-fun   'last-goal-earliest))
  (let ((output-list '()))
    (dolist (problem problem-list)
      (let ((this-result 
             (run-single-problem problem fitter choose-fun rank-fun)))
        (format t "~a~%" this-result)
        (push this-result output-list)))
    output-list))

;;;*********************

(defun run-trials (&key problem-list 
                        (iterations 1)
                        (fitter 'bottom-up-fitter)
                        (choose-fun 'lge-open-first)
                        (rank-fun   'last-goal-earliest))
  (let ((output-list '()))
    (dolist (problem problem-list)
      (dotimes (i iterations)
        (let ((this-result 
               (run-single-problem problem fitter choose-fun rank-fun)))
          (format t "~a~%" this-result)
          (push this-result output-list)))
      (format t "~%"))
    output-list))




      