;;;-*- Package: STANDARD-SYMBOLS; Mode: Lisp; Base: 10 -*-
 
;;; Copyright (c) 1992 by Xerox Corporation

(cl:defpackage :standard-symbols
  (:use :common-lisp :fsa)
  (:export :char-symbols :symbol-symbols :fixnum-symbols :standard-symbols))

(cl:in-package :standard-symbols)

;;;; CHAR-SYMBOLS: mixin for FSAs whose symbols are characters
(defclass char-symbols () ())
(defmethod symbol-order-fn ((fsa char-symbols))
  #'(lambda (c1 c2)
      (declare (character c1 c2) #.tdb:*highly-optimized*)
      (if (char= c1 c2)
	  :equal
	#+excl (and (char< c1 c2) t) #-excl(char< c1 c2))))

(defclass symbol-symbols () ())
(defmethod symbol-order-fn ((fsa symbol-symbols))
  #'(lambda (s1 s2)
      (declare (symbol s1 s2) #.tdb:*highly-optimized*)
      (if (string= s1 s2)
	  :equal
	(and (string< s1 s2) t))))

(defclass fixnum-symbols () ())
(defmethod symbol-order-fn ((fsa fixnum-symbols))
  #'(lambda (x y)
      (declare (fixnum x y) #.tdb:*highly-optimized*)
      (if (= x y) :equal (< x y))))

;;;; STANDARD-SYMBOLS: mixin for FSAs whose states are fixnums, chars
;;;; or strings
(defclass standard-symbols () ())
(defmethod symbol-order-fn ((fsa standard-symbols))
  #'(lambda (s1 s2)
      (declare #.tdb:*highly-optimized*)
      ;; sort chars before fixnums before strings
      (etypecase s1
	(character (etypecase s2
		     (character
		      (if (char= (the character s1) (the character s2))
			  :equal
			#+excl (and (char< (the character s1)
					   (the character s2)) t)
			#-excl (char< (the character s1) (the character s2))))
		     ((or fixnum simple-string) t)))
	(fixnum (etypecase s2
		  (character nil)
		  (fixnum  (if (= (the fixnum s1) (the fixnum s2))
			       :equal
			     (< (the fixnum s1) (the fixnum s2))))
		  (simple-string t)))
	(simple-string (etypecase s2
			 ((or character fixnum) nil)
			 (simple-string
			  (if (string= s1 s2) :equal
			    (and (string< s1 s2) t))))))))
