;;;-*- Package: TDB; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

;;; Copyright (c) 1989, 1990, 1991 by Xerox Corporation

(cl:in-package :tdb)

(eval-when (compile eval load)
  (use-package :cl-extensions))

(eval-when (compile eval load)
  (export '(corpus initialize-corpus open-corpus update-corpus close-corpus
	    open-doc close-doc byte28
	    doc-title display-doc
	    match-doc-titles do-titles
	    map-docs do-docs corpus-id-limit)))


;;;; corpus protocol

(defclass corpus () ())

;;; essential methods

(defgeneric map-docs (function corpus &key start end))

(defgeneric open-doc (id corpus))

;;; optional methods

(defgeneric initialize-corpus (corpus))
(defmethod initialize-corpus ((corpus corpus)) corpus)

(defgeneric open-corpus (corpus))
(defmethod open-corpus ((corpus corpus)) corpus)

(defgeneric update-corpus (corpus))
(defmethod update-corpus ((corpus corpus)))

(defgeneric close-corpus (corpus))
(defmethod close-corpus ((corpus corpus)))

(defgeneric corpus-id-limit (corpus))
(defmethod corpus-id-limit ((corpus corpus))
  (let ((limit 0))
    (map-docs #'(lambda (id) (setq limit id)) corpus)
    (1+ limit)))

(defgeneric close-doc (stream id corpus))
(defmethod close-doc (stream id (corpus corpus))
  (declare (ignore stream id))
  nil)

(defgeneric display-doc (id corpus device))
(defmethod display-doc (id (corpus corpus) (device stream))
  (multiple-value-bind (doc-stream start-pos end-pos)
      (open-doc id corpus)
    (unwind-protect
	(progn (when start-pos
		 (file-position doc-stream start-pos))
	       (dotimes (i (- (or end-pos (file-length doc-stream))
			      (or start-pos (file-position doc-stream))))
		 (write-char (read-char doc-stream) device)))
      (close-doc doc-stream id corpus))))

(defgeneric doc-title (id corpus))
(defmethod doc-title (id (corpus corpus))
  (format nil "~D" id))

(defgeneric match-doc-titles (function title corpus))
;; Calls FUNCTION on the IDs of docs in CORPUS which are titled TITLE.
;; The default implementation just does a linear search.
(defmethod match-doc-titles (function title (corpus corpus))
  (map-docs #'(lambda (id)
		(when (string= title (doc-title id corpus))
		  (funcall function id)))
	    corpus))



;;; some handy macros

(defmacro do-docs ((id corpus &key start end) &body body)
  `(block do-docs
     (map-docs #'(lambda (,id) (declare (type byte28 ,id)) ,@body)
	       ,corpus :start ,start :end ,end)))

(defmacro do-titles ((id title corpus) &body body)
  `(block do-titles
     (match-doc-titles #'(lambda (,id) (declare (type byte28 ,id)) ,@body)
		       ,title ,corpus)))
