/* $Revision: 1.1 $ */
typedef struct bucket {
    char		*key;	/* search key */
    int			hashval;/* result of hash(key) */
    char		*data;	/* secret data */
    struct bucket	*next;	/* next bucket */
} hashbucket;

typedef struct {
    int		size;	/* number of buckets */
    int 	count;	/* number filled */
    hashbucket	**buf;	/* buckets */
    int		dump_index;
    hashbucket  *dump_bucket;
} hashtable;

extern hashtable *NewHash();	/* ( size ) [power of 2] */
extern char *LookupHash();	/* ( h, key ) (returns NULL if not found) */
extern void InsertHash();	/* ( h, key, data ) */
extern void FreeHash();		/* ( h ) */
extern void InitDumpHash();	/* ( h ) */
extern hashbucket *DumpHash();	/* ( h ) */
