/*  SPANISH  DICTIONARY  */ 
/*  9 . 11 . 87 . */ 
 
/*  STANDARD  ENDINGS  */ 
 
info(gp_end,[[gender(m),plurality(s)],[gender(m),plurality(p)],[gender(f),plurality(s)],[gender(f),plurality(p)]],[],[]). 
 
ending_type(gp_end,["o","os","a","as"],[]). 
 
/*  NOUNS  */ 
 
info(noun,[[plurality(s)],[plurality(p)]],[gender],[person(3)]). 
 
word("",["barco"],noun,["","s"],[m]). 
word("",["banco"],noun,["","s"],[f]). 
word("",["gato"],noun,["","s"],[m]). 
word("",["perro"],noun,["","s"],[m]).
word("",["iglesa"],noun,["","s"],[f]).
word("",["mujer"],noun,["","es"],[f]). 
word("",["chica"],noun,["","s"],[f]). 
word("",["chico"],noun,["","s"],[m]). 
word("",["hombre"],noun,["","s"],[m]). 
word("",["libro"],noun,["","s"],[m]). 
word("",["mano"],noun,["","s"],[f]).
word("",["casa"],noun,["","s"],[f]).
word("",["madre"],noun,["","s"],[f]).
word("",["mat"],noun,["","s"],[m]). 
word("",["mensonge"],noun,["","s"],[f]). 
word("",["padre"],noun,["","s"],[m]).
word("",["boli1grafo"],noun,["","s"],[m]). 
word("",["manzana"],noun,["","s"],[f]). 
word("",["tia"],noun,["","s"],[f]). 
word("",["viaje"],noun,["","s"],[m]). 
word("",["vaso"],noun,["","s"],[m]). 
word("",["piscina"],noun,["","s"],[f]).

word("",["sabado"],noun,["","s"],[m]).
word("",["manana"],noun,["","s"],[f]).

/*  PRONOUNS  */ 
 
info(pronoun,[ 
[case(nom),apostrophe(n),order(1)],
[case(acc),apostrophe(n),pp_agree(y),order(2)],
[case(dat),apostrophe(n),order(3)],
[case(dat),order(4)],
[case(acc),order(5)] 
],[person,plurality,gender],[]). 
 
word("yo",[""],pronoun,["yo","me","me","mi1",""],[1,s,any]). 
word("tu",[""],pronoun,["tu","te","te","ti1",""],[2,s,any]). 
word("el",[""],pronoun,["e1l","le","le","e1l","lo"],[3,s,m]). 
word("ella",[""],pronoun,["ella","la","la","ella","le"],[3,s,f]). 
word("nosotros",[""],pronoun,["nosotros","nos","nos","nosotros","nos"],[1,p,any]). 
word("vosotros",[""],pronoun,["vosotros","os","os","","vosotros"],[2,p,any]). 
word("ellos",[""],pronoun,["ellos","los","les","","les"],[3,p,m]). 
word("ellas",[""],pronoun,["ellas","las","les","","las"],[3,p,f]). 

word("vd",[""],pronoun,["","","","y",""],[3,s,any]). 
word("vds",[""],pronoun,["","","","","en"],[3,p,any]). 


 /* REFLEXIVE  PRONOUNS */   
info(reflexive_pronoun,[[apostrophe(n)],[apostrophe(y)]],[person,plurality],[]).
word("me",[""],reflexive_pronoun,["me",""],[1,s]).
word("te",[""],reflexive_pronoun,["te",""],[2,s]).
word("se",[""],reflexive_pronoun,["se",""],[3,s]).
word("nos",[""],reflexive_pronoun,["nos",""],[1,p]).
word("vos",[""],reflexive_pronoun,["vos",""],[2,p]).
word("se",[""],reflexive_pronoun,["se",""],[3,p]).


/* ADJECTIVES */

info(adjective,[[gender(m),plurality(s)],[gender(m),plurality(p)],[gender(f),plurality(s)],[gender(f),plurality(p)]],[position],[]).

word("",["grand"],adjective,["e","es","e","es"],[any]). 
word("",["feli"],adjective,["z","ces","z","ces"],[post]). 
word("",["nuev"],adjective,gp_end,[post]). 
word("",["pequen"],adjective,gp_end,[post]). 
word("",["blanc"],adjective,gp_end,[post]). 
word("",["tranquil"],adjective,gp_end,[post]). 
word("",["content"],adjective,gp_end,[post]). 
word("",["inteligent"],adjective,["e","es","e","es"],[post]). 
word("",["fe"],adjective,gp_end,[post]). 
word("",["despacio"],adjective,["","","",''],[post]). 
word("",["rapid"],adjective,gp_end,[post]). 
word("",["tont"],adjective,gp_end,[post]). 
word("",["verd"],adjective,["e","es","e","es"],[post]). 

/*
 POSSESSIVE ADJECTIVES 
*/

info(poss_adjective,[[gender(m),plurality(s)],[gender(m),plurality(p)],[gender(f),plurality(s)],[gender(f),plurality(p)]],[position],[]).


 
word("",["mi"],poss_adjective,["","s","","s"],[pre]). 
word("",["tu"],poss_adjective,["","s","","s"],[pre]).
word("",["su"],poss_adjective,["","s","","s"],[pre]).
word("",["nuestr"],poss_adjective,gp_end,[pre]).
word("",["vuestr"],poss_adjective,gp_end,[pre]).
word("",["su"],poss_adjective,["","s","","s"],[pre]).


/*  ADVERBS  */ 
 
info(adverb,[],[],[]). 
 
word("",["constantamente"],adverb,[],[]). 
word("",["lentamente"],adverb,[],[]). 
word("",["rapidamente"],adverb,[],[]). 
word("",["tranquilamente"],adverb,[],[]). 
 
/*  DETERMINERS  */ 
 
info(determiner,[[gender(m),plurality(s)],[gender(m),plurality(p)],
[gender(f),plurality(s)],[gender(f),plurality(p)]],[],[]). 
 
word("el",[""],determiner,["el","los","la","las"],[]). 
word("un",[""],determiner,["un","unos","una","unas"],[]). 
 
/* CONJUNCTIONS */

info(conjunction,[[]],[],[]).

word("",["y"],conjunction,[""],[]).

       /*  VERBS  */ 

info(verb,[type],[transitivity,follow_prepos,can_be_reflex],[]). 
 
word("gustar",["gust"],verb,ar_end,[t,["a",""],y]).      /* Regular AR Verbs*/
word("llegar",["llega"],verb,ar_end,[i,[],n]). 
word("cantar",["cant"],verb,ar_end,[i,[],n]). 
word("comenzar",["comenc"],verb,c_ar_end,[t,["a","par"],n]). 
word("lavar",["lav"],verb,ar_end,[t,[],y]). 
word("andar",["and"],verb,ar_end,[i,[],n]). 
word("hablar",["habl"],verb,ar_end,[i,[],y]). 
word("viajar",["viaj"],verb,ar_end,[i,[],n]). 
word("terminar",["termin"],verb,ar_end,[t,["de"],n]). 
word("trabajar",["trabaj"],verb,ar_end,[i,[""],n]). 
                                                         /* Regular IR Verbs */
word("salir",["sal"],verb,ir_end_16,[i,[],n]).           /*salgo*/
word("decidir",["decid"],verb,ir_end,[t,["de"],n]). 

word("entender",["entend"],verb,er_end,[t,[""],n]).      /* Regular ER Verbs */
word("correr",["corr"],verb,er_end_11,[i,[],n]). 
word("comer",["com"],verb,er_end,[t,[],n]). 
							/*Irregular Verbs*/

word("hacer",["h"],verb,hacer_end,[t,[],n]). 
word("dar",["d"],verb,ar_end,[t,[],y]). 
word("ver",[""],verb,ver_end,[t,[""],y]). 
word("ir",[""],verb,go_end,[i,[""],n]). 


/*  VERB  ENDINGS  */ 

/*  Irregular & regular ER Verb Endings */
 
info(er_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

actual_endings(er_end_pres,["o","es","e","emos","e1is","en"]). 
actual_endings(er_end_imp,["i1a","i1as","i1a","i1amos","i1ais","i1an"]). 
actual_endings(er_end_fut,["ere1","era1s","era1","eremos","ere1is","era1n"]). 
actual_endings(er_end_cond,["eri1a","eri1as","eri1a","eri1amos","eri1ais","eri1an"]). 
 
ending_type(er_end,er_end_pres,[present]). 
ending_type(er_end,er_end_imp,[imperfect]). 
ending_type(er_end,er_end_fut,[future]). 
ending_type(er_end,er_end_cond,[conditional]). 

/* 
info(g_er_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

actual_endings(g_er_end_pres,["e","es","e","eons","ez","ent"]). 
actual_endings(g_er_end_imp,["eais","eais","eait","ions","iez","eaient"]). 
ending_type(g_er_end,g_er_end_pres,[present]). 
ending_type(g_er_end,g_er_end_imp,[imperfect]). 
ending_type(g_er_end,er_end_fut,[future]). 
ending_type(g_er_end,er_end_cond,[conditional]). 

info(c_er_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

actual_endings(c_er_end_pres,["e","es","e","3ons","ez","ent"]). 
actual_endings(c_er_end_imp,["3ais","3ais","3ait","ions","iez","3aient"]). 
 
ending_type(c_er_end,c_er_end_pres,[present]). 
ending_type(c_er_end,c_er_end_imp,[imperfect]). 
ending_type(c_er_end,er_end_fut,[future]). 
ending_type(c_er_end,er_end_cond,[conditional]). 
*/

/* Irregular & Regular IR Verb Endings */

info(ir_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

actual_endings(ir_end_pres,["o","es","e","imos","i1s","en"]). 
actual_endings(ir_end_imp,["i1a","i1as","i1a","i1amos","i1ais","i1an"]). 
actual_endings(ir_end_fut,["ire1","ira1s","ira1","iremos","ire1is","ira1n"]). 
actual_endings(ir_end_cond,["iri1a","iri1as","iri1a","iri1amos","iri1ais","iri1an"]). 
 
ending_type(ir_end,ir_end_pres,[present]). 
ending_type(ir_end,ir_end_imp,[imperfect]). 
ending_type(ir_end,ir_end_fut,[future]). 
ending_type(ir_end,ir_end_cond,[conditional]). 

/* 
info(ir_end_11,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

actual_endings(ir_end_11_pres,["s","s","t","ons","ez","ent"]). 
actual_endings(ir_end_11_fut,["rrai","rras","rra","rrons","rrez","rront"]). 
actual_endings(ir_end_11_cond,["rrais","rrais","rrait","rrions","rriez","rraient"]). 
 
ending_type(ir_end_11,ir_end_11_pres,[present]). 
ending_type(ir_end_11,er_end_imp,[imperfect]). 
ending_type(ir_end_11,ir_end_11_fut,[future]). 
ending_type(ir_end_11,ir_end_11_cond,[conditional]). 

 
info(ir_end_16,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

actual_endings(ir_end_16_pres,["s","s","t","tons","tez","tent"]). 
actual_endings(ir_end_16_imp,["tais","tais","tait","tions","tiez","taient"]). 
actual_endings(ir_end_16_fut,["tirai","tiras","tira","tirons","tirez","tiront"]). 
actual_endings(ir_end_16_cond,["tirais","tirais","tirait","tirions","tiriez","tiraient"]). 
 
ending_type(ir_end_16,ir_end_16_pres,[present]). 
ending_type(ir_end_16,ir_end_16_imp,[imperfect]). 
ending_type(ir_end_16,ir_end_16_fut,[future]). 
ending_type(ir_end_16,ir_end_16_cond,[conditional]). 
*/

/* AR Verb Endings: regular & irregular */

info(ar_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

actual_endings(ar_end_pres,["o","as","a","amos","a1is","an"]). 
actual_endings(ar_end_fut,["ara1","ara1s","ara1","aremos","are1is","ara1n"]). 
actual_endings(ar_end_cond,["ara1","ara1s","ara1","aremos","are1is","ara1n"]). 
 
ending_type(ar_end,ar_end_pres,[present]). 
ending_type(ar_end,er_end_imp,[imperfect]). 
ending_type(ar_end,ar_end_fut,[future]). 
ending_type(ar_end,er_end_cond,[conditional]). 

 
/* Irregular Verb Endings - compound exceptions! */

info(go_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

ending_type(go_end,["voy","vas","va","vamos","vais","van"],[present]). 
ending_type(go_end,["iba","ibas","iba","iba1mos","ibais","iban"],[imperfect]). 
ending_type(go_end,["ire1","ire1s","ira1","iremos","ire1is","ira1n"],[future]). 
ending_type(go_end,["iri1a","iri1as","iri1a","iri1amos","irai1s","iri1an"],[conditional]). 
 
info(hacer_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

ending_type(hacer_end,["hago","haces","hace","hacemos","hace1is","hacen"],[present]). 
ending_type(hacer_end,["haci1a","haci1as","haci1a","haciamos","hacais","haci1an"],[imperfect]). 
ending_type(hacer_end,["hare1","hara1s","hara1","haceremos","hacereis","hara1n"],[future]). 
ending_type(hacer_end,["hari1a","haria1s","hari1a","hari1amos","hari1ais","hari1an"],[conditional]). 
 
info(haber_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)], 
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]). 

ending_type(haber_end,["he","has","ha","hemos","habe1is","han"],[present]). 
ending_type(haber_end,["habi1a","habi1as","habi1a","habi1amos","habi1ais","habi1ant"],[imperfect]). 
ending_type(haber_end,["habre1","habra1s","habra1","habremos","habre1is","habra1n"],[future]). 
ending_type(haber_end,["habri1a","habri1as","habri1a","habri1amos","habri1ais","habri1an"],[conditional]). 
 
/*  AUXILIARY  VERBS  */ 
info(aux_verb,[ 
[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)] 
],[tense,transitivity],[]). 
 
word("tener",[""],aux_verb,["tengo","tienes","tiene","tenemos","tene1is","tienen"],[present,t]).
word("tener",[""],aux_verb,["teni1a","teni1as","teni1a","teni1amos","teni1ais","teni1an"],[imperfect,t]).
word("tener",[""],aux_verb,["tendre1","tendra1s","tendra1","tendremos","tendre1is","tendra1n"],[future,t]).
word("tener",[""],aux_verb,["tendri1a","tendri1as","tendri1a","tendri1amos","tendri1ais","tendri1an"],[conditional,t]).

word("estar",[""],aux_verb,["estoy","estas","esta","estamos","esta1is","esta1n"],[present,i]).
word("estar",[""],aux_verb,["estaba","estabas","estaba","esta1bamos","estabais","estaban"],[imperfect,i]).
word("estar",[""],aux_verb,["estare1","estara1s","estara1","estaremos","estareis","estara1n"],[future,i]).
word("estar",[""],aux_verb,["estari1a","estari1as","estari1a","estari1amos","estari1ais","estari1an"],[conditional,i]).
 
word("ser",[""],aux_verb,["soy","eres","es","somos","sois","son"],[present,i]).
word("ser",[""],aux_verb,["era","eras","era","e1ramos","erais","eran"],[imperfect,i]).
word("ser",[""],aux_verb,["sere1","sera1s","sera","seremos","sere1is","sera1n"],[future,i]).
word("ser",[""],aux_verb,["seri1a","seri1as","seri1a","seri1amos","seri1ais","seri1an"],[conditional,i]).



/*  PAST  PARTICIPLES  */ 
 
info(past_participle,[[gender(m),plurality(s)],[gender(m),plurality(p)],[gender(f),plurality(s)],[gender(f),plurality(p)]],[conjug_with,transitivity,follow_prepos,can_be_reflex],[]). 
 
word("",["gustado"],past_participle,gp_end,[haber,t,["a",""],y]). 
word("",["ir"],past_participle,gp_end,[haber,i,[""],n]). 
word("",["llegado"],past_participle,gp_end,[haber,i,["a"],n]). 
word("",["canta"],past_participle,gp_end,[haber,t,[],n]). 
word("",["comence"],past_participle,gp_end,[haber,t,["a","de"],n]). 
word("",["corr"],past_participle,gp_end,[haber,i,[],n]). 
word("",["hace"],past_participle,gp_end,[haber,t,[],n]). 
word("",["termin"],past_participle,gp_end,[haber,t,["de"],n]). 
word("",["decidi"],past_participle,gp_end,[haber,t,["de"],y]). 
word("",["entend"],past_participle,gp_end,[haber,t,[""],n]). 
word("",["lav"],past_participle,gp_end,[haber,t,[],y]). 
word("",["comido"],past_participle,gp_end,[haber,t,[],n]). 
word("",["and"],past_participle,gp_end,[haber,i,[],n]). 
word("",["hablado"],past_participle,gp_end,[haber,t,[],y]). 
/*word("",["parti"],past_participle,gp_end,[haber,i,[],n]). */
word("",["sali"],past_participle,gp_end,[haber,i,[],n]). 
word("",["viajado"],past_participle,gp_end,[haber,i,[],n]). 

word("",["visto"],past_participle,gp_end,[haber,t,["a"],n]). 
word("",["dado"],past_participle,gp_end,[haber,t,["a"],y]). 
word("",["escuch"],past_participle,gp_end,[haber,t,["a"],y]).


/*  INFINITIVES  */ 
 
info(infinitive,[[gender(m),plurality(s)],[gender(m),plurality(p)],[gender(f),plurality(s)],[gender(f),plurality(p)]],[transitivity,follow_prepos],[]). 
 
word("",["gustar"],infinitive,[],[t,["a",""],y]). 
word("",["ir"],infinitive,[],[i,[""],n]). 
word("",["llegar"],infinitive,[],[i,["a"],n]). 
word("",["cantar"],infinitive,[],[i,[],n]). 
word("",["comenzar"],infinitive,[],[t,["a","par"],n]). 
word("",["correr"],infinitive,[],[i,[],n]). 
word("",["decidir"],infinitive,[],[t,["de"],n]). 
word("",["dar"],infinitive,[],[t,["a"],y]). 
word("",["entender"],infinitive,[],[t,[""],n]). 
word("",["hacer	"],infinitive,[],[t,[],n]). 
word("",["terminar"],infinitive,[],[t,["de"],n]). 
word("",["lavar"],infinitive,[],[r,[],y]). 
word("",["comer"],infinitive,[],[t,[],n]). 
word("",["andar"],infinitive,[],[i,[],n]). 
word("",["hablar"],infinitive,[],[i,[],y]). 
/*word("",["partir"],infinitive,[],[i,[],n]). */
word("",["salir"],infinitive,[],[i,[],n]). 
word("",["viajar"],infinitive,[],[i,[],n]). 
word("",["ver"],infinitive,[],[t,["a"],y]). 
word("",["escuchar"],infinitive,[],[t,[""],y]). 


/*  NEGATIVE  CONSTRUCTS  */ 
 
info(neg_begin,[[apostrophe(n)],[apostrophe(y)]],[],[]). 
 
word("no",[""],neg_begin,["no",""],[]). 
 
info(neg_end,[[]],[],[]). 
 
word("nunca",[""],neg_end,["nunca"],[]). 
word("nada",[""],neg_end,["nada"],[]). 
word("nadie",[""],neg_end,["nadie"],[]).
word("ningu1n",[""],neg_beg,["ningun"],[]). 
 
/*  PREPOSITIONS  */ 
 
info(preposition,[[]],[],[]). 
 
word("a",[""],preposition,["a"],[]). 
word("de",[""],preposition,["de"],[]). 
word("en",[""],preposition,["en"],[]). 

word("por",[""],preposition,["por"],[]).
word("para",[""],preposition,["para"],[]).

word("lejos",[""],preposition,["lejos"],[]).
word("cerca",[""],preposition,["cerca"],[]). 
word("encima",[""],preposition,["encima"],[]).
word("dentro",[""],preposition,["dentro"],[]). 
word("sobre",[""],preposition,["sobre"],[]). 

/*  RELATIVES  */
/* cuyo , aquellos, qiees, estos etc */

info(relative_subject,[[]],[],[]).

word("quien",[""],relative_subject,["quien"],[]).

info(relative_object_que,[[apostrophe(n)],[apostrophe(y)]],[],[]).

word("que",[""],relative_object_que,["que","qu'"],[]).

info(relative_object_si,[[apostrophe(n)],[apostrophe(y)]],[],[]).

word("si",[""],relative_object_si,["si","s'"],[]).

/*  GUESS  CLASS  */

open1(noun).
open1(adjective).
open1(adverb).
open1(verb).
open1(past_participle).
open1(infinitive).

insert_type(noun).
insert_type(adjective).
insert_type(verb).
insert_type(adverb).
insert_type(past_participle).
insert_type(infinitive).
insert_type(determiner).
insert_type(pronoun).
insert_type(reflexive_pronoun).
insert_type(relative_subject).
insert_type(relative_object_que).
insert_type(relative_object_si).
insert_type(aux_verb).
insert_type(preposition).
insert_type(neg_begin).
insert_type(neg_end).

