/*  LINGER  SHELL FOR AN IBM */ 
/*  1/88 */ 
/* *************************************************************************
To Run :
	program has been adapted to word in PROLOG2 , and therefore shall
	nolonger work in CPROLOG.
	program needs language files. 
	program needs files interpre.pro and
                            input. pro.
        type "run." to start Linger.

 ***************************************************************************
Changes :
	open ---> open1
	once ---> once1
* 	name ---> name2
	run2 ---> has been extended it now guards against one word sentences,
		  and exits on certain termination words as defined in
		  exit_words (EOF).
	some assertz re. found() and possibility() ---> assert_once_into_db
*	get_actual_endings ---> get_actual_endings2 (BUT, not everywhere).
*	ending_type ---> get_ending_type
* 	word ---> get_word (interprets db)
	tidy ---> trimcore,stack,global and local.
        vowel_type ---> vowel(V), vowels ( those requiring apost.)
			are now stored in dictionary to increase lang.
			independence.(is_letter_type).
        change_word - adapted to input string .

	Also, some more debugging aids defined in Debug.pro
	   
new files : debug.pro , interpre.pro , french_dic is now frenchd.pro , and
	    french_gram is now frenchg.pro

*********************************************************************** 
To Add Language :
1.	define language in "available_lang(_)".
	eg. for Dutch -- available_lang(dutch).
2.      name grammar -- dutchg.pro
	name dictionary -- dutchd.pro
3.      The dictionary and Grammar should be in the same format as
	defined in thesis of Barchan.
4.      Define what is considered a "vowel" ( ie. those letters which needs
	apostrophe's when they meet eg. vowel and 'h' -- l'homme).
 ********************************************************************* */

/*  **********  INITIALISATIONS  **********  */ 

:- consult('debug.pro').
/*   write('debug consulted'),nl.*/
:-consult('interpre.pro').
/*   write('interpre.pro consulted'),nl.*/
:- consult('input').
/*   write('input consulted'),nl. */ 
:- consult('name.pro').

:-      nl,nl,nl,
	date(D,M,Y),
	time(H,MM,S),
	tab(10),write('     Date : '),write(D),write(' / '),
	write(M),write(' / '),write(Y),nl,
	tab(10),write('     Time : '),write(H),write(' : '),
	write(MM),write(' : '),write(S),nl,nl,nl.


get_language_files :-
       get_language(Lang),

	X is_string Lang & "d.pro", /* p */
	Y is_string Lang & "g.pro",
	consult(Y),
	tab(10),write('consulting Grammar'),nl,
	consult(X),
	tab(10),write('consulting Dictionary'),nl.
	

get_language(Lang) :-
  repeat, 
    nl,write('What language do you want (french/english/german/spanish/italian)?'),
    nl,write('         ==> '),
    read(Lang),nl,nl,
    nonvar(Lang),
    available_lang(Lang), 
    !.


available_lang(french). /* user defined */
available_lang(english).
available_lang(spanish).
 
/*  **********  MAIN  PROGRAM  **********  */ 
 
run :- 
    initialisation, 
    repeat, 
    enter_sentence(Sent),  
    run2(Sent). 

initialisation :-
    languages_consulted,
    !.
initialisation :-
    nl,nl,write('LINGER  --  Language INdependent Grammatical Error Reporter'),nl,nl,
    get_language_files,
    asserta(languages_consulted).
 

/* paul */

run2([X]):-
	length([X],1),
	exit_words(Y),
	member(X,Y),nl,nl,
	write('           BYE '),nl,nl.

run2(X):-
	length(X,1),nl,nl,
	write(' That is a pathetic sentence ..... '),nl,
        write('          TRY AGAIN ! '),nl,nl,nl,
        run.

run2(Sent) :- 
/*    test_type_list(Sent),*/  /*debugging clause for testing */ 

    abolish(count,2),
    abolish(found,9), 
    abolish(possibility,8), 
    nl,write('Pre-parsing sentence'),nl,
    pre_parse(Sent,0), 
/* 	what_assert,nl,  */
/*	tidy,            */
    abolish(tree,2), 
    abolish(parse_poss,10),nl,
    parse(Sent),
	tidy,nl, 
    choose_correct_sentence(Sent,1),
        tidy,
    nl,write('Another go ? '),nl,nl,

	write('        ==> '),
	read(A), 
    !, 
      (exit_words(E),member(A,E)).	

run2(_) :- 
    nl,write('SORRY : Program unable to parse this sentence'),nl,nl, 
    fail.
 
/*  **********  PRE-PARSE  PHASE  **********  */ 
/* ******************************************************************
		pre_parse(+,+)
		pre_parse(sentence as list of words,0)

New_word_pos = each word is awarded a position with which to identify
	it with.
guess_all_founds_and_possibilities = takes ASkii list of word and its 
	position and asserts data regarding each word into D-B, one word
	can have many entries.
pre_parse = then sends the tail of sentence around for same treatment.
******************************************************************* */

pre_parse([],_).
/*	what_in_db. */ /* paul - what possibilities and founds exist */
pre_parse([Word|Rest],Word_pos) :- 
    New_word_pos is (Word_pos + 1), 
    name2(Word,List_word), 
    guess_all_founds_and_possibilities(List_word,_,New_word_pos), 
    pre_parse(Rest,New_word_pos). 

/* **********************************************************************
guess_all_found_and_possibilities(+,-,+).
guess_all_founds_and_possibilities(List (Askii) of word,-,position).

look_up_word = accesses data from dictionary that is appropriate to the 
	input word. (VERY INEFFICIENT NEEDS CHANGING).
	look_up_word(+,-,-,-,-,-,-,-).
fail = ensures all data re. word is found.
******************************************************************** */


guess_all_founds_and_possibilities(List_word,Ref_word,Word_pos) :- 
    look_up_word(List_word,Ref_word,Root_found,Type,Endings,Infos,Ending,Poss_root_list), 
    name2(Atom_word,List_word), 
    assert_once_into_db(found(Atom_word,List_word,Ref_word,Type,Root_found,Ending,Endings,Infos,Word_pos)), 
    calc_info(Ending_poss,Endings,Infos,Type,Calc_info), 
    choose_correct_root(Poss_root_list,Calc_info,Right_root), 
    append(Right_root,Ending_poss,List_word_poss), 
    List_word_poss \== [],
    name2(Atom_word_poss,List_word_poss), 
    assert_once_into_db(possibility(Atom_word_poss,List_word_poss,Ref_word,Type,Right_root,Ending_poss,Calc_info,Word_pos)), 
    fail. 

    guess_all_founds_and_possibilities(_,_,_).
 
/* look_up_word(+,-...-) */ 
/* ***************************************************************
   get_word -gets word from dictionary (any word !),
	     look_up_word2 then takes word and tries to match with input word
	     if this and the procedure succeeds then	
	     back at guess_all.. found() data asserted.
*********************************************************************** */

look_up_word(List_word,Ref_word,Root,Type,Endings,Infos,Ending,Poss_root_list) :- 
/* paul -   word(Ref_word1,Poss_root_list,Type,Endings,Infos),*/ 
    get_word(Ref_word1,Poss_root_list,Type,Endings,Infos),
    look_up_word2(List_word,Root,Endings,Ending,Poss_root_list), 
    asserta_only_once(at_least_one_possibility_1),
    generate_right_ref_word(Ref_word1,Poss_root_list,Ref_word). 
look_up_word(_,_,_,_,_,_,_,_) :-
    retract(at_least_one_possibility_1),
    !,
    fail.

look_up_word(List_word,List_word,List_word,Type,[],[unknown(Type)],
[],[List_word]) :-
	    open1(Type). 
	/* [] = "" */

/*paul -  inserted 1 to open as it is a system predicate 
	look also at french-g and open*/
/* ***************************************************************
	look_up_word2(+,-,+,-,+)
	look_up_word2(word list,-,endings got from get_word,-,[[]]).

If word from dictionary the right one , it will match the sentence
word  - therefore each ending in turn is put onto each possible root
(involving look_up_word3(+,+), in a 'mess' of a procedure , and the 
results matched with the sentence word - this either fails or succeeds.
failure ----> get another word form dict. on backtracking
success ----> asssert data in top clause and go for next word.
**************************************************************** */
 
look_up_word2(List_word,[],Endings,List_word,[[]]) :-    !,
    look_up_word3(List_word,Endings).
/* []="",[[]]=[""] */

look_up_word2(List_word,Root,_,Ending,Poss_root_list) :- 
    member(Root,Poss_root_list), 
    append(Root,Ending,List_word), 
    !. 

look_up_word3(List_word,Endings) :- 
    member(List_word,Endings), 
    !.
look_up_word3(List_word,Ending_type) :- 
    get_ending_type(Ending_type,Endings1,_), 
    get_actual_endings(Endings1,Endings),
    member(List_word,Endings),
/* name2(Word,List_word),
write('word:  '),write(Word),nl,
write('endings:  '),write(Endings),nl,
write('ending_type:  '),write(Ending_type),nl,
write('endings1:  '),write(Endings1),nl,  */
    !.
 
generate_right_ref_word([],[First_root|_],First_root) :- !. 
	/* []=""*/
generate_right_ref_word(Ref_word,_,Ref_word). 

/* ***************************************************************
	calc_info(?)

Attempts to get all the rest of the data about a certain word entry
from the dictionary.
Hence, that info that can be deemed "general" is stroed in clause info(),
and accessed when the appropriate catagory is found.

get_actual_endings
get_ending_type    both go through my interpreter to interface w dict.
********************************************************************* */
 
calc_info([],[],[unknown(Type)],_,[unknown(Type)|Global]) :- 
    info(Type,_,_,Global),
    !.
/* 1st param []="" */

calc_info([],[],[inserted(Type)],_,[inserted(Type)|Global]) :-
    info(Type,_,_,Global),!.
	/* []="" only 1st paramter */
    
calc_info(Ending,Endings,Infos,Type,Calc_info) :- 
    info(Type,Individ_info,Gen_info,Global), 
    calc_gen_info(Gen_info,Infos,General), 
    calc_individ_info(Ending,Endings,Individ_info,Individual), 
    append(Global,General,Calc_info1), 
    append(Calc_info1,Individual,Calc_info). 
 
calc_individ_info([],[],_,[]) :- !. /* []="" only 1st param */  
calc_individ_info(Ending,Ending_type,_,Calc_info) :- 
    atom(Ending_type), 
    !, 
    calc_individ_info_ending_type(Ending,Ending_type,Calc_info). 
calc_individ_info(Ending,Endings,Individ_info,Calc_info) :- 
    double_list_member(Ending,Endings,Individ_info,Calc_info). 
 
calc_individ_info_ending_type(Ending,Ending_type,Calc_info) :- 
    info(Ending_type,Individ_info,Gen_info,Global_info), 
/* */ get_ending_type(Ending_type,Endings1,Endings_info), 
    get_actual_endings(Endings1,Endings),
    double_list_to_term_list(Gen_info,Endings_info,Gen_info2), 
    calc_individ_info(Ending,Endings,Individ_info,Calc_info1), 
    append(Calc_info1,Gen_info2,Calc_info2), 
    append(Calc_info2,Global_info,Calc_info). 

get_actual_endings(Actual_endings_name,Endings) :-
    get_actual_endings2(Actual_endings_name,Endings),
    !.
/* */
get_actual_endings(Endings,Endings).
 
calc_gen_info(Gen_info,Infos,Result):- 
    double_list_to_term_list(Gen_info,Infos,Result), 
    !. 
calc_gen_info(_,_,[]). 
/* ********************************
choose_correct_root(+,+,-)
- select possible roots.
********************************** */
 
choose_correct_root(Poss_root_list,Calc_info,Root) :- 
    member(root(Root_num),Calc_info), 
    list_element_number(Poss_root_list,Root_num,Root), 
    !. 
choose_correct_root([Root|_],_,Root). 

/* ************************************************************************
   *********************************************************************** */
 
/*  **********  PARSE  PHASE  **********  */ 
/* parse(+) - all the rest asserted ! */
 
parse(Sent) :- 
    asserta(count(parse_num,0)), 
    try_parse(Sent,Tree), 
    increment(parse_num,PN), 
    asserta(tree(PN,Tree)), 
    guess_all_parse_poss(PN,Tree), 
    reorder_tree(PN,beginning),
    discover_requirements(PN), 
    generate_correct_sentence(PN), 
    fail. 
parse(_) :- 
    /*  write_all_trees, paul */
    retract(count(parse_num,PN)), 
    PN \== 0 . 
/* *****************************************************************
		try_parse(+,-).
		try_parse(sentence in, tree out).
1. try_parse - attempt to parse sentence, ELSE,
2. Recovery Levels :
	i. move word - deletion and reinsertion, prop.to length of
	   sentence.
	ii. insert word - insert word from insert_type (no. of
		possible insertions = 16), again each prop. to lngth.
		of sentence.
	iii. substitute word - take each word in turn and attempt to 
		replace it with one of the insert_type 's 
		(same as ii).
	iv.  deletion - take out word , prop. to lngth.
	v.   deletion and insertion - remove one add another,
		(del prop. to lngth,insert. prop. to lngth).

(expensive in time and space !)
*************************************************************** */

try_parse(Sent,[Tree]) :-
    nl,write('Trying for a legal parse'),nl,
    ndasserta_count(word_count,0), 
    sentence(Tree,Sent,[]),
    nl,write('Legal parse found'),nl,
    asserta_only_once(legal_parse).
try_parse(_,_) :-
    retract(legal_parse),
    !,fail.






try_parse(Sent,[Tree]) :-
    available_recovery_level(Level),
    ndasserta(trying_recovery_level(Level)),
    attempt_recovery(Level,Sent,Tree),
    retract(trying_recovery_level(_)),
    !.

available_recovery_level(1).
available_recovery_level(2).
available_recovery_level(3).
available_recovery_level(4).
available_recovery_level(5).

attempt_recovery(Level,Sent,Tree) :-
    writel([nl,'Trying recovery level ',Level]),
    ndasserta_count(word_count,0), 
    try_recovery_level(Level,Sent,Tree),
    change_all_found_and_possibility_word_pos,
    writel([nl,'Recovery level ',Level,' succeeded',nl]).

try_recovery_level(1,Sent,Tree) :-
    write(' (word in wrong place -- move)'),nl,
    try_a_deletion(Sent,Sent_with_word_deleted),
    ndasserta(word_deleted_was_moved),
    word_deleted_word(Word),
    ndasserta_count(word_inserted,0),
    insert(Word,Sent_with_word_deleted,Sent2),
    increment(word_inserted,_),
    sentence(Tree,Sent2,[]).
try_recovery_level(2,Sent,Tree) :-
    write(' (word missing -- insertion)'),nl,
    try_an_insertion(Sent,Sent_with_word_inserted),
    sentence(Tree,Sent_with_word_inserted,[]),
    word_inserted_type(Type),
    once1(retract(found(Type,_,_,_,_,_,_,_,_))).
try_recovery_level(3,Sent,Tree) :-
    write(' (word is of wrong type -- substitution)'),nl,
    try_a_substitution(Sent,Sent_with_word_substituted),
    sentence(Tree,Sent_with_word_substituted,[]).
try_recovery_level(4,Sent,Tree) :-
    write(' (word should not be present -- deletion)'),nl,
    try_a_deletion(Sent,Sent_with_word_deleted),
    sentence(Tree,Sent_with_word_deleted,[]).
try_recovery_level(5,Sent,Tree) :-
    write(' (remove one word & insert another -- deletion & insertion)'),nl,
    try_a_deletion(Sent,Sent_with_word_deleted),
    try_an_insertion(Sent_with_word_deleted,Sent_with_word_inserted),
    sentence(Tree,Sent_with_word_inserted,[]),
    word_inserted_type(Type),
    once1(retract(found(Type,_,_,_,_,_,_,_,_))).

try_a_deletion(Sent,Sent_with_word_deleted) :-
/* */  write('  Trying a deletion'),nl,  
    ndasserta_count(word_deleted,0),
    remove(Word,Sent,Sent_with_word_deleted),
    ndasserta(word_deleted_word(Word)),
    increment(word_deleted,_).

try_a_substitution(Sent,Sent_with_word_substituted) :-
/* */  write('  Trying a substitution'),nl, 
    ndasserta_count(word_deleted,0),
    substit(Sent,Type,Word_deleted,Sent_with_word_substituted),
    ndasserta(word_deleted_word(Word_deleted)),
    increment(word_deleted,Word_pos),
    ndasserta_count(word_inserted,Word_pos),
    insert_type(Type),
    ndasserta(word_inserted_type(Type)),
    ndasserta(found(Type,_,_,Type,_,_,_,_,Word_pos)).

substit([Substit|T],Element,Substit,[Element|T]).
substit([H|T],Element,Substit,[H|T2]) :-
    substit(T,Element,Substit,T2).

try_an_insertion(Sent,Sent_with_word_inserted) :-
/* */  write('  Trying an insertion'),nl,  
    insert_type(Type),
    ndasserta(word_inserted_type(Type)),
    ndasserta_count(word_inserted,0),
    insert(Type,Sent,Sent_with_word_inserted),
    increment(word_inserted,Word_pos),
    ndasserta(found(Type,_,_,Type,_,_,_,_,Word_pos)).

/* ********************************************************* */
/* when word inserted or deleted the appropriate word_pos have
	to be changed (ie. management of D-B)    **** 
	thats what the next few procedures accomplish  */
/* ****************************************************** */

change_all_found_and_possibility_word_pos :-
    retract_if_deleted(List_word),
    change_all_found_word_pos,
    change_all_possibility_word_pos,
    assert_if_inserted(List_word).

retract_if_deleted(List_word) :-
    count(word_deleted,Word_deleted),
    found(_,List_word,_,_,_,_,_,_,Word_deleted),
    retract_all(found(_,_,_,_,_,_,_,_,Word_deleted)),
    retract_all(possibility(_,_,_,_,_,_,_,Word_deleted)),
    !.
retract_if_deleted(_).

assert_if_inserted(List_word) :-
    trying_recovery_level(1),
    !,
    count(word_inserted,Word_inserted),
    guess_all_founds_and_possibilities(List_word,_,Word_inserted).
assert_if_inserted(_) :-
    count(word_inserted,Word_inserted),
    word_inserted_type(Type),
    name2(Type,List_type),
    asserta(found(Type,List_type,List_type,Type,List_type,[],[],[inserted(Type)],Word_inserted)),
 /* []="" first param only */
    calc_info([],[],[inserted(Type)],_,Info), /* []="" only 1st param */
    asserta(possibility(Type,List_type,List_type,Type,List_type,[],Info,Word_inserted)).
assert_if_inserted(_). /* []="" only 1st param */

change_all_found_word_pos :-
    once1(retract(found(Aw1,Lw1,Rw1,T1,R1,E1,Es1,I1,Old_Word_pos))),
    change_all_found_word_pos,
    calc_new_word_pos_1(Old_Word_pos,New_Word_pos),
    asserta(found(Aw1,Lw1,Rw1,T1,R1,E1,Es1,I1,New_Word_pos)),
    fail.
change_all_found_word_pos.

change_all_possibility_word_pos :-
    once1(retract(possibility(Aw2,Lw2,Rw2,T2,R2,E2,I2,Old_Word_pos))),
    change_all_possibility_word_pos,
    calc_new_word_pos_1(Old_Word_pos,New_Word_pos),
    asserta(possibility(Aw2,Lw2,Rw2,T2,R2,E2,I2,New_Word_pos)),
    fail.
change_all_possibility_word_pos.
 
calc_new_word_pos_1(Old_Word_pos,New_Word_pos) :-
    count(word_deleted,WD),
    Old_Word_pos > WD,
    NWP1 is (Old_Word_pos - 1),
    calc_new_word_pos_11(NWP1,New_Word_pos),
    !.
calc_new_word_pos_1(Old_Word_pos,New_Word_pos) :-
    calc_new_word_pos_11(Old_Word_pos,New_Word_pos).

calc_new_word_pos_11(Old_Word_pos,New_Word_pos) :-
    count(word_inserted,WI),
    Old_Word_pos >= WI,
    New_Word_pos is (Old_Word_pos + 1),
    !.
calc_new_word_pos_11(Old_Word_pos,Old_Word_pos).

/*  ++++++++++++++++++++++++++++++++++++++++++++++++++  */ 
 
guess_all_parse_poss(Parse_num,Tree) :- 
    find_formed(Tree,Type,[Word_found,Word_pos]), 
    atom(Word_found), 
    possibility(Word,List_word,Ref_word,Type,Root,Ending,Info,Word_pos), 
    asserta(parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info,Word_pos,Word_pos)), 
/* paul */  /*  writedb(['parse_poss ',Parse_num,'  ',Word,'  ',List_word,'  ',Ref_word,'  ',Type,'  ',Root,'  ',Ending,'  ',Info,'  ',Word_pos]),nl, */
    fail. 
guess_all_parse_poss(_,_). 
 
/*  ++++++++++  INTERFACE  GRAMMAR  FILE  ++++++++++  */ 
 
it_is(Type,Word,Word_pos,[Word|Rest],Rest) :- 
    once1(found(Word,_,_,Type,_,_,_,_,_)), 
    ndincrement(word_count,Word_pos). 
 
/*  ++++++++++++++++++++++++++++++++++++++++++++++++++  */ 
 
write_tree([formed(Type,List)|Tail],Indent1) :- 
    !, 
    nl, 
    tab(Indent1),write(Type), 
    Indent2 is (Indent1 + 2), 
    write_tree(List,Indent2), 
    write_tree(Tail,Indent1). 
write_tree([],_) :- !. 
write_tree(Terminal,_) :- 
    writel([' : ',Terminal]). 

/*  **********  REORDER  TREE  **********  */ 
 
reorder_tree(Parse_num,Reorder_when) :- 
    tree(Parse_num,Tree), 
    reorder(Reorder_when,Minor_struc,Priority_list),
    find_formed(Tree,Minor_struc,Minor_params),
    assign_priorities(Minor_params,Priority_list),
    once1(find_formed_word(Minor_params,[_,First_word_pos])),
    generate_right_order(First_word_pos,Right_word_order,Right_pos_order),
    extract_words(Minor_params,Words_in_old_order),
    assertz(comment_to_be_made(Parse_num,['Your ',Minor_struc,' ',Words_in_old_order,' has been reordered'])),
    New_struc =.. [ Minor_struc,New_subtree,Right_word_order,[] ],
    reparse_subtree(New_struc,First_word_pos),
    replace_subtree(Parse_num,Minor_struc,Minor_params,New_subtree),
    tree(Parse_num,New_tree),
/*  */ write_tree(New_tree,1),nl,nl,  
    change_all_parse_poss_word_pos(Right_pos_order),
    fail.
reorder_tree(_,_).

assign_priorities(Minor_params,Priority_list) :-
    asserta(priorities_assigned([])),
    count(parse_num,Parse_num),
    find_formed(Minor_params,Type,[Word,Word_pos]),
    once1(parse_poss(Parse_num,_,_,_,_,_,_,Info,_,Word_pos)),
    member(priority(Priority_value,Type,Attribute_list),Priority_list),
    does_info_have_these_attributes(Info,Attribute_list),
    once1(retract(priorities_assigned(So_far_assigned))),
    append(So_far_assigned,[ [Word,Word_pos,Priority_value] ],New_assigned),
    asserta(priorities_assigned(New_assigned)),
    fail.
assign_priorities(_,_).

does_info_have_these_attributes(_,[]).
does_info_have_these_attributes(Info,[Attribute|Rest_attributes]) :-
    compatible_info(Attribute,Info),
    !,
    does_info_have_these_attributes(Info,Rest_attributes).
does_info_have_these_attributes(Info,[Attribute|Rest_attributes]) :-
    unknown_or_inserted(Info),
    does_info_have_these_attributes(Info,Rest_attributes).

generate_right_order(First_word_pos,Right_word_order,Right_pos_order) :-
    retract(priorities_assigned(Priority_list)),
    permute(Priority_list,Right_order),
    correctly_ordered(Right_order,-99,Right_word_order,First_word_pos,Right_pos_order),
    !,
    Right_order \== Priority_list.

permute(List,[Element|Rest]) :-
    remove(Element,List,New_list),
    permute(New_list,Rest).
permute([],[]).

remove(Element,[Element|Rest],Rest).
remove(Element,[Head|Rest],[Head|Rest2]) :-
    remove(Element,Rest,Rest2).

insert(Element,Rest,[Element|Rest]).
insert(Element,[Head|Rest],[Head|Rest2]) :-
    insert(Element,Rest,Rest2).

correctly_ordered([ [Word,Old_Word_pos,Priority]|Rest ],Prev_priority,[Word|Rest_words],New_Word_pos,[ [Old_Word_pos,New_Word_pos]|Rest_pos ]) :-
    Priority >= Prev_priority,
    Next_New_Word_pos is (New_Word_pos +1),
    correctly_ordered(Rest,Priority,Rest_words,Next_New_Word_pos,Rest_pos).
correctly_ordered([],_,[],_,[]).

reparse_subtree(New_struc,First_word_pos) :-
    Word_before is (First_word_pos - 1),
    replacea(count(word_count,Old_word_count),count(word_count,Word_before)),
    call(New_struc),
    replacea(count(word_count,_),count(word_count,Old_word_count)),
    !.
 
replace_subtree(Parse_num,Minor_struc,Minor_params,New_subtree) :-
    retract(tree(Parse_num,Tree)),
    insert_subtree(Tree,formed(Minor_struc,Minor_params),New_subtree,New_tree),
    asserta(tree(Parse_num,New_tree)),
    !.

insert_subtree([Old_subtree|TreeT],Old_subtree,New_subtree,[New_subtree|TreeT]) :- !.
insert_subtree([formed(Struc,TreeH)|TreeT],Old_subtree,New_subtree,[formed(Struc,New_TreeH)|TreeT]) :-
    insert_subtree(TreeH,Old_subtree,New_subtree,New_TreeH).
insert_subtree([TreeH|TreeT],Old_subtree,New_subtree,[TreeH|New_TreeT]) :-
    insert_subtree(TreeT,Old_subtree,New_subtree,New_TreeT).

change_all_parse_poss_word_pos(Right_pos_order) :-
    once1(retract(parse_poss(Pn3,Aw3,Lw3,Rw3,T3,R3,E3,I3,Old_Word_pos,_))),
    change_all_parse_poss_word_pos(Right_pos_order),
    calc_new_word_pos_2(Right_pos_order,Old_Word_pos,New_Word_pos),
    asserta(parse_poss(Pn3,Aw3,Lw3,Rw3,T3,R3,E3,I3,Old_Word_pos,New_Word_pos)),
    fail.
change_all_parse_poss_word_pos(_).

calc_new_word_pos_2(Right_pos_order,Old_Word_pos,New_Word_pos) :-
    member([Old_Word_pos,New_Word_pos],Right_pos_order),
    !.
calc_new_word_pos_2(_,Old_Word_pos,Old_Word_pos).

extract_words(Tree,_) :-
    asserta(word_list([])),
    find_formed(Tree,word,[Word,_]),
    once1(retract(word_list(Word_list_so_far))),
    append(Word_list_so_far,[Word],New_word_list),
    asserta(word_list(New_word_list)),
    fail.
extract_words(_,Word_list) :-
    retract(word_list(Word_list)),
    !.

/*  **********  DISCOVER  REQUIREMENTS  **********  */ 
/* check - list of rules in  grammar that define permissable 
	combinations of words (eg. re. agreement). */
 
discover_requirements(Parse_num) :- 
    tree(Parse_num,Tree), 
    abolish(wanted,3), 
    check(Minor_struc_list,Major_struc,Condition_list,Rule), 
    find_formed(Tree,Major_struc,Major_params), 
    do_conditions_hold(Condition_list,Major_params), 
    member(Minor_struc,Minor_struc_list), 
    find_formed(Major_params,Minor_struc,Minor_params), 
    add_params(Rule,[Minor_params,Major_params],Rule2), 
    call(Rule2), 
    fail. 
discover_requirements(_). 
 
do_conditions_hold([],_). 
do_conditions_hold([Condition|Rest_conditions],Major_params) :- 
    add_params(Condition,[Major_params],Condition2), 
    call(Condition2), 
    do_conditions_hold(Rest_conditions,Major_params). 
 
/*  ----------  CONDITIONS  ----------  */ 
 
exists(Minor_struc,Major_struc) :- 
    find_formed(Major_struc,Minor_struc,Minor_params), 
    find_formed_word(Minor_params,_), 
    !. 
 
empty(Minor_struc,Major_struc) :- 
    not(exists(Minor_struc,Major_struc)). 
 
attribute(Attrib,Minor_struc,Major_struc) :- 
    count(parse_num,Parse_num), 
    find_formed(Major_struc,Minor_struc,Minor_params), 
    find_formed_word(Minor_params,[_,Word_pos]), 
    parse_poss(Parse_num,_,_,_,_,_,_,Info,_,Word_pos), 
    compatible_info(Attrib,Info),
    !. 
 
not_attribute(Attrib,Minor_struc,Major_struc) :- 
    not(attribute(Attrib,Minor_struc,Major_struc)).

one_of(Attrib_name,Minor_struc_check,Minor_struc_with,Major_struc) :- 
    count(parse_num,Parse_num), 
    find_formed(Major_struc,Minor_struc_with,Minor_with_params), 
    find_formed_word(Minor_with_params,[_,Word_pos_with]), 
    parse_poss(Parse_num,_,_,_,_,_,_,Info,_,Word_pos_with), 
    !,
    one_of2(Attrib_name,Info,Major_struc,Minor_struc_check).

one_of2(_,[unknown(_)|_],_,_) :- !.
one_of2(_,[inserted(_)|_],_,_) :- !.
one_of2(Attrib_name,Info,Major_struc,Minor_struc_check) :-
    member(Attrib,Info),
    Attrib =.. [Attrib_name,Ref_word_list],
    one_of3(Major_struc,Minor_struc_check,Ref_word_list).

one_of3(Major_struc,Minor_struc_check,Ref_word_list) :-
    find_formed(Major_struc,Minor_struc_check,Minor_check_params), 
    find_formed_word(Minor_check_params,[_,Word_pos_check]), 
    count(parse_num,Parse_num),
    !,
    parse_poss(Parse_num,_,_,Ref_word,_,_,_,_,_,Word_pos_check), 
    member(Ref_word,Ref_word_list),
    !.
one_of3(_,_,Ref_word_list) :-
    member([],Ref_word_list),!. /* []="" */
 

not_one_of(Attrib_name,Minor_struc_check,Minor_struc_with,Major_struc) :- 
    not(one_of(Attrib_name,Minor_struc_check,Minor_struc_with,Major_struc)).
 
letter(Letter_type,Where_in_word,Where_word,[Parse_num,Word_pos]) :- 
    find_word_relative(Where_word,Parse_num,Word_pos,List_word_found,Info_word_found), 
    not(info_unknown_or_inserted(Info_word_found)),
    find_letter_in_word(List_word_found,Where_in_word,Letter), 
    call(is_letter_type(Letter_type,Letter)). 

info_unknown_or_inserted([unknown(_)]).
info_unknown_or_inserted([inserted(_)]).
 
find_word_relative(previous_word,Parse_num,Word_pos,List_word,Info) :- 
    Prev_word_pos is (Word_pos - 1), 
    parse_poss(Parse_num,_,List_word,_,_,_,_,Info,_,Prev_word_pos), 
    !. 
find_word_relative(previous_word,Parse_num,Word_pos,List_word,Info) :- 
    Word_pos > 1, 
    Prev_pos is (Word_pos - 1), 
    find_word_relative(previous_word,Parse_num,Prev_pos,List_word,Info). 
find_word_relative(following_word,Parse_num,Word_pos,List_word,Info) :- 
    Follow_word_pos is (Word_pos + 1), 
    parse_poss(Parse_num,_,List_word,_,_,_,_,Info,_,Follow_word_pos), 
    !. 
find_word_relative(following_word,Parse_num,Word_pos,List_word,Info) :- 
    count(word_count,WC), 
    Word_pos < WC, 
    Follow_pos is (Word_pos + 1), 
    find_word_relative(following_word,Parse_num,Follow_pos,List_word,Info). 
 
find_letter_in_word([First_letter|_],first_letter,First_letter). 
find_letter_in_word(List_word,last_letter,Last_letter) :- 
    last_list_element(List_word,Last_letter). 

/* NOTE WELL --------- */
 /* paul - need to store such info as conflicting vowels in dictionary */
is_letter_type(vowel,V) :- vowel_type(X),member(V,X). /* paul */ 
is_letter_type(consonant,C) :- not(vowel(C)). 
 
/*  ----------  END  CONDITIONS  ----------  */ 
 
/*  ----------  CHECKS  ----------  */ 
 
/*  ++++++++++  CONCORD  CHECK  ++++++++++  */ 
 
concord(Attrib_name_list,Concord_with_struc,Concord_with_attribs,Minor_params,Major_struc) :- 
    find_formed_word(Minor_params,[_,Word_pos]), 
    find_formed(Major_struc,Concord_with_struc,[_,With_word_pos]), 
    do_attribs_hold(Concord_with_attribs,With_word_pos),
    !,
    member(Attrib_name,Attrib_name_list), 
    asserta(wanted(Word_pos,same_as(Attrib_name,With_word_pos))), 
    fail. 

do_attribs_hold(Concord_with_attribs,With_word_pos) :-
    count(parse_num,Parse_num),
    parse_poss(Parse_num,_,_,_,_,_,_,Info,_,With_word_pos),
    do_attribs_hold2(Concord_with_attribs,Info),
    !.
 
do_attribs_hold2([],_).
do_attribs_hold2([attribute(Attrib)|Rest_attribs],Info) :-
    compatible_info(Attrib,Info),
    do_attribs_hold2(Rest_attribs,Info).
do_attribs_hold2([not_attribute(Attrib)|Rest_attribs],Info) :-
    not(compatible_info(Attrib,Info)),
    do_attribs_hold2(Rest_attribs,Info).

/*  ++++++++++  POSITION  CHECK  ++++++++++  */ 
 
test_pre_post(Locator_pos,Test_pos,pre) :- Locator_pos > Test_pos. 
test_pre_post(Locator_pos,Test_pos,post) :- Locator_pos < Test_pos. 
 
/*  ++++++++++  SHOULD_BE  CHECK  ++++++++++  */ 
 
should_be(Attrib_list,Minor_params,_) :- 
    find_formed_word(Minor_params,[_,Word_pos]), 
    member(Attrib,Attrib_list), 
    asserta(wanted(Word_pos,wanted_to_be(Attrib,yes))), 
    fail. 
 
should_not_be(Attrib_list,Minor_params,_) :- 
    find_formed_word(Minor_params,[_,Word_pos]), 
    member(Attrib,Attrib_list), 
    asserta(wanted(Word_pos,wanted_to_be(Attrib,no))), 
    fail. 
 
/*  ++++++++++  SELECT_ON  CHECK  ++++++++++  */ 
 
select_on_first(Attrib_list,Minor_params,_) :- 
    find_formed_word(Minor_params,[_,Word_pos]), 
    member(Attrib,Attrib_list), 
    asserta(wanted(Word_pos,wanted_select_on_first(Attrib))), 
    fail. 
 
select_on_last(Attrib_list,Minor_params,_) :- 
    find_formed_word(Minor_params,[_,Word_pos]), 
    member(Attrib,Attrib_list), 
    asserta(wanted(Word_pos,wanted_select_on_last(Attrib))), 
    fail. 
 
/*  ++++++++++  CHANGE_WORD  CHECK  ++++++++++  */ 
 
change_word(Right_ref_word,Struc,Ignoring,Minor_params,_) :- 
    find_formed_word(Minor_params,[_,Word_pos]), 
      /* ************************************
      paul - to change string into askii list 
      *************************************** */
      interpret(Right_ref_word,Right_ref_word_List),
    asserta(wanted(Word_pos,ref_word(Right_ref_word_List,Ignoring))), 
    fail. 
 
/*  ++++++++++  COMMENT  CHECK  ++++++++++  */ 
 
comment(Comment_conds,Text,Minor_params,_) :- 
    once1(find_formed_word(Minor_params,[_,Word_pos])), 
    asserta(wanted(Word_pos,make_comment(Comment_conds,Text))). 
 
/*  -----------------------------------  */ 
 
/*  **********  GENERATE  CORRECT  SENTENCE  **********  */ 
 
generate_correct_sentence(Parse_num) :- 
    tree(Parse_num,Tree), 
    next_rule_wanted(Name_rule_wanted), 
    wanted(Word_pos,Rule_wanted), 
    Rule_wanted =.. [Name_rule_wanted|_], 
    once1(retract(wanted(Word_pos,Rule_wanted))), 
    add_params(Rule_wanted,[Word_pos,Parse_num],Rule_wanted2), 
    call(Rule_wanted2), 
    fail. 
generate_correct_sentence(Parse_num) :- 
    reorder_tree(Parse_num,end),
    fail.
generate_correct_sentence(Parse_num) :- 
    tree(Parse_num,Tree), 
    parse_poss(Parse_num,_,_,_,_,_,_,Info,_,Word_pos), 
    not(info_unknown_or_inserted(Info)),
    change_spelling(Condition_list,Attrib_list), 
    do_conditions_hold(Condition_list,[Parse_num,Word_pos]), 
    member(Attrib,Attrib_list), 
    wanted_to_be(Attrib,yes,Word_pos,Parse_num), 
    fail. 
generate_correct_sentence(_). 
 
next_rule_wanted(ref_word). 
next_rule_wanted(wanted_select_on_first). 
next_rule_wanted(wanted_to_be). 
next_rule_wanted(same_as). 
next_rule_wanted(wanted_select_on_last). 
next_rule_wanted(make_comment). 
 
/*  ----------  CORRECTIONS  ----------  */ 
 
/*  ++++++++++  SAME_AS  CORRECTION  ++++++++++  */ 
 
same_as(Attrib_name,With_word_pos,Word_pos,Parse_num) :- 
    once1(parse_poss(Parse_num,_,_,_,_,_,_,With_info,_,With_word_pos)), 
    member(Attrib,With_info), 
    Attrib =.. [Attrib_name,_],
    wanted_to_be(Attrib,yes,Word_pos,Parse_num). 
 
/*  ++++++++++  WANTED_TO_BE  CORRECTION  ++++++++++  */ 
 
wanted_to_be(Wanted_attrib,yes,Word_pos,Parse_num) :- 
    parse_poss(Parse_num,_,_,_,_,_,_,Info,_,Word_pos), 
    compatible_info(Wanted_attrib,Info),
    Wanted_attrib =.. [Attrib_name,Attrib_wanted],
    !,
    parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info2,Old_Word_pos,Word_pos), 
    member(Found_attrib,Info2), 
    Found_attrib =.. [Attrib_name,Attrib_found],
    not(test_yes_no_or_any(==,Attrib_wanted,Attrib_found,yes)),
    once1(retract(parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info2,Old_Word_pos,Word_pos))), 
    fail. 
wanted_to_be(Wanted_attrib,no,Word_pos,Parse_num) :- 
    parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos,Word_pos), 
    member(Wanted_attrib,Info), 
    once1(retract(parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos,Word_pos))), 
    fail. 
 
/*  ++++++++++  WANTED_SELECT_ON  CORRECTION  ++++++++++  */ 
 
wanted_select_on_first(Attrib,Word_pos,Parse_num) :- 
    wanted_select_on(Attrib,Word_pos,Parse_num). 
wanted_select_on_last(Attrib,Word_pos,Parse_num) :- 
    wanted_select_on(Attrib,Word_pos,Parse_num). 
 
wanted_select_on(Wanted_attrib,Word_pos,Parse_num) :- 
    wanted_select_on2(Wanted_attrib,Word_pos,Parse_num,Found_attrib), 
    !, 
    parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos,Word_pos), 
    not(member(Found_attrib,Info)), 
    once1(retract(parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos,Word_pos))), 
    fail. 
 
wanted_select_on2(Wanted_attrib,Word_pos,Parse_num,Wanted_attrib) :- 
    parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos,Word_pos), 
    member(Wanted_attrib,Info), 
    found(Word,List_word,Ref_word,Type,Root,Ending,_,_,Old_Word_pos), 
    !. 
wanted_select_on2(Wanted_attrib,Word_pos,Parse_num,Found_attrib) :- 
    Wanted_attrib =.. [Attrib_name,_],
    parse_poss(Parse_num,Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos,Word_pos), 
    found(Word,List_word,Ref_word,Type,Root,Ending,_,_,Old_Word_pos), 
    member(Found_attrib,Info), 
    Found_attrib =.. [Attrib_name,_],
    !. 
wanted_select_on2(Wanted_attrib,Word_pos,Parse_num,Wanted_attrib) :- 
    found(Word,List_word,Ref_word,Type,Root,Ending,_,_,Old_word_pos), 
    possibility(Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos), 
    member(Wanted_attrib,Info), 
    parse_poss(Parse_num,_,_,_,Type,Root,_,Info2,_,Word_pos), 
    member(Wanted_attrib,Info2), 
    !. 
wanted_select_on2(Wanted_attrib,Word_pos,Parse_num,Found_attrib) :- 
    Wanted_attrib =.. [Attrib_name,_],
    found(Word,List_word,Ref_word,Type,Root,Ending,_,_,Old_Word_pos), 
    possibility(Word,List_word,Ref_word,Type,Root,Ending,Info,Old_Word_pos), 
    member(Found_attrib,Info), 
    Found_attrib =.. [Attrib_name,_],
    parse_poss(Parse_num,_,_,_,Type,Root,_,Info2,_,Word_pos), 
    member(Found_attrib,Info2), 
    !. 
wanted_select_on2(Wanted_attrib,Word_pos,Parse_num,Wanted_attrib) :- 
    parse_poss(Parse_num,_,_,_,_,_,_,Info,_,Word_pos), 
    member(Wanted_attrib,Info), 
    !. 
wanted_select_on2(Wanted_attrib,Word_pos,Parse_num,Found_attrib) :- 
    Wanted_attrib =.. [Attrib_name,_],
    parse_poss(Parse_num,_,_,_,_,_,_,Info,_,Word_pos), 
    member(Found_attrib,Info), 
    Found_attrib =.. [Attrib_name,_],
    !. 
 
/* ++++++++++  REF_WORD  CORRECTION  ++++++++++  */ 
 
ref_word(Right_ref_word,_,Word_pos,Parse_num) :- 
    parse_poss(Parse_num,_,_,Right_ref_word,_,_,_,_,_,Word_pos), 
    !. 
ref_word(Right_ref_word,ignore(Ignore_list),Word_pos,Parse_num) :- 
    guess_all_founds_and_possibilities(_,Right_ref_word,Word_pos), 
    once1(parse_poss(Parse_num,_,_,Wrong_ref_word,_,_,_,_,_,Word_pos)), 
    retract(parse_poss(Parse_num,Atom_word,List_word,Wrong_ref_word,Type,Root,Ending,Info,Old_Word_pos,Word_pos)), 
    possibility(Atom_word2,List_word2,Right_ref_word,Type,Root2,Ending2,Info2,Old_Word_pos), 
    compatible_infos(Info,Info2,Ignore_list), 
    assertz(parse_poss(Parse_num,Atom_word2,List_word2,Right_ref_word,Type,Root2,Ending2,Info2,Old_Word_pos,Word_pos)), 
    fail. 
ref_word(Right_ref_word,_,Word_pos,_) :- 
    retract_all(found(_,_,Right_ref_word,_,_,_,_,_,Word_pos)), 
    retract_all(possibility(_,_,Right_ref_word,_,_,_,_,Word_pos)). 
 
compatible_infos(Info_wanted,Infos,Ignore_list) :- 
    apply(compatible_infos2(Info,Infos,Ignore_list),Info,Info_wanted). 
 
compatible_infos2(Wanted_attrib,_,Ignore_list) :- 
    Wanted_attrib =.. [Attrib_name,_],
    member(Attrib_name,Ignore_list), 
    !. 
compatible_infos2(Wanted_attrib,Infos,_) :- 
    Wanted_attrib =.. [Attrib_name,_],
    not( (member(Found_attrib,Infos) , Found_attrib =.. [Attrib_name,_]) ), 
    !.
compatible_infos2(Wanted_attrib,Infos,_) :- 
    compatible_info(Wanted_attrib,Infos).

compatible_info(Attrib,Infos) :-
    Attrib =.. [Attrib_name,Attrib_body],
    member(Attrib2,Infos),
    Attrib2 =.. [Attrib_name,Attrib_body2],
    test_yes_no_or_any(==,Attrib_body,Attrib_body2,yes),
    !.
 
/*  ++++++++++  MAKE_COMMENT  CORRECTION  ++++++++++  */ 
 
make_comment([Scope,Comment_conds],Text1,Word_pos,Parse_num) :- 
    tree(Parse_num,Tree),
    find_formed(Tree,Scope,Scope_found),
    do_conditions_hold(Comment_conds,Scope_found),
    parse_poss(Parse_num,_,_,Ref_word,_,_,_,_,_,Word_pos), 
    name2(Atom_Ref_word,Ref_word),
    append(['"',Atom_Ref_word,'" : '],[Text1],Text),
    asserta(comment_to_be_made(Parse_num,Text)), 
    !.
 
/*  ----------  END  CORRECTIONS  ----------  */ 

/*  **********  CHOOSE_CORRECT_SENTENCE  **********  */ 
 
choose_correct_sentence(Orig_Sent,Parse_num) :- 
    tree(Parse_num,_), 
    how_many_facts(comment_to_be_made(Parse_num,_,_),Total_comments), 
    asserta(total_errors(Parse_num,Total_comments)), 
    correct_each_word(Parse_num,1), 
    New_parse_num is (Parse_num + 1), 
    choose_correct_sentence(Orig_Sent,New_parse_num). 
choose_correct_sentence(Orig_Sent,_) :- 
    asserta(least_errors(0,999)), 
    choose_least_errors, 
    retract(least_errors(Parse_num,_)), 
    tree(Parse_num,Tree),
/* */  write('Parse tree selected:'),nl,nl,
    write_tree(Tree,1),nl,nl,  
    writel(['Your sentence was:',nl,nl,'---  ']),writelspcs(Orig_Sent),write('.  ---'),nl, 
    write_correct_sentence(Parse_num), 
    write_comments(Parse_num). 
 
correct_each_word(Parse_num,Word_pos) :- 
    choose_word(Parse_num,Word_pos), 
    retract_all(parse_poss(Parse_num,_,_,_,_,_,_,_,_,Word_pos)),
    Next_word_pos is (Word_pos + 1), 
    correct_each_word(Parse_num,Next_word_pos). 
correct_each_word(Parse_num,Word_pos) :- 
    parse_poss(Parse_num,_,_,_,_,_,_,_,_,_), 
    Next_word_pos is (Word_pos + 1), 
    correct_each_word(Parse_num,Next_word_pos). 
correct_each_word(_,_). 
 
choose_word(Parse_num,Word_pos) :- 
    parse_poss(Parse_num,Word,_,_,Type,_,_,Info,Old_Word_pos,Word_pos),
    found(Word,_,_,_,_,_,_,_,Old_Word_pos), 
    assertz(chosen_word(Parse_num,Word,Type,Info,Old_Word_pos,Word_pos)),
    !. 
choose_word(Parse_num,Word_pos) :- 
    parse_poss(Parse_num,_,_,_,_,_,_,_,Old_Word_pos,Word_pos),
    found(Word_found,_,_,_,_,_,_,_,Old_Word_pos),
    possibility(Word_found,_,_,_,_,_,Info_found,Old_Word_pos),
    choose_closest_word(Parse_num,Info_found,Old_Word_pos,Word_pos),
    retract(total_errors(Parse_num,Errors)), 
    New_errors is (Errors + 1), 
    asserta(total_errors(Parse_num,New_errors)), 
    !. 
choose_word(Parse_num,Word_pos) :- 
    parse_poss(Parse_num,Word,_,_,Type,_,_,Info,Old_Word_pos,Word_pos), 
    assertz(chosen_word(Parse_num,Word,Type,Info,Old_Word_pos,Word_pos)),
    retract(total_errors(Parse_num,Errors)), 
    New_errors is (Errors + 1), 
    asserta(total_errors(Parse_num,New_errors)), 
    !. 

choose_closest_word(Parse_num,Info_found,Old_Word_pos,Word_pos) :-
    ndasserta_count(word_diffs,999),
    retract(parse_poss(Parse_num,Word,_,_,Type,_,_,Info,Old_Word_pos,Word_pos)),
    how_many_info_diffs(Info_found,Info,New_diffs),
    count(word_diffs,Old_diffs),
    New_diffs < Old_diffs,
    replacea(count(word_diffs,_),count(word_diffs,New_diffs)),
    replacez(chosen_word(Parse_num,_,_,_,_,Word_pos),chosen_word(Parse_num,Word,Type,Info,Old_Word_pos,Word_pos)),
    fail.
choose_closest_word(_,_,_,_).

how_many_info_diffs(Info_found,Info,_) :-
    asserta(count(info_diffs,0)),
    member(Attrib_found,Info_found),
    Attrib_found =.. [Attrib_found_name,Attrib_found_attrib],
    once1(not(spelling_change_attribute(Attrib_found_name))),
    member(Attrib,Info),
    Attrib =.. [Attrib_found_name,Attrib_attrib],
    not(test_yes_no_or_any(==,Attrib_found_attrib,Attrib_attrib,yes)),
    increment(info_diffs,_),
    fail.
how_many_info_diffs(_,_,Diffs) :-
    retract(count(info_diffs,Diffs)).

choose_least_errors :- 
    retract(total_errors(Parse_num,Errors)), 
    once1(least_errors(Least_parse_num,Least_errors)), 
    Errors < Least_errors, 
    replacea(least_errors(_,_),least_errors(Parse_num,Errors)), 
    fail. 
choose_least_errors. 
 
write_correct_sentence(Parse_num) :- 
    writel([nl,'I think the correct version of your sentence should read:',nl,nl,'>>>  ']), 
    write_each_word(Parse_num,1), 
    write('.  <<<'),nl. 
 
write_each_word(Parse_num,Word_pos) :- 
    retract(chosen_word(Parse_num,Word,Type,Info,Old_Word_pos,Word_pos)), 
    retract_all(chosen_word(_,_,_,_,_,Word_pos)), 
    write_word_indicating_unknown_or_inserted(Word,Info),
    write(' '),
    New_word_pos is (Word_pos + 1), 
    write_each_word(Parse_num,New_word_pos), 
    asserta(chosen_word(Parse_num,Word,Type,Info,Old_Word_pos,Word_pos)). 
write_each_word(Parse_num,Word_pos) :- 
    chosen_word(Parse_num,_,_,_,_,_), 
    New_word_pos is (Word_pos + 1), 
    write_each_word(Parse_num,New_word_pos). 
write_each_word(_,_). 
 
write_word_indicating_unknown_or_inserted(Word,[unknown(_)|_]) :-
    !,
    writel(['<',Word,'>']).
write_word_indicating_unknown_or_inserted(Word,[inserted(_)|_]) :-
    !,
    writel(['<',Word,'>']).
write_word_indicating_unknown_or_inserted(Word,_) :-
    write(Word).

write_comments(Parse_num) :- 
    nl,write('****    Comments    ****'),nl, 
    was_word_deleted,
    retract(chosen_word(Parse_num,Word,Type,Info,Old_Word_pos,Word_pos)), 
    is_word_changed(Word,Type,Info,Old_Word_pos),
    is_word_unknown_or_inserted(Word,Info),
    is_word_moved(Type,Word_pos),
    fail. 
write_comments(Parse_num) :- 
    retract(comment_to_be_made(PN2,Text)), 
    Parse_num == PN2, 
    writel(Text),nl,nl,
    fail. 
write_comments(_) :- 
    abolish(comment_to_be_made,2),
    write('****  End Comments  ****'),nl. 

was_word_deleted :-
    not(word_deleted_was_moved),
    retract(count(word_deleted,_)),
    retract(word_deleted_word(Word)),
    writel(['The word "',Word,'" should not have been present and has been deleted',nl,nl]),
    !.
was_word_deleted.

is_word_moved(Type,Word_pos) :-
    retract(count(word_inserted,Word_pos)),
    retract(word_deleted_was_moved),
    retract(count(word_deleted,_)),
    retract(word_deleted_word(Word)),
    writel([Type,' "',Word,'" was in the wrong place and has been moved',nl,nl]),
    !.
is_word_moved(_,_).
 
is_word_changed(Word,Type,Info,Word_pos) :-
    found(Word_found,_,_,_,_,_,_,_,Word_pos), 
    Word_found \== Word, 
    writel([Type,' "',Word_found,'" changed to "',Word,'" : ',Info,nl,nl]), 
    !.
is_word_changed(_,_,_,_).

is_word_unknown_or_inserted(Word,[unknown(Type)|_]) :-
    writel(['"',Word,'" is unknown and has been guessed to be of type ',Type,nl,nl]),
    !.
is_word_unknown_or_inserted(Word,[inserted(Type)|_]) :-
    writel(['A word of type <',Type,'> was missing and has been inserted',nl,nl]),
    !.
is_word_unknown_or_inserted(_,_).

/*  **********  DEBUGGING  AIDS  **********  */ 
 
word_info(Word) :- 
    name2(Word,List_word_given), 
    guess_all_founds_and_possibilities(List_word_given,_,999), 
    retract_all(found(_,_,_,_,_,_,_,_,999)), 
    retract(possibility(Word,List_word,Ref_word,Type,Root,Ending,Info,999)), 
    write_tab(12,"Word:"),write(Word),nl, 
    name2(Ref_word_atom,Ref_word),write_tab(12,"Ref_word:"),write(Ref_word_atom),nl, 
    write_tab(12,"Type:"),write(Type),nl, 
    name2(Root_atom,Root),write_tab(12,"Root:"),write(Root_atom),nl, 
    name2(Ending_atom,Ending),write_tab(12,"Ending:"),write(Ending_atom),nl, 
    write_tab(12,"Info:"),write(Info),nl, 
    nl,fail. 
word_info(_) :- retract_all(possibility(_,_,_,_,_,_,_,999)). 
 
write_tab(Tab,[H|T]) :-
    put(H),
    New_tab is (Tab - 1),
    write_tab(New_tab,T).
write_tab(Tab,[]) :-
    Tab > 0,
    write(' '),
    New_tab is (Tab - 1),
    write_tab(New_tab,[]).
write_tab(0,_).

if(Condition,Action) :- call(Condition),call(Action).
if(_,_).
 
/*  **********  SPECIALISED  UTILITIES  **********  */ 
 
remove_bars([formed(Bar_Struc,_)|TreeT],Bar_Struc,[formed(Bar_Struc,[])|TreeT2]) :-
    !,
    remove_bars(TreeT,Bar_Struc,TreeT2).
remove_bars([formed(Struc,TreeH)|TreeT],Bar_Struc,[formed(Struc,TreeH2)|TreeT2]) :-
    !,
    remove_bars(TreeH,Bar_Struc,TreeH2),
    remove_bars(TreeT,Bar_Struc,TreeT2).
remove_bars([Word,Word_pos],_,[Word,Word_pos]).
remove_bars([],_,[]).

find_formed(Tree,Structure,Params) :- 
    var(Structure), 
    !, 
    find_formed_simple(Tree,Structure,Params), 
    atom(Structure). 
/*  find_formed(Tree,bar(Bar_Struc,Struc),Params) :-
    !,
    find_formed(Tree,Struc,Major_params),
    remove_bars(Major_params,Bar_Struc,Params).  */
find_formed(Tree,Structure,Params) :- 
    Structure =.. [StrucHead,StrucBody],
  /*  nonvar(StrucHead),  */
    !, 
    find_formed_simple(Tree,StrucHead,Params1), 
    find_formed(Params1,StrucBody,Params). 
find_formed(Tree,word,[Word,Word_pos]) :- 
    !, 
    find_formed_simple(Tree,_,[Word,Word_pos]), 
    atom(Word). 
find_formed(Tree,Structure,Params) :- 
    find_formed_simple(Tree,Structure,Params). 
 
find_formed_simple([formed(Structure,Params)|_],Structure,Params) :- 
    Params \== []. 
find_formed_simple([formed(_,Pars)|_],Structure,Params) :- 
    find_formed_simple(Pars,Structure,Params). 
find_formed_simple([_|Tail],Structure,Params) :- 
    find_formed_simple(Tail,Structure,Params). 
 
find_formed_word([Word,Word_pos],[Word,Word_pos]) :- 
    atom(Word), 
    !. 
find_formed_word(Tree,[Word,Word_pos]) :- 
    find_formed(Tree,Struc,Params), 
    find_formed_word(Params,[Word,Word_pos]). 
 
double_list_to_term_list([],[],[]). 
double_list_to_term_list([PredH|PredT],[ArgH|ArgT],[ResultH|ResultT]) :- 
    ResultH =.. [PredH,ArgH], 
    double_list_to_term_list(PredT,ArgT,ResultT). 
 
add_params(Old_rule,Pars,New_rule) :- 
    Old_rule =.. Old_rule_list, 
    append(Old_rule_list,Pars,New_rule_list), 
    New_rule =.. New_rule_list. 

unknown_or_asserted([unknown(_)|_]).
unknown_or_asserted([asserted(_)|_]).
 
test_yes_no_or_any(_,any,_,_) :- !. 
test_yes_no_or_any(_,_,any,_) :- !. 
test_yes_no_or_any(Rule,Attrib1,Attrib2,Yes_No) :- 
    add_params(Rule,[Attrib1,Attrib2],New_rule),
    test_yes_no(New_rule,Yes_No). 
 
test_yes_no(Rule,yes) :- call(Rule),!. 
test_yes_no(Rule,no) :- not(call(Rule)). 
 
/*  **********  BASIC  UTILITIES  **********  */ 

replacea(Old_fact,New_fact) :-
    retract(Old_fact),
    asserta(New_fact),
    !.
replacea(_,New_fact) :-
    asserta(New_fact).

replacez(Old_fact,New_fact) :-
    retract(Old_fact),
    assertz(New_fact),
    !.
replacez(_,New_fact) :-
    assertz(New_fact).
 
last_list_element([H|T],Element) :- 
    T \== [], 
    last_list_element(T,Element). 
last_list_element(Element,Element) :- Element \== []. 
 
how_many_facts(Fact,_) :- 
    asserta(count(how_many,0)), 
    clause(Fact,_), 
    increment(how_many,_), 
    fail. 
how_many_facts(_,Total) :- retract(count(how_many,Total)),!. 
 
list_element_number([H|_],1,H) :- !. 
list_element_number([_|T],L_e_n,Element) :- 
    New_L_e_n is (L_e_n - 1), 
    list_element_number(T,New_L_e_n,Element). 
 
ndincrement(Count_name,Count) :- increment(Count_name,Count). 
ndincrement(Count_name,_) :- decrement(Count_name,_),!,fail. 
 
writel(List) :- apply(writel2(Element),Element,List). 
 
writel2(NL) :- (NL == nl),nl,!. 
writel2(Element) :- write(Element). 

writelspcs([]). 
writelspcs([H|T]) :- write(H),write(' '),writelspcs(T). 
 
ndasserta(Rule) :- asserta(Rule). 
ndasserta(Rule) :- retract(Rule),!,fail. 
 
ndasserta_count(Count_name,Initial_value) :-
    asserta(count(Count_name,Initial_value)). 
ndasserta_count(Count_name,_) :-
    retract(count(Count_name,_)),!,fail. 
 
double_list_member(Find,[Find|_],[InfoH|_],InfoH). 
double_list_member(Find,[_|ActualT],[_|InfoT],Info) :- 
    double_list_member(Find,ActualT,InfoT,Info). 
 
maplist(_,[],[]). 
maplist(Predicate,[OldH|OldT],[NewH|NewT]) :- 
    Rule =.. [Predicate,OldH,NewH], 
    call(Rule), 
    maplist(Predicate,OldT,NewT). 
 
retract_all(Rule) :- retract(Rule),fail. 
retract_all(_). 
 
increment(Count_name,New_count) :- 
    retract(count(Count_name,Old_count)), 
    New_count is (Old_count + 1), 
    asserta(count(Count_name,New_count)), 
    !. 
 
decrement(Count_name,New_count) :- 
    retract(count(Count_name,Old_count)), 
    New_count is (Old_count - 1), 
    asserta(count(Count_name,New_count)), 
    !. 
 
asserta_only_once(Fact) :- Fact,!. 
asserta_only_once(Fact) :- asserta(Fact). 
 
once1(Rule) :- call(Rule),!. 
 
member(Element,[Element|_]).
member(Element,[_|List]) :- member(Element,List).

apply(Rule,Element,[Element|Rest]) :-
    Rule =.. [ Rule_Head|[_|Rest_Params] ],
    New_rule =.. [ Rule_Head|[Element|Rest_Params] ],
    call(New_rule),
     apply(Rule,_,Rest).
apply(_,_,[]).

is_list([]).
is_list([_|_]).

exit_words([no,stop,finish,end,halt,f,n,exit,out,quit,q,e]).

/*  **********  BOTTOM  **********  */ 
:-nl,nl,write('         Type "run" to start LINGER'),nl,nl.

/* interpret vowels from dictionary */

vowel_type(X):-
	vowels(V),
	interpret(V,X).


