/*  GERMAN  GRAMMAR  */
/*  10.3.86          */

/*  ********** GRAMMAR  RULES  **********  */

sentence(formed(sentence,[S,V])) --> subj_phr(S) , verb_phr(V).

subj_phr(formed(subj_phr,[S])) --> noun_pron_phr(S).

noun_pron_phr(formed(noun_pron_phr,[N])) --> noun_phr(N).
noun_pron_phr(formed(noun_pron_phr,[P])) --> pronoun(P).

noun_phr(formed(noun_phr,[D,A,N])) -->
determiner(D) , adj_list(A) , noun(N).

determiner(formed(determiner,[D])) --> definite_article(D).
determiner(formed(determiner,[D])) --> indefinite_article(D).

definite_article(formed(definite_article,[D,Pos])) -->
it_is(definite_article,D,Pos).

indefinite_article(formed(indefinite_article,[I,Pos])) -->
it_is(indefinite_article,I,Pos).

adj_list(formed(adj_list,[A1,A2])) -->
adjective(A1) , adj_list(A2).
adj_list(formed(adj_list,[])) -->  [].

adjective(formed(adjective,[A,Pos])) --> it_is(adjective,A,Pos).

noun(formed(noun,[N,Pos])) --> it_is(noun,N,Pos).

pronoun(formed(pronoun,[P,Pos])) --> it_is(pronoun,P,Pos).

verb_phr(formed(verb_phr,[formed(main_verb,[A]),DI,formed(governing_verb,[PP])])) -->
aux_verb(A) , objects_phr(DI) , past_participle(PP).
verb_phr(formed(verb_phr,[formed(main_verb,[V]),DI,formed(governing_verb,[IN])])) -->
verb_or_aux_verb(V) , objects_phr(DI) , infinitive(IN).
verb_phr(formed(verb_phr,[formed(main_verb,[formed(governing_verb,[V])]),DI])) -->
verb_or_aux_verb(V) , objects_phr(DI).

aux_verb(formed(aux_verb,[AV,Pos])) --> it_is(aux_verb,AV,Pos).

past_participle(formed(past_participle,[PP,Pos])) -->
it_is(past_participle,PP,Pos).

verb_or_aux_verb(formed(verb_or_aux_verb,[V])) --> verb(V).
verb_or_aux_verb(formed(verb_or_aux_verb,[V])) --> aux_verb(V).

verb(formed(verb,[V,Pos])) --> it_is(verb,V,Pos).

objects_phr(formed(objects_phr,[PL,IO,DO,PP])) -->
pron_list(PL) , indir_obj_phr(IO) , dir_obj_phr(DO) , prepos_phr(PP).

pron_list(formed(pron_list,[P,PL])) --> pronoun(P) , pron_list(PL).
pron_list(formed(pron_list,[])) --> [].

dir_obj_phr(formed(dir_obj_phr,[DO])) --> noun_phr(DO).
dir_obj_phr(formed(dir_obj_phr,[])) --> [].

indir_obj_phr(formed(indir_obj_phr,[IO])) --> noun_phr(IO).
indir_obj_phr(formed(indir_obj_phr,[])) --> [].

prepos_phr(formed(prepos_phr,[P,N])) --> preposition(P) , noun_phr(N).
prepos_phr(formed(prepos_phr,[])) --> [].

preposition(formed(preposition,[P,Pos])) --> it_is(preposition,P,Pos).

infinitive(formed(infinitive,[I,Pos])) --> it_is(infinitive,I,Pos).


/*  **********  CHECKS  ********** */

check([noun],       noun_phr,       [],
select_on_first([plurality(p)])      ).

check([noun,pronoun,determiner,adjective],       subj_phr,
[],       should_be([case(nom)])      ).
check([pronoun],
pron_list,       [],       should_not_be([case(nom)])      ).

check([noun,determiner,adjective],       dir_obj_phr,       [],
should_be([case(acc)])      ).

check([noun,determiner,adjective],       indir_obj_phr,
[], should_be([case(dat)]) ).

check([prepos_phr(noun),prepos_phr(determiner),prepos_phr(adjective)],       verb_phr,
[attribute(motion(y),governing_verb),attribute(could_take_acc(y),preposition)],       should_be([case(acc)])      ).

check([prepos_phr(noun),prepos_phr(determiner),prepos_phr(adjective)],       verb_phr,
[attribute(motion(n),governing_verb)],
should_be([case(dat)])      ).

check([prepos_phr(noun),prepos_phr(determiner),prepos_phr(adjective)],       verb_phr,
[attribute(could_take_acc(n),preposition)],
should_be([case(dat)])      ).
check([pronoun],       verb_phr,
[exists(dir_obj_phr)],       should_not_be([case(acc)])
).
check([pronoun],       verb_phr,
[exists(indir_obj_phr)],       should_not_be([case(dat)])      ).

check([pronoun],       pron_list,       [],
select_on_last([case(acc)])      ).
check([determiner,adjective],
noun_phr,       [],
concord([gender,plurality],noun,[])      ).
check([adjective],
noun_phr,       [exists(definite_article)],
should_be([used_with(def_art)])      ).
check([adjective],
noun_phr,       [exists(indefinite_article)],
should_be([used_with(indef_art)])      ).
check([adjective],
noun_phr,       [empty(determiner)],
should_be([used_with(no_art)])      ).
check([main_verb],
sentence,       [],
concord([person,plurality],subj_phr(noun),[])      ).

check([main_verb],       sentence,       [],
concord([person,plurality],subj_phr(pronoun),[])      ).

check([main_verb],       sentence,       [],
select_on_last([tense(present)])      ).
check([aux_verb],
verb_phr,       [attribute(conjug_with(haben),past_participle)],
change_word("haben",aux_verb,ignore([transitivity]))      ).

check([aux_verb],       verb_phr,
[attribute(conjug_with(sein),past_participle)],
change_word("sein",aux_verb,ignore([transitivity]))      ).

check([governing_verb],       verb_phr,
[attribute(transitivity(i),governing_verb),exists(dir_obj_phr)],
comment([verb_phr,[]],
'Verb is intransitive so does not expect an object')      ).
check([governing_verb],
verb_phr,       [attribute(transitivity(i),governing_verb)],

comment([verb_phr,[attribute(transitivity(i),governing_verb),attribute(case(acc),pronoun)]],
'Verb is intransitive so does not expect an object')      ).
check([governing_verb],
verb_phr,
[attribute(transitivity(t),governing_verb),empty(dir_obj_phr)],

comment([verb_phr,[attribute(transitivity(t),governing_verb),empty(dir_obj_phr),not_attribute(case(acc),pronoun)]],
'Verb is transitive so does expect an object')      ).                     
check([main_verb],
verb_phr,
[attribute(modal(n),main_verb),exists(infinitive)],   comment([verb_phr,[]],
'You can only use this <main-verb> ... <infinitive> construction when the main verb is "werden", "muessen", "koennen", etc.')      ).

reorder(end,pron_list,[priority(2,pronoun,[case(acc)]),priority(3,pronoun,[case(dat)])]).
