/*  NAME.PL  */
/*  Shelved on the 20th April, 1988  */                


/*  This file defines a predicate name2/2.

    name2(X,Y) behaves  as name(X,Y) in standard  Edinburgh Prolog: i.e.
    it converts between the atom X,  and the list of integer ASCII codes
    Y.

    The rest of Linger never calls  name: it always calls name2. This is
    so  that it  can easily  be converted  to run  under Expert  Systems
    International Prolog-2.  In that implementation,  name(X,Y) converts
    between an atom and a string (non-standard datatype). I.e. 'name' is
    non-standard. So we supply 'name2', and use it where standard Prolog
    would use 'name'.

    To convert back to Prolog-2, comment out the third clause below, and
    remove the comments from the first two. See also UTILS.PL.

                                            J. N. Paine.
*/                    



/* name(+/-,+/-) */
/*
name2(X,Y):-
            atom(X),
            !,
            name(X,S),
            list(Y,S).

name2(X,Y):-
            list(Y,S),
            name(X,S).
*/

name2(X,Y) :-
    name(X,Y).
