
/*  FRENCH  DICTIONARY  */
/*  17 . 3 . 86 . */

/*  STANDARD  ENDINGS  */

info(gp_end,
     [[gender(m),plurality(s)],
      [gender(m),plurality(p)],
      [gender(f),plurality(s)],
      [gender(f),plurality(p)]],[],[]).

ending_type(gp_end,["","s","e","es"],[]).

/*  NOUNS  */

info(noun,[[plurality(s)],[plurality(p)]],[gender],[person(3)]).

word("",["bateau"],noun,["","x"],[m]). 
word("",["banque"],noun,["","s"],[f]). 
word("",["chat"],noun,["","s"],[m]). 
word("",["chien"],noun,["","s"],[m]).
word("",["e1glise"],noun,["","s"],[f]).
word("",["femme"],noun,["","s"],[f]). 
word("",["fille"],noun,["","s"],[f]). 
word("",["garc5on"],noun,["","s"],[m]). 
word("",["homme"],noun,["","s"],[m]). 
word("",["livre"],noun,["","s"],[m]). 
word("",["main"],noun,["","s"],[f]).
word("",["maison"],noun,["","s"],[f]).
word("",["me2re"],noun,["","s"],[f]).
word("",["mat"],noun,["","s"],[m]). 
word("",["mensonge"],noun,["","s"],[f]). 
word("",["pe2re"],noun,["","s"],[m]).
word("",["plume"],noun,["","s"],[f]). 
word("",["pomme"],noun,["","s"],[f]). 
word("",["tante"],noun,["","s"],[f]). 
word("",["tour"],noun,["","s"],[m]). 
word("",["vaisselle"],noun,["","s"],[f]). 
 
/*  PRONOUNS  */ 
 
info(pronoun,[ 
[case(nom),apostrophe(n),order(1)],[case(nom),apostrophe(y),order(1)],
[case(acc),apostrophe(n),pp_agree(y),order(2)],
[case(acc),apostrophe(y),pp_agree(y),order(2)],
[case(dat),apostrophe(n),order(3)],[case(dat),apostrophe(y),order(3)],
[case(dat),order(4)],
[case(acc),order(5)] 
],[person,plurality,gender],[]). 
 
word("je",[""],pronoun,["je","j'","me","m'","me","m'","",""],[1,s,any]). 
word("tu",[""],pronoun,["tu","tu","te","t'","te","t'","",""],[2,s,any]). 
word("il",[""],pronoun,["il","il","le","l'","lui","lui","",""],[3,s,m]). 
word("elle",[""],pronoun,["elle","elle","la","l'","lui","lui","",""],[3,s,f]). 
word("nous",[""],pronoun,["nous","","nous","","nous","","",""],[1,p,any]). 
word("vous",[""],pronoun,["vous","","vous","","vous","","",""],[2,p,any]). 
word("ils",[""],pronoun,["ils","","les","","leur","","",""],[3,p,m]). 
word("elles",[""],pronoun,["elles","","les","","leur","","",""],[3,p,f]). 
word("y",[""],pronoun,["","","","","","","y",""],[3,any,any]). 
word("en",[""],pronoun,["","","","","","","","en"],[3,any,any]). 
 
/*  REFLEXIVE  PRONOUNS  */ 
 
info(reflexive_pronoun,
     [[apostrophe(n)],[apostrophe(y)]],[person,plurality],[]).

word("me",[""],reflexive_pronoun,["me","m'"],[1,s]). 
word("te",[""],reflexive_pronoun,["te","t'"],[2,s]). 
word("se",[""],reflexive_pronoun,["se","s'"],[3,s]). 
word("nous",[""],reflexive_pronoun,["nous",""],[1,p]). 
word("vous",[""],reflexive_pronoun,["vous",""],[2,p]). 
word("se",[""],reflexive_pronoun,["se","s'"],[3,p]). 
 
/*  ADJECTIVES  */ 
 
info(adjective,[[gender(m),plurality(s)],[gender(m),plurality(p)],
                [gender(f),plurality(s)],
                [gender(f),plurality(p)]],[position],[]).

word("",["grand"],adjective,gp_end,[pre]).
word("",["joli"],adjective,gp_end,[pre]).
word("",["nouv"],adjective,["eau","eaux","elle","elles"],[pre]).
word("",["petit"],adjective,gp_end,[pre]).

word("",["blanc"],adjective,["","s","he","hes"],[post]).
word("doux",["dou"],adjective,["x","x","ce","ces"],[post]).
word("",["heureu"],adjective,["x","x","se","ses"],[post]).
word("",["intelligent"],adjective,gp_end,[post]).
word("",["laid"],adjective,gp_end,[post]). 
word("",["lent"],adjective,gp_end,[post]). 
word("",["rapide"],adjective,["","","s","s"],[post]). 
word("",["stupide"],adjective,["","","s","s"],[post]). 
word("",["vert"],adjective,gp_end,[post]). 
 
/*  ADVERBS  */ 
 
info(adverb,[],[],[]). 
 
word("",["constamment"],adverb,[],[]). 
word("",["lentement"],adverb,[],[]). 
word("",["rapidement"],adverb,[],[]). 
word("",["doucement"],adverb,[],[]). 
 
/*  DETERMINERS  */

info(determiner,
     [[gender(m),plurality(s),apostrophe(n)],
      [gender(m),plurality(s),apostrophe(y)],
      [gender(m),plurality(p)],
      [gender(f),plurality(s),apostrophe(n)],
      [gender(f),plurality(s),apostrophe(y)],
      [gender(f),plurality(p)]],[],[]).
 
word("ce",[""],determiner,["ce","cet","ces","cette","cette","ces"],[]). 
word("le",[""],determiner,["le","l'","les","la","l'","les"],[]). 
word("un",[""],determiner,["un","","des","une","","des"],[]). 

word("mon",[""],determiner,["mon","","mes","ma","","mes"],[]). 
word("ton",[""],determiner,["ton","","tes","ta","","tes"],[]). 
word("son",[""],determiner,["son","","ses","sa","","ses"],[]). 
word("notre",[""],determiner,["notre","","nos","notre","","nos"],[]). 
word("votre",[""],determiner,["votre","","vos","votre","","vos"],[]). 
word("leur",[""],determiner,["leur","","leurs","leur","","leurs"],[]). 

/*  VERBS  */ 
 
info(verb,[type],[transitivity,follow_prepos,can_be_reflex],[]). 
 
word("aimer",["aim"],verb,er_end,[t,["a2",""],y]). 
word("aller",[""],verb,aller_end,[i,[""],n]). 
word("arriver",["arriv"],verb,er_end,[i,[],n]). 
word("chanter",["chant"],verb,er_end,[i,[],n]). 
word("commencer",["commenc"],verb,c_er_end,[t,["a2","par"],n]). 
word("de1cider",["de1cid"],verb,er_end,[t,["de"],n]). 
word("donner",["donn"],verb,er_end,[t,[],y]). 
word("faire",[""],verb,faire_end,[t,[],n]). 
word("laver",["lav"],verb,er_end,[t,[],y]). 
word("manger",["mang"],verb,g_er_end,[t,[],n]). 
word("marcher",["march"],verb,er_end,[i,[],n]). 
word("parler",["parl"],verb,er_end,[i,[],y]). 
word("voir",[""],verb,voir_end,[t,[""],y]). 
word("voyager",["voyag"],verb,g_er_end,[i,[],n]). 
 
word("courir",["cour"],verb,ir_end_11,[i,[],n]). 
word("finir",["fin"],verb,ir_end,[t,["de"],n]). 
word("sortir",["sor"],verb,ir_end_16,[i,[],n]). 
 
word("entendre",["entend"],verb,re_end,[t,[""],n]). 

/*  VERB  ENDINGS  */

info(er_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],[person(3),plurality(s)],
      [person(1),plurality(p)],[person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

actual_endings(er_end_pres,["e","es","e","ons","ez","ent"]).
actual_endings(er_end_imp,["ais","ais","ait","ions","iez","aient"]).
actual_endings(er_end_fut,["erai","eras","era","erons","erez","eront"]).
actual_endings(er_end_cond,
               ["erais","erais","erait","erions","eriez","eraient"]).         
 
ending_type(er_end,er_end_pres,[present]). 
ending_type(er_end,er_end_imp,[imperfect]). 
ending_type(er_end,er_end_fut,[future]). 
ending_type(er_end,er_end_cond,[conditional]). 
 
info(g_er_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],[person(3),plurality(s)],
      [person(1),plurality(p)],[person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).               

actual_endings(g_er_end_pres,["e","es","e","eons","ez","ent"]).
actual_endings(g_er_end_imp,["eais","eais","eait","ions","iez","eaient"]).

ending_type(g_er_end,g_er_end_pres,[present]).
ending_type(g_er_end,g_er_end_imp,[imperfect]). 
ending_type(g_er_end,er_end_fut,[future]). 
ending_type(g_er_end,er_end_cond,[conditional]). 

info(c_er_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).                  

actual_endings(c_er_end_pres,["e","es","e","3ons","ez","ent"]). 
actual_endings(c_er_end_imp,["3ais","3ais","3ait","ions","iez","3aient"]). 
 
ending_type(c_er_end,c_er_end_pres,[present]). 
ending_type(c_er_end,c_er_end_imp,[imperfect]).
ending_type(c_er_end,er_end_fut,[future]).
ending_type(c_er_end,er_end_cond,[conditional]).

info(ir_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

actual_endings(ir_end_pres,
               ["is","is","it","issons","issez","issent"]).
actual_endings(ir_end_imp,
               ["issais","issais","issait","issions","issiez","issaient"]).
actual_endings(ir_end_fut,
               ["irai","iras","ira","irons","irez","iront"]).
actual_endings(ir_end_cond,
               ["irais","irais","irait","irions","iriez","iraient"]).

ending_type(ir_end,ir_end_pres,[present]).
ending_type(ir_end,ir_end_imp,[imperfect]).
ending_type(ir_end,ir_end_fut,[future]).
ending_type(ir_end,ir_end_cond,[conditional]).

info(ir_end_11,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

actual_endings(ir_end_11_pres,
               ["s","s","t","ons","ez","ent"]).
actual_endings(ir_end_11_fut,
               ["rrai","rras","rra","rrons","rrez","rront"]).
actual_endings(ir_end_11_cond,
               ["rrais","rrais","rrait","rrions","rriez","rraient"]).

ending_type(ir_end_11,ir_end_11_pres,[present]).
ending_type(ir_end_11,er_end_imp,[imperfect]).
ending_type(ir_end_11,ir_end_11_fut,[future]).
ending_type(ir_end_11,ir_end_11_cond,[conditional]).

info(ir_end_16,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

actual_endings(ir_end_16_pres,
               ["s","s","t","tons","tez","tent"]).
actual_endings(ir_end_16_imp,
               ["tais","tais","tait","tions","tiez","taient"]).
actual_endings(ir_end_16_fut,
               ["tirai","tiras","tira","tirons","tirez","tiront"]).
actual_endings(ir_end_16_cond,
               ["tirais","tirais","tirait","tirions","tiriez","tiraient"]).

ending_type(ir_end_16,ir_end_16_pres,[present]).
ending_type(ir_end_16,ir_end_16_imp,[imperfect]).
ending_type(ir_end_16,ir_end_16_fut,[future]).
ending_type(ir_end_16,ir_end_16_cond,[conditional]).

info(re_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

actual_endings(re_end_pres,["s","s","","ons","ez","ent"]).
actual_endings(re_end_fut,["rai","ras","ra","rons","rez","ront"]).
actual_endings(re_end_cond,["rais","rais","rait","rions","riez","raient"]).

ending_type(re_end,re_end_pres,[present]).
ending_type(re_end,er_end_imp,[imperfect]).
ending_type(re_end,re_end_fut,[future]).
ending_type(re_end,re_end_cond,[conditional]).

info(aller_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

ending_type(aller_end,
            ["vais","vas","va","allons","allez","vont"],[present]).
ending_type(aller_end,
            ["allais","allais","allait","allions","alliez","allaient"],
            [imperfect]).
ending_type(aller_end,
            ["irai","iras","ira","irons","irez","iront"],[future]).
ending_type(aller_end,
            ["irais","irais","irait","irions","iriez","iraient"],
            [conditional]).

info(faire_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

ending_type(faire_end,
            ["fais","fais","fait","faisons","faites","font"],[present]).
ending_type(faire_end,
            ["faisais","faisais","faisait","faisions","faisiez","faisaient"],
            [imperfect]).
ending_type(faire_end,
            ["ferai","feras","fera","ferons","ferez","feront"],
            [future]).
ending_type(faire_end,
            ["ferais","ferais","ferait","ferions","feriez","feraient"],
            [conditional]).

info(voir_end,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],[tense],[]).

ending_type(voir_end,
            ["vois","vois","voit","voyons","voyez","voient"],[present]).
ending_type(voir_end,
            ["voyais","voyais","voyait","voyions","voyiez","voyaient"],
            [imperfect]).
ending_type(voir_end,
            ["verrai","verras","verra","verrons","verrez","verront"],
            [future]).
ending_type(voir_end,
            ["verrais","verrais","verrait","verrions","verriez","verraient"],
            [conditional]).

/*  AUXILIARY  VERBS  */
info(aux_verb,
     [[person(1),plurality(s)],
      [person(2),plurality(s)],
      [person(3),plurality(s)],
      [person(1),plurality(p)],
      [person(2),plurality(p)],
      [person(3),plurality(p)]],
     [ten,transitivity],[]).

word("avoir",[""],aux_verb,
     ["ai","as","a","avons","avez","ont"],[present,t]).
word("avoir",[""],aux_verb,
     ["avais","avais","avait","avions","aviez","avaient"],[imperfect,t]).
word("avoir",[""],aux_verb,
     ["aurai","auras","aura","aurons","aurez","auront"],[future,t]).
word("avoir",[""],aux_verb,
     ["aurais","aurais","aurait","aurions","auriez","auraient"],
     [conditional,t]).

word("e4tre",[""],aux_verb,
     ["suis","es","est","sommes","e4tes","sont"],[present,t]).
word("e4tre",[""],aux_verb,
     ["e1tais","e1tais","e1tait","e1tions","e1tiez","e1taient"],[imperfect,t]).
word("e4tre",[""],aux_verb,
     ["serai","seras","sera","serons","serez","seront"],[future,t]).
word("e4tre",[""],aux_verb,
     ["serais","serais","serait","serions","seriez","seraient"],
     [conditional,t]).

/*  PAST  PARTICIPLES  */

info(past_participle,
     [[gender(m),plurality(s)],
      [gender(m),plurality(p)],
      [gender(f),plurality(s)],
      [gender(f),plurality(p)]],
     [conjug_with,transitivity,follow_prepos,can_be_reflex],[]).

word("",["aime1"],past_participle,gp_end,[avoir,t,["a2",""],y]).
word("",["alle1"],past_participle,gp_end,[e4tre,i,[""],n]).
word("",["arrive1"],past_participle,gp_end,[e4tre,i,[],n]).
word("",["chante1"],past_participle,gp_end,[avoir,i,[],n]).
word("",["commence1"],past_participle,gp_end,[avoir,t,["a2","par"],n]).
word("",["couru"],past_participle,gp_end,[avoir,i,[],n]).
word("",["fait"],past_participle,gp_end,[avoir,t,[],n]).
word("",["fini"],past_participle,gp_end,[avoir,t,["de"],n]).
word("",["de1cide1"],past_participle,gp_end,[avoir,t,["de"],n]).
word("",["donne1"],past_participle,gp_end,[avoir,t,[],y]).
word("",["entendu"],past_participle,gp_end,[avoir,t,[""],n]).
word("",["lave1"],past_participle,gp_end,[avoir,t,[],y]).
word("",["mange1"],past_participle,gp_end,[avoir,t,[],n]).
word("",["marche1"],past_participle,gp_end,[avoir,i,[],n]).
word("",["parle1"],past_participle,gp_end,[avoir,i,[],y]).
/*word("",["parti"],past_participle,gp_end,[e4tre,i,[],n]). */
word("",["sorti"],past_participle,gp_end,[e4tre,i,[],n]).
word("",["voyage1"],past_participle,gp_end,[avoir,i,[],n]).
word("",["vu"],past_participle,gp_end,[avoir,t,[""],n]).

/*  INFINITIVES  */

info(infinitive,
     [[gender(m),plurality(s)],
      [gender(m),plurality(p)],
      [gender(f),plurality(s)],
      [gender(f),plurality(p)]],[transitivity,follow_prepos],[]).

word("",["aimer"],infinitive,[],[t,["a2",""],y]).
word("",["aller"],infinitive,[],[i,[""],n]).
word("",["arriver"],infinitive,[],[i,[],n]).
word("",["chanter"],infinitive,[],[i,[],n]).
word("",["commencer"],infinitive,[],[t,["a2","par"],n]).
word("",["courir"],infinitive,[],[i,[],n]).
word("",["de1cider"],infinitive,[],[t,["de"],n]).
word("",["donner"],infinitive,[],[t,[],y]).
word("",["entendre"],infinitive,[],[t,[""],n]).
word("",["faire"],infinitive,[],[t,[],n]).
word("",["finir"],infinitive,[],[t,["de"],n]).
word("",["laver"],infinitive,[],[t,[],y]).
word("",["manger"],infinitive,[],[t,[],n]).
word("",["marcher"],infinitive,[],[i,[],n]).
word("",["parler"],infinitive,[],[i,[],y]).
/*word("",["partir"],infinitive,[],[i,[],n]). */
word("",["sortir"],infinitive,[],[i,[],n]).
word("",["voyager"],infinitive,[],[i,[],n]).
word("",["voir"],infinitive,[],[t,[""],y]).

/*  NEGATIVE  CONSTRUCTS  */

info(neg_begin,[[apostrophe(n)],[apostrophe(y)]],[],[]).

word("ne",[""],neg_begin,["ne","n'"],[]).

info(neg_end,[[]],[],[]).

word("pas",[""],neg_end,["pas"],[]).
word("jamais",[""],neg_end,["jamais"],[]).
word("rien",[""],neg_end,["rien"],[]).

/*  PREPOSITIONS  */

info(preposition,[[]],[],[]).

word("a2",[""],preposition,["a2"],[]).
word("dans",[""],preposition,["dans"],[]).
word("de",[""],preposition,["de"],[]).
word("sur",[""],preposition,["sur"],[]).
word("vers",[""],preposition,["vers"],[]).

/*  RELATIVES  */

info(relative_subject,[[]],[],[]).

word("qui",[""],relative_subject,["qui"],[]).

info(relative_object_que,[[apostrophe(n)],[apostrophe(y)]],[],[]).

word("que",[""],relative_object_que,["que","qu'"],[]).

info(relative_object_si,[[apostrophe(n)],[apostrophe(y)]],[],[]).

word("si",[""],relative_object_si,["si","s'"],[]).

/*  GUESS  CLASS  */

open1(noun).
open1(adjective).
open1(adverb).
open1(verb).
open1(past_participle).
open1(infinitive).

insert_type(noun).
insert_type(adjective).
insert_type(verb).
insert_type(adverb).
insert_type(past_participle).
insert_type(infinitive).
insert_type(determiner).
insert_type(pronoun).
insert_type(reflexive_pronoun).
insert_type(relative_subject).
insert_type(relative_object_que).
insert_type(relative_object_si).
insert_type(aux_verb).
insert_type(preposition).
insert_type(neg_begin).
insert_type(neg_end).

vowels("aeiouhy").
