/*****************************************************************************
  FILE           : ui_selection.ph
  SHORTNAME      : select.ph
  SNNS VERSION   : 3.1

  PURPOSE        : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR         : Tilman Sommer
  DATE           : 29.5.1990

  CHANGED BY     :
  IDENTIFICATION : @(#)ui_selection.ph	1.6 8/18/93
  SCCS VERSION   : 1.6
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG
             
******************************************************************************/


#ifndef _UI_SELECTION_DEFINED_
#define _UI_SELECTION_DEFINED_


/* begin global definition section */


void ui_sel_msgNumber (void);
void ui_sel_initSelectionList (void);
struct SelectionType *ui_sel_lookForItem (int unitNo);
struct SelectionType *ui_sel_lookForSelectedItem (struct SelectionType *);
void ui_sel_drawBoxes (struct Ui_DisplayType *, FlagType, struct PosType);
void ui_sel_selectOne (struct Ui_DisplayType *, FlagType, int, struct PosType);
void ui_sel_unselectOne (struct Ui_DisplayType *, FlagType, int, 
			struct PosType);
void ui_sel_selectRect (struct Ui_DisplayType *, FlagType, struct PosType, 
			struct PosType);
void ui_sel_unselectRect (struct Ui_DisplayType *, FlagType, struct PosType, 
			struct PosType);
void ui_sel_reshowItems (struct Ui_DisplayType *, FlagType);
void ui_sel_checkList (struct Ui_DisplayType *, FlagType);
void ui_sel_unselectAll (struct Ui_DisplayType *, FlagType);
void ui_sel_resetList (void);


/* handling of the selection list */
struct SelectionType  *ui_sel_listPtr;        /* pointer to first item */
int            ui_sel_numberOfSelectedItems;  /* number of selected items */


/* end global definition section */


/* begin private definition section */


static struct SelectionType *ui_sel_createItem (void);
static struct SelectionType *ui_sel_getFreeItem (void);
static void ui_sel_freeItem (struct SelectionType *);
static void ui_sel_doActionSelect (struct Ui_DisplayType *, FlagType, 
			struct SelectionType *, int, struct PosType);
static void ui_sel_showSelectedItem (struct Ui_DisplayType *, FlagType, int, 
			struct PosType);


static struct SelectionType *ui_sel_freeListPtr;/* pointer to first free item*/
static int            ui_sel_numberOfItems;     /* number of created items */
static int ui_selectionSize = UI_UNIT_SIZE;


/* end private definition section */



#endif /* _UI_SELECTION_DEFINED_ */


/* end of file */
/* lines: 46 */
