/*****************************************************************************
  FILE           : ui_remoteP.ph
  SHORTNAME      : remoteP.ph
  SNNS VERSION   : 3.1
  
  PURPOSE        : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR         : Tilman Sommer
  DATE           : 18.7.1990

  CHANGED BY     :
  IDENTIFICATION : @(#)ui_remoteP.ph	1.8 8/23/93
  SCCS VERSION   : 1.8
  LAST CHANGE    : 8/23/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG
             
*****************************************************************************/


#ifndef _UI_REMOTEP_DEFINED_
#define _UI_REMOTEP_DEFINED_


/* begin global definition section */


void ui_rem_displayPatternNumber (void);
void ui_rem_resetCounter (void);
void ui_rem_resetNet (Widget w, XtPointer button, caddr_t call_data);
void ui_rem_doInitialization (Widget w, caddr_t client_data, caddr_t call_data);
void ui_rem_deleteNet (Widget w, caddr_t client_data, caddr_t call_data);
void  ui_rem_stepsProc (Widget widget, Bool multiStepPressed, caddr_t call_data);
void ui_rem_moveInPatternsProc (Widget w, int moveType, caddr_t call_data);
void ui_rem_testProc (Widget w, XtPointer button, caddr_t call_data);
void ui_rem_deleteAllPatternsProc (Widget w, XtPointer button, 
					caddr_t call_data);
void ui_rem_modifyPatternProc (Widget w, XtPointer button, caddr_t call_data);
void ui_rem_deletePatternProc (Widget w, XtPointer button, caddr_t call_data);
void ui_rem_newPatternProc (Widget w, XtPointer button, caddr_t call_data);
void ui_rem_learnProc (Widget w, int learnType, caddr_t call_data);
void  ui_rem_stopProc (Widget widget, caddr_t client_data, caddr_t call_data);
void ui_rem_shuffleProc (Widget w, caddr_t client, caddr_t call);
void ui_rem_showModeProc (Widget w, int value, caddr_t call_data);
void ui_rem_setRandomWeights (Widget w, int randomType, caddr_t call_data);
void ui_rem_getKernelInfo (Widget w, XtPointer button, caddr_t call_data);


/* end global definition section */


/* begin private definition section */


static void ui_rem_displayCounter (void);
static void ui_rem_incCounter (void);
static void ui_rem_finishSteps (void);
static Boolean ui_rem_performStep (caddr_t client_data);
static void ui_rem_printLearnInfo (void);
static void ui_rem_finishLearning (void);
static Boolean ui_rem_performLearn (int learnType);

/* use of work procs (update steps and learning cycles) */
static XtWorkProcId  ui_workProcId =  0;         /* id reported by X */
static int           ui_numberOfWorkCycles = 0;  /* loops left to do */
static int           ui_numberOfLearnCycles = 0; /* loops to do */
static FlagType      ui_workType = UI_STEPS;     /* UI_STEPS or UI_LEARN */

static float         *ui_errorArray;
static int           ui_noErrorArrayElements;
static int           INIT_KOHONEN_PRINT;


/* end private definition section */


#endif /* _UI_REMOTEP_DEFINED_ */


/* end of file */
/* lines: 42 */
