/*****************************************************************************
  FILE           : ui_remote.c
  SHORTNAME      : remote.c
  SNNS VERSION   : 3.1

  PURPOSE        : creates the widget containing all controls of the kernal.
  NOTES          : is called only during initialisation

  AUTHOR         : Tilman Sommer
  DATE           : 20.7.1990

  CHANGED BY     :
  IDENTIFICATION : @(#)ui_remote.c	1.11 8/26/93
  SCCS VERSION   : 1.11
  LAST CHANGE    : 8/26/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG
             
******************************************************************************/


#include <stdio.h>

#include "ui.h"

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/List.h>

#include "ui_remoteP.h"
#include "ui_xWidgets.h"
#include "ui_lists.h"
#include "ui_mainP.h" /* ui_editPopup() */
#include "ui_infoP.h" /* ui_info_displayList() */
#include "ui_utilP.h" /* ui_cutTrailingZeros() */
#include "ui_patview.h"

#ifdef MASPAR_KERNEL
#include "ui_maspar.h"  /* MASPAR Kernel Interface */
#endif

#include "ui_remote.ph"


/*****************************************************************************
  FUNCTION : ui_xCreateRemotePanel

  PURPOSE  : creates a form widget for user input of unit data
  RETURNS  : void
  NOTES    : some constants are used (see below) to get a relativ positioning
             of the items. This is VERY useful after changings.

  UPDATE   :
*****************************************************************************/

void ui_xCreateRemotePanel (Widget parent)

{
    /* tabs for data fields and small buttons */

    static struct SimpleListType  listSiteFType; /* site list in
						    f-type edit panel */
    static struct SimpleListType  listSiteSite;  /* site list in
						    site edit panel */
    static struct SimpleListType  listLearnFunc;  /* func list */
    static struct SimpleListType  listUpdateFunc; /* func list */
    static struct SimpleListType  listInitFunc;   /* func list */

    Widget      stepLabel, learnLabel, updateLabel, learn2Label, pattLabel;
    Widget      mButton, sButton, button, menu, entry, mItem;
    Arg		args[10];
    Cardinal	n;
    int         i;
    char        buf[20];

    int  fontWidth = 8;

    int  titelWidth  =  7 * fontWidth;
    int  numberWidth =  7 * fontWidth;
    int  nameWidth   = 10 * fontWidth;

/***************************************************************************/

    ui_remotePanel = 
	XtCreateManagedWidget("rPanel", formWidgetClass, parent, NULL, ZERO);

/*****************************  UPDATING  *********************************/

    stepLabel =
	ui_xCreateLabelItem("STEPS", ui_remotePanel,
			   titelWidth, NULL,     NULL);

    sprintf(buf,"%d",ui_numberOfSteps);
    ui_numberOfStepsWidget =
	ui_xCreateDialogItem("numberOfSteps", ui_remotePanel,
			     buf, numberWidth,  stepLabel, NULL);

    sButton =
	ui_xCreateButtonItem("multiStep", ui_remotePanel, 
			     ui_numberOfStepsWidget, NULL);
    XtAddCallback(sButton, XtNcallback, (XtCallbackProc) ui_rem_stepsProc, (caddr_t) TRUE);

    button =
	ui_xCreateButtonItem("info", ui_remotePanel, sButton, NULL);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_getKernelInfo, NULL);

    button =
	ui_xCreateButtonItem("init", ui_remotePanel, button, NULL);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_initNet, NULL);

    button =
	ui_xCreateButtonItem("reset", ui_remotePanel, button, NULL);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_resetNet, NULL);

    sprintf(buf,"%d",ui_numberOfStepsDone);
    ui_numberOfStepsDoneWidget =
	ui_xCreateLabelItem(buf, ui_remotePanel, numberWidth, button, NULL);

    n = 0;
    XtSetArg(args[n], XtNborderWidth, 1); n++;
    XtSetArg(args[n], XtNinternalHeight, 3); n++;
    XtSetArg(args[n], XtNinternalWidth , 4); n++;
    XtSetValues(ui_numberOfStepsDoneWidget, args, n);

/*****************************  CYCLES  *********************************/

    learnLabel =
	ui_xCreateLabelItem("CYCLES", ui_remotePanel,
			   titelWidth, NULL, stepLabel);

    sprintf(buf,"%d",ui_numberOfCycles);
    ui_numberOfCyclesWidget =
	ui_xCreateDialogItem("numberOfCycles", ui_remotePanel,
			     buf, numberWidth,  learnLabel, stepLabel);

    button =
	ui_xCreateButtonItem("single", ui_remotePanel, 
			     ui_numberOfCyclesWidget, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_learnProc, (caddr_t) UI_LEARN_SINGLE);

    button =
	ui_xCreateButtonItem("all", ui_remotePanel, sButton, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_learnProc, (caddr_t) UI_LEARN_ALL);

    button =
	ui_xCreateButtonItem("stop", ui_remotePanel, button, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_stopProc,  NULL);

    button =
	ui_xCreateButtonItem("test", ui_remotePanel, button, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_testProc, NULL);

    button =	
        ui_xCreateToggleItem("shuffle", ui_remotePanel, NULL, 
			    button, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_shuffleProc, NULL);
    
    button =
	ui_xCreateMenuButtonItem("options", ui_remotePanel,
				 button, stepLabel);

    menu = 
	XtCreatePopupShell("menu", simpleMenuWidgetClass, button,
			   NULL, ZERO);

/*    mItem =
	XtCreateManagedWidget("random weights", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_popupWeights, (caddr_t) UI_RANDOM);
*/		  


    mItem =
	XtCreateManagedWidget("select update function", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    sprintf(listUpdateFunc.msg,"Select update function");
    listUpdateFunc.unitPtr  = NULL;
    listUpdateFunc.widgetPtr= button;
    listUpdateFunc.listType = UI_LIST_UPDATE_FUNC;
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_info_displayList, 
		  (caddr_t) &listUpdateFunc); 

    mItem =
	XtCreateManagedWidget("select learning function", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    sprintf(listLearnFunc.msg,"Select learning function");
    listLearnFunc.unitPtr  = NULL;
    listLearnFunc.widgetPtr= button;
    listLearnFunc.listType = UI_LIST_LEARN_FUNC;
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_info_displayList, 
		  (caddr_t) &listLearnFunc); 

    mItem =
	XtCreateManagedWidget("select init function", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    sprintf(listInitFunc.msg,"Select initialize function");
    listInitFunc.unitPtr  = NULL;
    listInitFunc.widgetPtr= button;
    listInitFunc.listType = UI_LIST_INIT_FUNC;
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_info_displayList, 
		  (caddr_t) &listInitFunc); 

    mItem =
	XtCreateManagedWidget("jog weights", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_popupWeights, (caddr_t) UI_JOG);

    mItem =
	XtCreateManagedWidget("edit f-types", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    sprintf(listSiteFType.msg,"Edit f-type table");
    listSiteFType.unitPtr  = NULL;
    listSiteFType.widgetPtr= button;
    listSiteFType.listType = UI_LIST_FTYPE_SITE;
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_editPopup, 
		  (caddr_t) &listSiteFType);

    mItem =
	XtCreateManagedWidget("edit sites", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    sprintf(listSiteSite.msg,"Edit site table");
    listSiteSite.unitPtr  = NULL;
    listSiteSite.widgetPtr= button;
    listSiteSite.listType = UI_LIST_SITE;
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_editSitePopup, 
		  (caddr_t) &listSiteSite); 

    mItem =
	XtCreateManagedWidget("delete all patterns", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_rem_deleteAllPatternsProc, NULL);

    mItem =
	XtCreateManagedWidget("clear SNNS", smeBSBObjectClass, 
			      menu, NULL, ZERO);
    XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_rem_deleteNet, NULL);


#ifdef MASPAR_KERNEL
    button =
	ui_xCreateButtonItem("maspar", ui_remotePanel, button, stepLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_masparPannel, (caddr_t) button);
#endif

/********************************** PATTERN  ***************************/

    pattLabel = 
	ui_xCreateLabelItem("PATTERN", ui_remotePanel,
			    titelWidth, NULL, learnLabel);

    sprintf(buf,"%d",ui_noOfCurrentPattern);
    ui_numberOfPatternWidget =
	ui_xCreateDialogItem("patternNo", ui_remotePanel, buf, numberWidth, 
			     pattLabel, learnLabel);

    button =
	ui_xCreateButtonItem("delete", ui_remotePanel, 
			     ui_numberOfPatternWidget, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_deletePatternProc, NULL);

    button =
	ui_xCreateButtonItem("modify", ui_remotePanel, 
			     button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_modifyPatternProc, NULL);

    button =
	ui_xCreateButtonItem("new", ui_remotePanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_newPatternProc, NULL);

    button =
	ui_xCreateButtonItem("goto", ui_remotePanel, 
			     button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_moveInPatternsProc, (caddr_t) UI_JUMP);

    button =
	ui_xCreateButtonItem("first", ui_remotePanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_moveInPatternsProc, (caddr_t) UI_FIRST);

    button =	
	ui_xCreateButtonItem("prev", ui_remotePanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_moveInPatternsProc, (caddr_t) UI_PREVIOUS);

    button =
	ui_xCreateButtonItem("next", ui_remotePanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_moveInPatternsProc, (caddr_t) UI_NEXT);

    button =
	ui_xCreateButtonItem("last", ui_remotePanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_rem_moveInPatternsProc, (caddr_t) UI_LAST);
/*
    button =
	ui_xCreateButtonItem("view", ui_remotePanel, button, learnLabel);
    XtAddCallback(button, XtNcallback, (XtCallbackProc) ui_patview_createPatviewWidget, NULL);
*/
    mButton =
	ui_xCreateMenuButtonItem("show", ui_remotePanel, 
				 button, learnLabel);

    menu = 
	XtCreatePopupShell("menu", simpleMenuWidgetClass, mButton,
			   NULL, ZERO);

    entry =
	XtCreateManagedWidget("none", smeBSBObjectClass, menu,
			      NULL, ZERO);
    XtAddCallback(entry, XtNcallback, (XtCallbackProc) ui_rem_showModeProc, (caddr_t) OUTPUT_NOTHING);
    entry =
	XtCreateManagedWidget("output", smeBSBObjectClass, menu,
			      NULL, ZERO);
    XtAddCallback(entry, XtNcallback, (XtCallbackProc) ui_rem_showModeProc, (caddr_t) OUTPUT_OUT);

    entry =
	XtCreateManagedWidget("activation", smeBSBObjectClass, menu,
			      NULL, ZERO);
    XtAddCallback(entry, XtNcallback, (XtCallbackProc) ui_rem_showModeProc, (caddr_t) OUTPUT_ACT);

    ui_showModeLabel =
	ui_xCreateLabelItem(" ", ui_remotePanel, 
			    nameWidth, mButton, learnLabel);
    ui_rem_showModeProc(NULL, ui_patternLoadMode, NULL); /* initial value */


/********************************** LEARN PARAMETER *********************/

    learn2Label = 
	ui_xCreateLabelItem("LEARN", ui_remotePanel,
			    titelWidth, NULL, pattLabel);

    for (i=0; i<UI_NO_LEARN_PARAMS; i++) {
	sprintf(buf,"%6.4f",ui_learnParameters[i]);
	ui_cutTrailingZeros(buf);
	ui_learnParameterWidgets[i] =
	    ui_xCreateDialogItem("learnParameter", ui_remotePanel,
				 buf, numberWidth, 
				 i==0 ? learn2Label : ui_learnParameterWidgets[i-1], 
				 pattLabel);
    }


/*****************************  UPDATE PARAMETER  ************************/

    updateLabel =
	ui_xCreateLabelItem("UPDATE", ui_remotePanel,
			   titelWidth, NULL,  learn2Label);

    for (i=0; i<UI_NO_LEARN_PARAMS; i++) {
	sprintf(buf,"%6.4f",ui_updateParameters[i]);
	ui_cutTrailingZeros(buf);
	ui_updateParameterWidgets[i] =
	    ui_xCreateDialogItem("updateParameter", ui_remotePanel,
				 buf, numberWidth, 
				 i==0 ? updateLabel : ui_updateParameterWidgets[i-1], 
				 learn2Label);
    }

/***************************************************************************/


    XawFormDoLayout(ui_remotePanel, True);
    ui_remoteIsCreated = TRUE;
}









/* end of file */
/* lines: 401 */
