/*****************************************************************************
  FILE           : ui_patview.ph
  SHORTNAME      : patview.ph
  SNNS VERSION   : 3.1

  PURPOSE        : header for ui_patview.c
  NOTES          : all functions will be exported

  AUTHOR         : Ralf Huebner
  DATE           : 26.10.1992

  CHANGED BY     :
  IDENTIFICATION : @(#)ui_patview.ph	1.5 8/18/93
  SCCS VERSION   : 1.5
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG
             
******************************************************************************/


#ifndef _UI_PATVIEW_DEFINED_
#define _UI_PATVIEW_DEFINED_


/* begin global definition section */


void ui_patview_setCurrentPattern(int currPat);
void ui_patview_viewPattern(void);
void ui_patview_createPatviewWidget(Widget w, Widget pannel, caddr_t call_data);

#ifndef ZERO
#define ZERO 0
#endif


/* end global definition section */


/* begin private definition section */


static void normalizePattern(FlintType *min, FlintType *max);
static int noOfInputInputUnits(void);
static void ui_closePatviewWidget (Widget w, Widget pannel, caddr_t call_data);
static void closeSetupPannel(Widget w, Widget pannel, caddr_t call_data);
static void toggleNorm(Widget w, Widget pannel, caddr_t call_data);
static void createSetupPannel(Widget w, Widget button, caddr_t call_data);
static void incScale(Widget w, Widget pannel, caddr_t call_data);
static void decScale(Widget w, Widget pannel, caddr_t call_data);
static void eventProc (Widget w, Display *display, XEvent *event);
static Widget ui_createViewWidget(char *name, Widget parent, Dimension width, 
				Dimension height, Widget left, Widget top);

static Widget ui_patviewMainWidget, ui_patviewViewWidget;
static Widget setupPannel, norm, sizeXwidget, sizeYwidget;
static int fontWidth = 8;
static int dispXsize = 128;
static int dispYsize = 128;
static Bool ui_patviewDisplayIsReady = FALSE;
static Window ui_patviewWindow;
static int currentPattern = 0;
static int maxGray = 255;
static int xSize = 20;
static int ySize = 20;

static int scale = 8;
static Bool normalize = TRUE;

static unsigned long grayPal[256];


/* end private definition section */


#endif /* _UI_PATVIEW_DEFINED_ */


/* end of file */
/* lines: 24 */
