/*****************************************************************************
  FILE           : ui_patview.c
  SHORTNAME      : patview.c
  SNNS VERSION   : 3.1

  PURPOSE        : full graphical display of patters with 256 gray values (if avaiable)
  NOTES          :

  AUTHOR         : Ralf Huebner
  DATE           : 26.10.92

  CHANGED BY     :
  IDENTIFICATION : @(#)ui_patview.c	1.10 8/18/93
  SCCS VERSION   : 1.10
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG
             
******************************************************************************/


#include <stdio.h>

#include "math.h"
#include "values.h"

#include "ui.h"
#include "ui_xWidgets.h"
#include "ui_color.h"

#include "glob_typ.h"
#include "kr_ui.h"
#include "ui_mainP.h"

#include "ui_action.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Cardinals.h>
#include "ui_textP.h"

#include "ui_patview.ph"


/*****************************************************************************
  FUNCTION : ui_closePatviewWidget

  PURPOSE  : close the pattern view pannel
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

static void ui_closePatviewWidget (Widget w, Widget pannel, caddr_t call_data)

{
   ui_patviewDisplayIsReady = FALSE;
   ui_col_freeGrayPalette(&maxGray, grayPal);
   XtDestroyWidget (pannel);
}


/*****************************************************************************
  FUNCTION : ui_patview_setCurrentPattern

  PURPOSE  : close the pattern view pannel
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

void ui_patview_setCurrentPattern(int currPat)

{
    currentPattern = currPat;
}


/*****************************************************************************
  FUNCTION : normalizePattern

  PURPOSE  : get minimum and maximum of the current pattern
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

static void normalizePattern(FlintType *min, FlintType *max)

{
    int currUnit, ioType;
    FlintType act;

    *min = MAXFLOAT;
    *max = MINFLOAT;
    currUnit = krui_getFirstUnit();
    while (currUnit != 0) {
         ioType = krui_getUnitTType(currUnit);
         if (ioType == INPUT) {
             act = krui_getUnitActivation(currUnit);
             if (act < *min) 
                 *min = act;
             if (act > *max) 
                 *max = act;
         }
         currUnit = krui_getNextUnit();
    }
}


/*****************************************************************************
  FUNCTION : noOfInputInputUnits

  PURPOSE  :  
  RETURNS  : the number of input units
  NOTES    : 

  UPDATE   :
******************************************************************************/

static int noOfInputInputUnits(void)

{
    int currUnit, ioType, unitCount = 0;

    currUnit = krui_getFirstUnit();
    while (currUnit != 0) {
         ioType = krui_getUnitTType(currUnit);
         if (ioType == INPUT) {
             unitCount++;
         }
         currUnit = krui_getNextUnit();
    }
    return(unitCount);
}



/*****************************************************************************
  FUNCTION : ui_patview_viewPattern

  PURPOSE  : displays a single pattern
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

void ui_patview_viewPattern(void)

{
    int gray, x, y;
    FlintType act, min = 0.0, max = 1.0;
    float *inputPatterns, *outputPatterns, *patPtr;
    int noOfInputPatterns, noOfOutputPatterns, noOfInputUnits = 400;


    if (NOT ui_patviewDisplayIsReady)
        return;

    if (noOfInputInputUnits() != (xSize*ySize)) {
        ui_tw_errorMessage("pattern view error: gridsize is different to the number of input units");
        return;
    }

    krui_getPatternArrays(&inputPatterns, &noOfInputPatterns,
                          &outputPatterns, &noOfOutputPatterns); 

    XClearWindow(ui_display, ui_patviewWindow);

    if (normalize)
      normalizePattern(&min, &max);
    patPtr = inputPatterns  + ((currentPattern-1) * noOfInputUnits);
    for(y=0; y<ySize; y++) {
         for(x=0; x<xSize; x++) {
             act = (*(patPtr++) - min) / fabs(max - min);
             gray = (int) (act * ((float) maxGray - 1.0));

             if (gray < 0) 
                 gray = 0;
             if (gray >= maxGray)
                 gray = maxGray-1;
             XSetForeground(ui_display, ui_gc, grayPal[gray]);
             XFillRectangle(ui_display, ui_patviewWindow, ui_gc, 
                            x*scale, y*scale, (unsigned int) scale, 
			    (unsigned int) scale);
	 }
     }

}


/*****************************************************************************
  FUNCTION : closeSetupPannel

  PURPOSE  : close the pattern setup pannel
  RETURNS  : void
  NOTES    : check if entries are valid

  UPDATE   :
******************************************************************************/

static void closeSetupPannel(Widget w, Widget pannel, caddr_t call_data)

{
    int xs, ys;
    char buf[10]; 

    xs = ui_xIntFromAsciiWidget(sizeXwidget);
    ys = ui_xIntFromAsciiWidget(sizeYwidget);
    if (noOfInputInputUnits() != (xs*ys)) {
        ui_tw_errorMessage("pattern view error: gridsize is different to the number of input units");
        sprintf(buf, "%d", xSize);
        ui_xSetString(sizeXwidget, buf);
        sprintf(buf, "%d", ySize);
        ui_xSetString(sizeYwidget, buf);
    } else {
        xSize = xs;
        ySize = ys;
        XtDestroyWidget (pannel);
    }
}


/*****************************************************************************
  FUNCTION : toggleNorm

  PURPOSE  : toggles picture normalisation
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

static void toggleNorm(Widget w, Widget pannel, caddr_t call_data)

{
    normalize = NOT normalize;
    ui_xSetToggleState (w, normalize);
}


/*****************************************************************************
  FUNCTION : createSetupPannel

  PURPOSE  : creates the patview display pannel
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

static void createSetupPannel(Widget w, Widget button, caddr_t call_data)

{
    Cardinal    n;
    Arg         args[10];
    char        buf[20];
    Position    xPos, yPos;
    Dimension   width, height;
    Widget      pannel, border, label, done;

    n = 0;
    XtSetArg(args[n], XtNwidth, &width); n++;
    XtSetArg(args[n], XtNheight, &height); n++;
    XtGetValues(button, args, n);
    XtTranslateCoords (button, (Position) (width / 2), (Position) (height / 2),
                       &xPos, &yPos);
    n = 0;
    XtSetArg(args[n], XtNx, xPos); n++;
    XtSetArg(args[n], XtNy, yPos); n++;
    setupPannel = XtCreatePopupShell ("setup", transientShellWidgetClass, 
                                      button, args, n);
    border = XtCreateManagedWidget("border", boxWidgetClass,
                                   setupPannel, NULL, ZERO);
    pannel = XtCreateManagedWidget("pannel", formWidgetClass, 
                                   border, NULL, ZERO);

    norm = ui_xCreateToggleItem("norm", pannel, NULL, NULL, NULL);
    XtAddCallback(norm, XtNcallback, (XtCallbackProc) toggleNorm, NULL);
    ui_xSetToggleState (norm, normalize);

    sprintf (buf, "%d", xSize);
    label = ui_xCreateLabelItem ("X-Size", pannel, fontWidth * 7,
                                  NULL, norm); 
    sizeXwidget = ui_xCreateDialogItem ("sizeX", pannel,
                                   buf, fontWidth * 6, label, norm);

    sprintf (buf, "%d", ySize);
    label = ui_xCreateLabelItem ("Y-Size", pannel, fontWidth * 7,
                                   NULL, label); 
    sizeYwidget = ui_xCreateDialogItem ("sizeX", pannel,
                                   buf, fontWidth * 6, label, sizeXwidget);

    done = ui_xCreateButtonItem ("done", border, NULL, label);
    XtAddCallback (done, XtNcallback, (XtCallbackProc) closeSetupPannel,
                   (Widget) setupPannel);

    ui_checkWindowPosition(setupPannel);
    XtPopup (setupPannel, XtGrabExclusive);
    ui_xDontResizeWidget(setupPannel); 
}


/*****************************************************************************
  FUNCTION : incScale

  PURPOSE  : displays a single pattern
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

static void incScale(Widget w, Widget pannel, caddr_t call_data)

{
    scale++;
    ui_patview_viewPattern();
}


/*****************************************************************************
  FUNCTION : decScale

  PURPOSE  : displays a single pattern
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

static void decScale(Widget w, Widget pannel, caddr_t call_data)

{
    scale--;
    if (scale == 0)
        scale = 1;
    ui_patview_viewPattern();
}


/*****************************************************************************
  FUNCTION : eventProc

  PURPOSE  : this is the event handler of the display window
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

static void eventProc (Widget w, Display *display, XEvent *event)

{
    switch (event->type) {
        case Expose:
               if (event->xexpose.count == 0)
                   ui_patview_viewPattern();
    }                
}


/*****************************************************************************
  FUNCTION : ui_createViewWidget

  PURPOSE  : create a widget for the pattern image
  RETURNS  : Widget
  NOTES    : 

  UPDATE   : 14.01.92
******************************************************************************/

static Widget ui_createViewWidget(char *name, Widget parent, Dimension width, 
				Dimension height, Widget left, Widget top)

{
    Cardinal n;
     Widget w;
     Arg    args[15];


    n = 0;
    XtSetArg(args[n], XtNborderWidth,  1); n++;
    XtSetArg(args[n], XtNwidth,  width); n++;
    XtSetArg(args[n], XtNheight, height); n++;
    XtSetArg(args[n], XtNfromHoriz, left); n++;
    XtSetArg(args[n], XtNfromVert, top); n++;
    XtSetArg(args[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(args[n], XtNright , XtChainRight); n++;
    XtSetArg(args[n], XtNtop   , XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    XtSetArg(args[n], XtNx, 0);n++;
    XtSetArg(args[n], XtNy, 0);n++;

    w = XtCreateManagedWidget(name, widgetClass,parent,args,n);
    return(w);
}


/*****************************************************************************
  FUNCTION : ui_patview_createPatviewWidget

  PURPOSE  : creates the pattern viewer window
  RETURNS  : void
  NOTES    :

  UPDATE   :
******************************************************************************/

void ui_patview_createPatviewWidget(Widget w, Widget pannel, caddr_t call_data)

{
    Widget       frame, setup, prev, next, done;
    Arg          args[25];
    Cardinal     n;
    char         buf[40];
    unsigned long foreground, background;

    if (ui_patviewDisplayIsReady)
        return;

    ui_col_getGrayPalette(&maxGray, grayPal);
    if (maxGray <= 1) {
        ui_tw_errorMessage("pattern view error: not enough colors");
        return;
    }

    sprintf(buf, "pattern viewer");
    n = 0;  
    ui_patviewMainWidget = XtCreatePopupShell(buf, topLevelShellWidgetClass, 
                                               ui_toplevel, args, n); 
    n = 0;
    frame = XtCreateManagedWidget("form", formWidgetClass, 
                                           ui_patviewMainWidget, args, n);

    setup = ui_xCreateButtonItem("setup", frame, NULL, NULL);
    XtAddCallback(setup, XtNcallback, (XtCallbackProc) createSetupPannel, (Widget) setup);
/* 
    ui_xSetToggleState (norm, normalize);
*/
    prev = ui_xCreateButtonItem("prev", frame, setup, NULL);
    XtAddCallback(prev, XtNcallback, (XtCallbackProc) decScale, NULL);

    next = ui_xCreateButtonItem("next", frame, prev, NULL);
    XtAddCallback(next, XtNcallback, (XtCallbackProc) incScale, NULL);

    done = ui_xCreateButtonItem("done", frame, next, NULL);
    XtAddCallback(done, XtNcallback, (XtCallbackProc) ui_closePatviewWidget,
                   (Widget) ui_patviewMainWidget);

    ui_patviewViewWidget = ui_createViewWidget("patview", frame, dispXsize,
                                   dispYsize, NULL, setup); 
    XtAddEventHandler (ui_patviewViewWidget, 
                       StructureNotifyMask | ExposureMask, 
                       FALSE, (XtEventHandler) eventProc, ui_display);
    ui_checkWindowPosition(ui_patviewMainWidget);
    XtPopup(ui_patviewMainWidget, XtGrabNone);

    ui_patviewWindow = XtWindow(ui_patviewViewWidget);
    background = WhitePixel(ui_display, ui_screen);
    foreground = BlackPixel(ui_display, ui_screen);
    XSetBackground(ui_display, ui_gc, background);
    XSetForeground(ui_display, ui_gc, foreground);

    currentPattern = 1;
    ui_patviewDisplayIsReady = TRUE;

}


/* end of file */
