/*****************************************************************************
  FILE           : ui_main.c
  SHORTNAME      : main.c
  SNNS VERSION   : 3.1

  PURPOSE        : contains many widgets to manage xgui of the SNNS
  NOTES          :

  AUTHOR         : Tilman Sommer
  DATE           : 1.4.1990

  CHANGED BY     : Kai-Uwe Herrmann 27.1.1993
  IDENTIFICATION : @(#)ui_main.c	1.20 8/19/93
  SCCS VERSION   : 1.20
  LAST CHANGE    : 8/19/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/


#include "ui.h"

#include "kr_typ.h"

#include <stdio.h>
/* for getwd() */
#include <unistd.h>

#include <sys/param.h>

#include <X11/Shell.h>
#include <X11/cursorfont.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include "glob_typ.h"
#include "ui_mainP.h"
#include "ui_print.h"
#include "ui_layerP.h"
#include "ui_xWidgets.h"
#include "ui_display.h"    /* init */
#include "ui_action.h"     /* init */
#include "ui_key.h"        /* init */
#include "ui_fileP.h"      /* init */
#include "ui_color.h"      /* init */
#include "ui_selection.h"
#include "ui_info.h"
#include "ui_infoP.h"
#include "ui_displwght.h"
#include "ui_inversion.h"
#include "bn_bignet.h"

#include "bn_menu.h"
#include "d3_pannels.h"
#include "d3_global.h"
#include "d3_graph.h"
#include "d3_main.h"
#include "o_graph.h"
#include "cc_main.h"
#include "ui_kohonen.h"

#include "snns.xbm"

#include "ui_main.ph"


/*****************************************************************************
  FUNCTION : ui_init

  PURPOSE  : do some intialization
  RETURNS  : void
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/

static void ui_init (void)

{
    ui_sel_initSelectionList();    /* list of selected units */
    ui_displ_initDisplayList();    /* list of xgui displays  */
    ui_layer_initLayerNames();     /* initial layer names */
    ui_key_init();                 /* editor key automata */
    ui_action_init();              /* editor action routines */
    (void) getcwd( ui_pathname, MAXPATHLEN );

    XawSimpleMenuAddGlobalActions(ui_appContext); /* for editor menu */
}


/*****************************************************************************
  FUNCTION : ui_xCreatePanel

  PURPOSE  : create info panel
  RETURNS  : void
  NOTES    :

  UPDATE   : 27.7.1990
******************************************************************************/

static void ui_xCreatePanel (void)

{
    Widget      menuButton, menu, mItem, label;
    Arg		args[10];
    Cardinal	n;
    char        buf[40];
    
    /* action only, if the info panel is not already created */

    if (NOT ui_infoIsCreated) {

	/* Upper left corner will be in the center of the calling button */
	
	ui_infoBox = 
	    XtCreateManagedWidget("form", formWidgetClass, ui_toplevel, NULL, ZERO);
	ui_display  = XtDisplay(ui_infoBox);

	ui_xCreateInfoPanel(ui_infoBox); 

	n = 0;
	XtSetArg(args[n], XtNleft  , XtChainLeft);   n++;
	XtSetArg(args[n], XtNright , XtChainLeft);   n++;
	XtSetArg(args[n], XtNtop   , XtChainTop);    n++;
	XtSetArg(args[n], XtNbottom, XtChainTop);    n++;	
	XtSetValues(ui_infoPanel, args, n);
	
	menuButton = 
	    ui_xCreateMenuButtonItem("windows", ui_infoBox, 
				     NULL, ui_infoPanel);

	menu = 
	    XtCreatePopupShell("menu", simpleMenuWidgetClass, menuButton,
			       NULL, ZERO);

	sprintf(buf,"FILE");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);

	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_displayFilePanel, 
		      (Widget) menuButton);
	
	sprintf(buf,"DISPLAY");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_displayGraphic, NULL);

	sprintf(buf,"3D VIEW");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) d3_displayGraphic, NULL);
#ifndef MASPAR_KERNEL
	sprintf(buf,"INVERSION");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu, NULL, ZERO);
        XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_inversion, NULL);
#endif
	sprintf(buf,"WEIGHTS");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_displWeights, NULL);

        sprintf(buf,"GRAPH");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) o_createOszi, NULL); 

	sprintf(buf,"REMOTE");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_displayRemote, NULL); 

	sprintf(buf,"BIGNET");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) bn_BignetMenu, (XtPointer) menuButton);
        
	sprintf(buf,"CASCADE");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) cc_createWindow, NULL); 
	sprintf(buf,"KOHONEN");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) kohonen_createWindow, NULL); 

	sprintf(buf,"PRINT");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_printNet, NULL);
 
	sprintf(buf,"HELP");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, (XtCallbackProc) ui_displayText, NULL);

	sprintf(buf,"TEXT");
	/* mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				     NULL, ZERO);
        */

	sprintf(buf,"QUIT");
	mItem = 
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu, 
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, ui_guiQuit, (XtPointer) ui_infoBox);
	
	ui_message = 
	    ui_xCreateLabelItem("manMsg", ui_infoBox, 60*8,
			       menuButton, ui_infoPanel);

/*	ui_display  = XtDisplay(ui_message);*/

	ui_stat_posWidget =
	    ui_xCreateLabelItem("*", ui_infoBox, 16*8, NULL, ui_message);

	label =
	    ui_xCreateLabelItem("noSel", ui_infoBox, 20 /* Icon */, 
				ui_stat_posWidget, ui_message);
	ui_stat_selNoWidget =
	    ui_xCreateLabelItem("*", ui_infoBox, 8*8, label, ui_message);

	label =
	    ui_xCreateLabelItem("flags", ui_infoBox, 20/* Icon */, 
				ui_stat_selNoWidget, ui_message);
	ui_stat_flagsWidget =
	    ui_xCreateLabelItem("*", ui_infoBox, 15*8, label, ui_message);

	XawFormDoLayout(ui_infoBox, True);
    }
}


/*****************************************************************************
  FUNCTION : ui_clickEventProc

  PURPOSE  : 
  RETURNS  : void
  NOTES    :

  UPDATE   : 11.2..1992
******************************************************************************/

static void ui_clickEventProc (Widget w, Display *display, XEvent *event)

{
    switch (event->type) {
        case ButtonPress:
            if (event->xbutton.button == 1)
                 XtDestroyWidget (w);
            break;
    }
}


/*****************************************************************************
  FUNCTION : ui_showBanner

  PURPOSE  : display Title Page
  RETURNS  : void
  NOTES    :

  UPDATE   : 11.2..1992
******************************************************************************/

static void ui_showBanner (Widget parent)

{
     int n;
     Arg arg[10];
     Widget banner, frame;
     int xwsize = snns_width;
     int ywsize = snns_height;
     unsigned int xsize, ysize;

     d3_getRootSizes (&xsize, &ysize);
     n = 0;

     XtSetArg (arg[n], XtNwidth, xwsize); n++;
     XtSetArg (arg[n], XtNheight, ywsize); n++;
     XtSetArg (arg[n], XtNx, (xsize - xwsize) / 2); n++;
     XtSetArg (arg[n], XtNy, (ysize - ywsize) / 2); n++;
     banner = XtCreatePopupShell ("banner", transientShellWidgetClass, 
                                  parent, arg, (unsigned int) n);
     n = 0;
     XtSetArg (arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   snns_bits, snns_width, snns_height)); n++;
     frame = XtCreateManagedWidget("", labelWidgetClass,
                                   banner, arg, (unsigned int) n);
     XtAddEventHandler (banner, ButtonPressMask, 
                        FALSE, (XtEventHandler) ui_clickEventProc, ui_display);
     XtPopup (banner, XtGrabNone);
     ui_xDontResizeWidget(banner); 
}


/*****************************************************************************
  FUNCTION : main

  PURPOSE  : construct all widgets and windows, realize them 
  RETURNS  : void
  NOTES    :

  UPDATE   : 1.4.1990
******************************************************************************/

void main (int argc, char **argv)

{
    ui_toplevel = 
	XtAppInitialize(&ui_appContext, "Popup", NULL, ZERO,
			(unsigned int *) &argc, argv, fallback_resources, NULL, ZERO);

    ui_init(); 
    ui_parseCmdLine(ui_appContext, argc, argv);
    ui_colVar_init();
    ui_xCreatePanel();
    XtRealizeWidget(ui_toplevel);
    ui_xDontResizeWidget(ui_toplevel);
    ui_xCreateGC(XtWindow(ui_toplevel));
    ui_showBanner (ui_toplevel);
    ui_col_init();
    d3_init_main ();
    ui_defaultPrinterValues();
    ui_loadFileFromCommandLine();
    XtAppMainLoop(ui_appContext);
}











/* end of file */
/* lines: 337 */
