/*****************************************************************************
  FILE           : ui_layerP.c
  SHORTNAME      : layerP.c
  SNNS VERSION   : 3.1

  PURPOSE        :
  NOTES          :

  AUTHOR         : Tilman Sommer
  DATE           : 31.8.1990
  AUTHOR         :
  DATE           :

  CHANGED BY     :
  IDENTIFICATION : @(#)ui_layerP.c	1.9 8/18/93
  SCCS VERSION   : 1.9
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG
             
******************************************************************************/


#include <stdio.h>

#include "ui.h"
#include "ui_utilP.h"
#include "ui_xWidgets.h"
#include "ui_layer.h"
#include "ui_action.h"

#include "ui_layerP.ph"


/*****************************************************************************
  FUNCTION : ui_layer_initLayerNames

  PURPOSE  : assign initial layer names
  RETURNS  : void
  NOTES    :

  UPDATE   : 31.8.1990
******************************************************************************/

void ui_layer_initLayerNames(void)

{
    int i;

    for (i=0; i<MAX_NO_LAYERS; i++) {
	sprintf(&ui_layerNames[i][0],"LAYER %2d",i+1);
    }
}


/*****************************************************************************
  FUNCTION : ui_layer_setLayerNames

  PURPOSE  : copy data from widgets to the name array
  RETURNS  : void
  NOTES    :

  UPDATE   : 31.8.1990
******************************************************************************/

void ui_layer_setLayerNames(void)

{
    int   i;
    int   flagWord = 0;
    int   bit = 1;
    
    for (i=0; i<MAX_NO_LAYERS; i++) {
	ui_xStringFromAsciiWidget(ui_layerNameWidgets[i], 
				  &ui_layerNames[i][0], MAX_NAME_LENGTH);
	if (ui_xGetToggleState(ui_layerButtonWidgets[i]))
	    ui_utilSetFlag(flagWord, bit);
	bit *= 2;
    }
    ui_layerReturnValue = (unsigned short) flagWord;
}    










/* end of file */
/* lines: 89 */
