/*****************************************************************************
  FILE           : ui_kohonen.c
  SHORTNAME      : ui_kohonen.c
  SNNS VERSION   : 3.1

  PURPOSE        : Creation/Callback routines for Kohonen Window
  NOTES          :

  AUTHOR         : Marcus Ritt
  DATE           : July 13 1993

  CHANGED BY     : Guenter Mamier
  IDENTIFICATION : @(#)ui_kohonen.c	1.3 8/19/93
  SCCS VERSION   : 1.3
  LAST CHANGE    : 8/19/93

     Copyright (c) 1992-1993  Neuro Group, Univ. of Tuebingen, FRG

     Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>

#include "ui.h"
#include "kr_ui.h"

#include "ui_xWidgets.h"
#include "kr_typ.h"

#include "glob_typ.h" 
#include "ui_display.h"
#include "ui_netUpdate.h"
#include "ui_main.h"
#include "ui_mainP.h"
#include "ui_confirmer.h"
#include "ui_remote.h"
#include "ui_remoteP.h"

#include "pstep.xbm"    
#include "cselect.xbm"

#include "ui_kohonen.ph"

/*****************************************************************************
  FUNCTION : kohonen_rem_displayLayerNumber(void)

  PURPOSE  : Display the value of ui_NoOfCurrentLayer in the remote panel
  RETURNS  : void
  NOTES    :

  UPDATE   : 
******************************************************************************/

static void kohonen_rem_displayLayerNumber(void)
{
    char  buf[50];

    if (NOT kohonen_open) return;

    sprintf(buf,"%d", noOfCurrentLayer);
    ui_xSetString(ui_LayerWidget, buf);
}

/*****************************************************************************
  FUNCTION : kohonen_rem_moveLayerProc

  PURPOSE  : callback. Called when cursor buttons or GOTO of LAYER is clicked.
  RETURNS  : void
  NOTES    :

  UPDATE   : 
******************************************************************************/

static void 
kohonen_rem_moveLayerProc(Widget w, int moveType, caddr_t call_data)
{
  int  temp;
  Bool doMove = FALSE;

  if (krui_getNoOfInputUnits() == 0) {
    ui_confirmOk("No input units defined!");
    return;
  }
  if (!ui_remoteIsCreated) {
    ui_confirmOk("Please create remote panel first !"); 
    return;
  }

  switch(moveType) {
  case UI_JUMP:
    temp = ui_xIntFromAsciiWidget(ui_LayerWidget);
    if ((temp>0) AND (temp<= krui_getNoOfInputUnits())) {
      noOfCurrentLayer = temp;
      kohonen_rem_displayLayerNumber();
      doMove = TRUE;
    } else ui_confirmOk("Layer goto: invalid number!");
    break;
  case UI_FIRST:
    if (noOfCurrentLayer!=1) {
      noOfCurrentLayer = 1;
      kohonen_rem_displayLayerNumber();
      doMove = TRUE;
    }
    break;
  case UI_LAST:
    if (noOfCurrentLayer != krui_getNoOfInputUnits()) {
      noOfCurrentLayer = krui_getNoOfInputUnits();
      kohonen_rem_displayLayerNumber();
      doMove = TRUE;
    }
    break;
  case UI_NEXT:
    if (++noOfCurrentLayer > krui_getNoOfInputUnits()) 
      noOfCurrentLayer = 1;
    kohonen_rem_displayLayerNumber();
    doMove = TRUE;
    break;
  case UI_PREVIOUS:
    if (--noOfCurrentLayer < 1)
      noOfCurrentLayer = krui_getNoOfInputUnits(); 
    kohonen_rem_displayLayerNumber();
    doMove = TRUE;
    break;
  }
  if (doMove) ui_rem_stepsProc(NULL, TRUE, NULL);
}

/*****************************************************************************
  FUNCTION : kohonen_tree()

  PURPOSE  : callback. Called when WINNER button is clicked.
  RETURNS  : void
  NOTES    :

  UPDATE   : 
******************************************************************************/

static void kohonen_tree(void)
{
  if (!ui_remoteIsCreated) {
    ui_confirmOk("Please create remote panel first !"); 
    return;
  }
  spanning_tree();
  ui_net_completeRefresh(ui_currentDisplay, UI_GLOBAL); 
}


/*****************************************************************************
  FUNCTION : kohonen_doneProc

  PURPOSE  : callback function of the done-buttom. 

  NOTES    :

  UPDATE   : 
******************************************************************************/

static void kohonen_doneProc(void)
{
 XtDestroyWidget(kohonen_mainWidget);
 kohonen_open= 0;
}

/*****************************************************************************
  FUNCTION : kohonen_xCreateToggleItem

  PURPOSE  : create a command widget
  NOTES    :

  UPDATE   : 
******************************************************************************/

static Widget kohonen_xCreateToggleItem (char *name, Widget parent, Widget group, Widget left, Widget top)
{
  Cardinal n;
  Widget   w;
  Arg	   args[15];

  n = 0;
  if (strcmp(name,"ExtraStep") == 0) {
    XtSetArg(args[n], XtNbitmap, 
	 (Pixmap) XCreateBitmapFromData(ui_display, 
					XDefaultRootWindow(ui_display),
					pstep_bits, pstep_width,
					pstep_height)); n++;
  }

  if (strcmp(name,"CSelect") == 0) {
    XtSetArg(args[n], XtNbitmap, 
	 (Pixmap) XCreateBitmapFromData(ui_display, 
					XDefaultRootWindow(ui_display),
					cselect_bits, cselect_width,
					cselect_height)); n++;
  }
  XtSetArg(args[n], XtNborderWidth, 0); n++;
  XtSetArg(args[n], XtNradioGroup, group); n++;
  XtSetArg(args[n], XtNinternalHeight, 1); n++;
  XtSetArg(args[n], XtNinternalWidth , 1); n++;
  XtSetArg(args[n], XtNfromVert , top);  n++;
  XtSetArg(args[n], XtNfromHoriz, left);  n++;
  XtSetArg(args[n], XtNleft  , XtChainLeft); n++;
  XtSetArg(args[n], XtNright , XtChainLeft); n++;
  XtSetArg(args[n], XtNtop   , XtChainTop); n++;
  XtSetArg(args[n], XtNbottom, XtChainTop); n++;
  w = XtCreateManagedWidget(name, toggleWidgetClass, parent, args, n);
  return(w);
}
  

/*****************************************************************************
  FUNCTION : kohonen_createWindow

  PURPOSE  : create the Kohonen window
  NOTES    :

  UPDATE   : 
******************************************************************************/


void kohonen_createWindow (void)
{
  Widget       button,done,box,form,kohonenLabel;
  Cardinal     n;
  Arg          arg[25];
  char         buf[20];

  int fontWidth = 8;
  int titelWidth  =  7 * fontWidth;
  int numberWidth = 10 * fontWidth;
  
  if (!ui_remoteIsCreated) {
    ui_confirmOk("Please create remote panel first !"); 
    return;
  }

  if (!kohonen_open) {
    kohonen_open= 1;
    sprintf(buf, "Kohonen");
    n = 0;  
    kohonen_mainWidget= 
      XtCreatePopupShell(buf,topLevelShellWidgetClass,ui_toplevel,arg,n); 

    n = 0;  
    box = XtCreateManagedWidget("box",boxWidgetClass,kohonen_mainWidget,arg,n);
    n = 0;
    form= XtCreateManagedWidget("connt", formWidgetClass, box, arg, n);

    /************* Kohonen LAYER *********************************************/

    kohonenLabel =
    ui_xCreateLabelItem("LAYER", form, 
    titelWidth, NULL, NULL);
    sprintf(buf,"%d",1);
    ui_LayerWidget =
    ui_xCreateDialogItem("Layers", form, 
    buf, numberWidth, kohonenLabel, NULL);

    button = ui_xCreateButtonItem("goto", form, ui_LayerWidget, NULL);
    XtAddCallback (button, XtNcallback, (XtCallbackProc) 
		   kohonen_rem_moveLayerProc, (caddr_t) UI_JUMP);

    button = ui_xCreateButtonItem("first", form, button, NULL);
    XtAddCallback (button, XtNcallback, (XtCallbackProc) 
		   kohonen_rem_moveLayerProc, (caddr_t) UI_FIRST);

    button = ui_xCreateButtonItem("prev", form, button, NULL);
    XtAddCallback (button, XtNcallback, (XtCallbackProc) 
		   kohonen_rem_moveLayerProc, (caddr_t) UI_PREVIOUS);

    button = ui_xCreateButtonItem("next", form, button, NULL);
    XtAddCallback (button, XtNcallback, (XtCallbackProc) 
		   kohonen_rem_moveLayerProc, (caddr_t) UI_NEXT);

    button = ui_xCreateButtonItem("last", form, button, NULL);
    XtAddCallback (button, XtNcallback, (XtCallbackProc) 
		   kohonen_rem_moveLayerProc, (caddr_t) UI_LAST);

    button = ui_xCreateButtonItem("STree", form, button, NULL);
    XtAddCallback (button, XtNcallback, (XtCallbackProc) 
		   kohonen_tree, kohonenLabel);

    /*    ui_ExtraToggle = 
    kohonen_xCreateToggleItem("ExtraStep", form, NULL, button, kohonenLabel);
    ui_xSetToggleState(ui_ExtraToggle, FALSE);
    */

    /*    button for future extension

    ui_ClassSelect =
    kohonen_xCreateToggleItem("CSelect", form, NULL, ui_ExtraToggle,
    kohonenLabel);
    ui_xSetToggleState(ui_ClassSelect, FALSE);
    */

    XawFormDoLayout(form, TRUE);

    done= ui_xCreateButtonItem("done", box, NULL, NULL);
    XtAddCallback(done,XtNcallback,(XtCallbackProc)kohonen_doneProc,NULL); 

    XtPopup (kohonen_mainWidget, XtGrabNone);
  }
  else ui_confirmOk("Kohonen panel is already created !");
}  
