/*****************************************************************************
  FILE           : ui_display.ph
  SHORTNAME      : display.ph
  SNNS VERSION   : 3.1

  PURPOSE  	 : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR   	 : Tilman Sommer
  DATE           : 1.2.1990

  CHANGED BY     :
  IDENTIFICATION : @(#)ui_display.ph	1.6 8/18/93
  SCCS VERSION   : 1.6
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/


#ifndef _UI_DISPLAY_DEFINED_
#define _UI_DISPLAY_DEFINED_


/* begin global definition section */


struct Ui_DisplayType *ui_currentDisplay;  /* current display */
struct Ui_DisplayType *ui_displ_listPtr;   /* pointer to first item */

int      ui_displ_numberOfItems;       /* number of created items */


void             ui_displ_initDisplayList(void);
void             ui_displ_freeItem(struct Ui_DisplayType *displayPtr);
	/* free it */
void             ui_displ_resetList(void);     /* free al items */
struct Ui_DisplayType  *ui_displ_getFreeItem(void);   /* create */
Bool             ui_displ_isSomeWhereToShowWeights(void);
Bool             ui_displ_isSomeWhereToShowValues(void);
void             ui_displ_freezeDisplay(Widget w, 
                                struct Ui_DisplayType *displayPtr, 
                                caddr_t call_data);


/* end global definition section */


/* begin private definition section */


static struct Ui_DisplayType *ui_displ_freeListPtr;  
	/* pointer to first free item */


static struct Ui_DisplayType *ui_displ_createItem(void);


#ifdef _UNUSED_FUNCTIONS_
static struct Ui_DisplayType  *ui_displ_getDisplayPtrViaFrameWidget(Widget);
	/* get display via frame widget */
static struct Ui_DisplayType  *ui_displ_getDisplayPtrViaDrawable(Widget);
	/* get display via widget */
#endif /* _UNUSED_FUNCTIONS_ */


/* end private definition section */


#endif /* _UI_DISPLAY_DEFINED_ */



/* end of file */
/* lines: 34 */
