/*****************************************************************************
  FILE           : d3_font8x14.h
  SHORTNAME      : font8x14
  SNNS VERSION   : 3.1

  PURPOSE        : bitmap file for the 8 X 14 font
  NOTES          : this file is included by d3_fonts.c

  AUTHOR         : Ralf Huebner
  DATE           : 1.12.1991

  CHANGED BY     : Sven Doering
  IDENTIFICATION : @(#)d3_font8x14.h	1.5 8/18/93
  SCCS VERSION   : 1.5
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#define font8x14_width 8
#define font8x14_height 14



static char font8x14 [] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd, 0x99, 0x81, 
    0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 
    0xdb, 0xff, 0xff, 0xc3, 0xe7, 0xff, 0x7e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x7f, 0x7f, 
    0x7f, 0x7f, 0x3e, 0x1c, 0x08, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x3e, 
    0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0xe7, 0x18, 0x18,
    0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 
    0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 
    0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x0f, 0x07, 0x19, 0x3c, 
    0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 
    0x33, 0x3f, 0x30, 0x30, 0x30, 0x70, 0xf0, 0xe0, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x63, 0x7f, 
    0x63, 0x63, 0x63, 0x67, 0xe7, 0xe6, 0xc0, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x18, 0xdb, 0x3c, 0xe7, 
    0x3c, 0xdb, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x40, 0x60, 0x70, 0x7c, 0x7f, 0x7c, 0x70, 
    0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
    0x03, 0x07, 0x1f, 0x7f, 0x1f, 0x07, 0x03, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 
    0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 
    0x33, 0x00, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 
    0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 
    0x30, 0x1c, 0x36, 0x63, 0x63, 0x36, 0x1c, 0x06, 
    0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 
    0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 
    0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 
    0x06, 0x7f, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x7f, 
    0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x7f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 
    0x1c, 0x3e, 0x3e, 0x7f, 0x7f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x3e, 0x3e, 
    0x1c, 0x1c, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x18, 0x18, 
    0x00, 0x00, 0x00, 0x00, 0x63, 0x63, 0x63, 0x22,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x36, 0x36, 0x7f, 0x36, 0x36, 
    0x36, 0x7f, 0x36, 0x36, 0x00, 0x00, 0x00, 0x0c, 
    0x0c, 0x3e, 0x63, 0x61, 0x60, 0x3e, 0x03, 0x43, 
    0x63, 0x3e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x61, 0x63, 0x06, 0x0c, 0x18, 0x33, 0x63, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x36, 
    0x1c, 0x3b, 0x6e, 0x66, 0x66, 0x3b, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 
    0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x0c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0c, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 
    0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0xff, 
    0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x01, 0x03, 0x06, 0x0c, 0x18, 
    0x30, 0x60, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x3e, 0x63, 0x67, 0x6f, 0x7b, 0x73, 0x63, 
    0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 
    0x1c, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 
    0x06, 0x0c, 0x18, 0x30, 0x63, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x3e, 0x63, 0x03, 0x03, 0x1e, 
    0x03, 0x03, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x06, 0x0e, 0x1e, 0x36, 0x66, 0x7f, 0x06, 
    0x06, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
    0x60, 0x60, 0x60, 0x7e, 0x03, 0x03, 0x63, 0x3e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30, 0x60, 
    0x60, 0x7e, 0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x7f, 0x63, 0x03, 0x06, 0x0c, 
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x3e, 0x63, 0x63, 0x63, 0x3e, 0x63, 0x63, 
    0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x63, 0x63, 0x63, 0x3f, 0x03, 0x03, 0x06, 0x3c, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 
    0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 
    0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 
    0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x06, 0x0c, 
    0x0c, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x3e, 0x63, 0x63, 0x6f, 0x6f, 0x6f, 0x6e, 
    0x60, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
    0x1c, 0x36, 0x63, 0x63, 0x7f, 0x63, 0x63, 0x63,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x33, 0x33, 
    0x33, 0x3e, 0x33, 0x33, 0x33, 0x7e, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1e, 0x33, 0x61, 0x60, 0x60, 
    0x60, 0x61, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7c, 0x36, 0x33, 0x33, 0x33, 0x33, 0x33, 
    0x36, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
    0x33, 0x31, 0x34, 0x3c, 0x34, 0x31, 0x33, 0x7f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x33, 0x31,
    0x34, 0x3c, 0x34, 0x30, 0x30, 0x78, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1e, 0x33, 0x61, 0x60, 0x60, 
    0x6f, 0x63, 0x33, 0x1d, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x63, 0x63, 0x63, 0x63, 0x7f, 0x63, 0x63, 
    0x63, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x06, 0x06, 
    0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x73, 0x33, 0x36, 0x36, 0x3c, 
    0x36, 0x36, 0x33, 0x73, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x31, 
    0x33, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 
    0xe7, 0xff, 0xdb, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x73, 0x7b, 
    0x7f, 0x6f, 0x67, 0x63, 0x63, 0x63, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1c, 0x36, 0x63, 0x63, 0x63, 
    0x63, 0x63, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7e, 0x33, 0x33, 0x33, 0x3e, 0x30, 0x30, 
    0x30, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 
    0x63, 0x63, 0x63, 0x63, 0x6b, 0x6f, 0x3e, 0x06, 
    0x07, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x33, 0x33,
    0x33, 0x3e, 0x36, 0x33, 0x33, 0x73, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x3e, 0x63, 0x63, 0x30, 0x1c, 
    0x06, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0xdb, 0x99, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 
    0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3e, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0xc3, 
    0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xdb, 
    0xdb, 0xff, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x3c, 0x66, 
    0xc3, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 
    0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xc3, 0x86, 
    0x0c, 0x3c, 0x30, 0x61, 0xc3, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 
    0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x40, 0x60, 0x70, 0x38, 0x1c, 0x0e, 0x07, 
    0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 
    0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 0x63, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x18, 
    0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x3c, 0x06, 0x3e, 0x66, 0x66, 0x3b, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x30, 0x30, 
    0x3c, 0x36, 0x33, 0x33, 0x33, 0x6e, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 
    0x60, 0x60, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0e, 0x06, 0x06, 0x1e, 0x36, 0x66, 0x66, 
    0x66, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x3e, 0x63, 0x7f, 0x60, 0x63, 0x3e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0x32, 
    0x30, 0x7c, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x66, 
    0x66, 0x66, 0x3e, 0x06, 0x66, 0x3c, 0x00, 0x00, 
    0x00, 0x70, 0x30, 0x30, 0x36, 0x3b, 0x33, 0x33, 
    0x33, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 
    0x0c, 0x00, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x1e, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
    0x0e, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 
    0x00, 0x00, 0x00, 0x70, 0x30, 0x30, 0x33, 0x36, 
    0x3c, 0x36, 0x33, 0x73, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x1c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 
    0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xe6, 0xff, 0xdb, 0xdb, 0xdb, 0xdb, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x6e, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 
    0x63, 0x63, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x6e, 0x33, 0x33, 0x33, 
    0x3e, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x3b, 0x66, 0x66, 0x66, 0x3e, 0x06,
    0x06, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x6e, 0x3b, 0x33, 0x30, 0x30, 0x78, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x63, 
    0x38, 0x0e, 0x63, 0x3e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x08, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 
    0x1b, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3b, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 
    0xdb, 0xdb, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x63, 0x36, 0x1c, 0x1c, 
    0x36, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x63, 0x63, 0x63, 0x63, 0x3f, 0x03, 
    0x06, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x7f, 0x66, 0x0c, 0x18, 0x33, 0x7f, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 
    0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 
    0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 
    0x18, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x18, 0x70,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x6e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x1c, 0x36, 
    0x63, 0x63, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc2, 0x66, 
    0x3c, 0x0c, 0x06, 0x7c, 0x00, 0x00, 0x00, 0xcc, 
    0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 
    0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x00,
    0x7c, 0xc6, 0xfe, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x38, 0x6c, 0x00, 0x78, 0x0c, 
    0x7c, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xcc, 0xcc, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 
    0xcc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 
    0x18, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0x76, 
    0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x00, 
    0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0x76, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xc0, 
    0xcc, 0x78, 0x18, 0x0c, 0x78, 0x00, 0x00, 0x00, 
    0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 
    0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 
    0xcc, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc6, 0x7c,
    0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 
    0x7c, 0xc6, 0xfe, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xcc, 0xcc, 0x00, 0x70, 0x30, 
    0x30, 0x30, 0x30, 0x78, 0x00, 0x00, 0x00, 0x00, 
    0x30, 0x78, 0xcc, 0x00, 0x70, 0x30, 0x30, 0x30, 
    0x30, 0x78, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x60, 
    0x30, 0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x78, 
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x10, 0x38,
    0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 
    0x00, 0x38, 0x6c, 0x38, 0x00, 0x38, 0x6c, 0xc6, 
    0xc6, 0xfe, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x18, 
    0x30, 0x60, 0x00, 0xfe, 0x66, 0x60, 0x7c, 0x60, 
    0x66, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x6c, 0xba, 0x12, 0x7e, 0x90, 0x98, 0x7e, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x6c, 0xcc, 
    0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 
    0x00, 0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 
    0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xc6, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 
    0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 
    0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
    0x00, 0x00, 0x00, 0x00, 0x30, 0x78, 0xcc, 0x00, 
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x30, 0x18, 0x00, 0xcc, 0xcc, 
    0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xc6, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 
    0x7e, 0x06, 0x0c, 0x78, 0x00, 0x00, 0xc6, 0xc6, 
    0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x38, 
    0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x00, 0xc6,
    0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x08, 0x08, 0x7e, 0xc8, 0xc8, 0xc8, 
    0xc8, 0x7e, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 
    0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60, 0x60, 
    0xe6, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 
    0x6c, 0x38, 0x10, 0xfe, 0x10, 0xfe, 0x10, 0x10, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xf8, 
    0xc4, 0xcc, 0xde, 0xcc, 0xcc, 0xe6, 0x00, 0x00, 
    0x00, 0x00, 0x1c, 0x34, 0x30, 0x30, 0x30, 0xfc, 
    0x30, 0x30, 0x30, 0x30, 0xb0, 0xe0, 0x00, 0x00, 
    0x18, 0x30, 0x60, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 
    0xcc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 
    0x30, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3c,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x60, 0x00, 
    0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0x30, 0x60, 0x00, 0xcc, 0xcc, 
    0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x76, 0xdc, 0x00, 0xdc, 0x66, 0x66, 0x66, 
    0x66, 0x66, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 
    0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x6c, 0x6c, 0x3e,
    0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x60, 0xc6, 
    0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x7f, 0x60, 0x60, 0x60, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7f, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0xc0, 0xc6, 0xcc, 0xd8, 0x30, 
    0x60, 0xdc, 0x86, 0x0c, 0x18, 0x3e, 0x00, 0x00, 
    0xc0, 0xc0, 0xc6, 0xcc, 0xd8, 0x30, 0x66, 0xce, 
    0x9a, 0x3e, 0x06, 0x06, 0x00, 0x00, 0x00, 0x18, 
    0x18, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 
    0x6c, 0xd8, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36, 
    0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 
    0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 
    0x88, 0x22, 0x88, 0x22, 0x88, 0xaa, 0x54, 0xaa, 
    0x54, 0xaa, 0x54, 0xaa, 0x54, 0xaa, 0x54, 0xaa, 
    0x54, 0xaa, 0x54, 0xba, 0xee, 0xba, 0xee, 0xba,
    0xee, 0xba, 0xee, 0xba, 0xee, 0xba, 0xee, 0xba, 
    0xee, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xfe, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 
    0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0xf7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 
    0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3f, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
    0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 
    0x18, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0xd8, 0xd8, 
    0xdc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7c, 0xc6, 0xfc, 0xc6, 0xc6, 0xfc, 0xc0, 
    0xc0, 0x40, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x6c, 0x6c, 
    0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xfe, 0xc6, 0x60, 0x30, 0x18, 0x30, 0x60, 
    0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0xd8, 0x70, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 
    0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xc0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x18, 
    0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xfc, 0x30, 0x78, 0xcc, 0xcc, 0xcc, 0x78, 
    0x30, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 
    0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x6c, 0x38,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0xc6, 
    0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0xee, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x3c, 0x60, 0x30, 0x18, 0x7c, 
    0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7c, 0xd6, 0xd6, 0x7c, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x0c, 0x7c, 0xce, 0xd6, 0xe6, 0x7c, 0x60, 0xc0, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x60, 0xc0,
    0xc0, 0xf8, 0xc0, 0xc0, 0x60, 0x38, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 
    0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 
    0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x00, 0xfc, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 
    0x0c, 0x18, 0x30, 0x60, 0x00, 0xfc, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x30, 0x60, 0xc0, 0x60, 
    0x30, 0x18, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};



/* end of file */
/* lines: 476 */
