/*****************************************************************************
  FILE           : d3_dither.c
  SHORTNAME      : dither.c
  SNNS VERSION   : 3.1

  PURPOSE        : dithering of graylevels on a monochrome display
  NOTES          :

  AUTHOR         : Ralf Huebner
  DATE           : 1.12.1991

  CHANGED BY     : Sven Doering
  IDENTIFICATION : @(#)d3_dither.c	1.7 8/18/93
  SCCS VERSION   : 1.7
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#include "d3_dither.ph"

/*****************************************************************************
  FUNCTION : dither

  PURPOSE  : calculate the dither value
  RETURNS  : 0 if black or 1 if white
  NOTES    :

******************************************************************************/


int dither (int x, int y, float level)
{
    return (level * size*size > dither_matrix[(x % size) + size * (y % size)]);
}


/* end of file */
/* lines: 71 */

