/*****************************************************************************
  FILE           : d3_anageo.ph
  SHORTNAME      : anageo.ph
  SNNS VERSION   : 3.1

  PURPOSE        : private header for d3_anageo.c
  NOTES          : all functions will be exported

  AUTHOR   	 : Ralf Huebner
  DATE     	 : 1.12.1991

  CHANGED BY     : Sven Doering
  IDENTIFICATION : @(#)d3_anageo.ph	1.6 8/18/93
  SCCS VERSION   : 1.6
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _D3_ANAGEO_DEFINED_
#define _D3_ANAGEO_DEFINED_
/* begin global definition section */

void d3_transMatrix (matrix, vector);
void d3_scaleMatrix (matrix, vector);
void d3_multMatrix (matrix, matrix, matrix);
void d3_multMatrixVector (vector, matrix, vector);
void d3_normalVector (vector, vector, vector, vector);
void d3_rotateCube (cube, vector, cube);
void d3_shiftCube (cube, cube, float, float);
void d3_shiftVector (vector, vector, float, float);
void d3_projection (cube, vector, cube);
void d3_rotateMatrix (matrix, vector);


/* end global definition section */

/* begin private definition section */

static void e_matrix (matrix m);
static void d3_rotateXmatrix (matrix, float);
static void d3_rotateYmatrix (matrix, float);
static void d3_rotateZmatrix (matrix, float);

#ifdef _UNUSED_UNCTIONS_

static void d3_showVector (vector);

#endif /* _UNUSED_FUNCTIONS_ */

/* end private definition section */

#endif
/* end of file */
/* lines:  */
