/*****************************************************************************
  FILE           : mkhead.c
  SHORTNAME      : 
  SNNS VERSION   : 3.1

  PURPOSE        : write snns pattern file header
  NOTES          :

  AUTHOR         : Ralf Huebner 
  DATE           : 2.4.93

  CHANGED BY     : 
  IDENTIFICATION : @(#)mkhead.c	1.2 8/23/93
  SCCS VERSION   : 1.2
  LAST CHANGE    : 8/23/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#include <stdio.h>
#include <time.h>


void main(int argc, char *argv[])

{
   time_t t;

   if ((argc != 4) || (int) strcmp(*++argv, "-h")==0 ) {
      fprintf (stderr, "write snns pattern file header\n\n");
      fprintf (stderr, "  usage: mkhead <#pats> <#in_units> <#out_units>\n\n");
      exit(0);
   }
   time(&t);
   printf ("SNNS pattern definition file V1.4\n");
   printf ("generated at %s\n\n", ctime( &t));
   printf ("No. of patterns     : %s\n", *argv);
   printf ("No. of input units  : %s\n", *++argv);
   printf ("No. of output units : %s\n", *++argv);
   printf ("\n");
}
   
