/*     @(#)m_art.c	1.5 8/19/93  */

/*****************************************************************************
  FILE           : m_art.c
  SHORTNAME      : 
  SNNS VERSION   : 3.1

  PURPOSE        : SNNS-Network Generator for ART-Network architectures
  NOTES          :

  AUTHOR         : Kai-Uwe Herrmann 
  DATE           : 17.05.92

  CHANGED BY     : 
  IDENTIFICATION : @(#)m_art.c	1.5 8/19/93
  SCCS VERSION   : 1.5
  LAST CHANGE    : 8/19/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/


/*########################################################################
    INCLUDE - Section
#########################################################################*/

#include <stdio.h>
#include <stdlib.h>

/*  SNNS-Kernel constants and data type definitions  */
#include "glob_typ.h"
/*  SNNS-Kernel User-Interface Function Prototypes   */
#include "kr_ui.h"


/* MAKEART-Modules for different ART-Models */
#include "m_art1.h"
#include "m_artmap.h"
#include "m_art2.h"


/*########################################################################
    DEFINITION - Section
#########################################################################*/

/* ART Model Types */
#define  ART1_MODEL          1
#define  ARTMAP_MODEL        2
#define  ART2_MODEL          3
#define  FuzzyART_MODEL      4
#define  QUIT_MAKEART       99



/*########################################################################
    PROTOTYPE - Section
#########################################################################*/

#ifdef  __STDC__

void    errChk (int);
void    title (void);
int     enter_ART_Model_Type (void);
int     enter_NoOfClusters (char *);
int     enter_NoOfRows (char *);
int     main (void);

#else

void    errChk ();
void    title ();
int     enter_ART_Model_Type ();
int     enter_NoOfClusters ();
int     enter_NoOfRows ();
int     main ();

#endif





/*########################################################################
    FUNCTION - Section
#########################################################################*/



void    errChk( errNo )
int     errNo;
{
  if (errNo != 0)
    {
    printf( "%s\n", krui_error( errNo ));
    exit( 1 );
    }
}



void  title ()
{
   printf ("\n\n");
   printf ("------ Network Generator for ART Network architectures ------\n\n");
   printf ("using: %s\n\n", krui_getVersion ());
} /* title () */



int    enter_ART_Model_Type ()
{
   int model;

   printf ("Choose the ART model: \n\n");
   printf ("    1 ....... ART 1\n");
   printf ("    2 ....... ARTMAP\n");
   printf ("    3 ....... ART 2\n");
   printf ("\n   99 ....... Quit\n");

   printf ("\n\n Enter number: ");
   scanf  ("%d",&model);

   return (model);
} /* enter_ART_Model_Type () */



int   enter_NoOfClusters (layer_name)
   char    *layer_name;
{
   int   no_of_units = 0;

   printf ("\nEnter no. of Units for %s-Layer: ",layer_name);
   scanf ("%d",&no_of_units);
   return (no_of_units);
} /* enter_NoOfClusters () */



int   enter_NoOfRows  (layer_name)
   char   *layer_name;
{
   int   no_of_rows = 1;

   printf ("\nEnter no. of rows for %s-Layer: ", layer_name);
   scanf ("%d", &no_of_rows);
   return (no_of_rows);
} /* enter_NoOfRows () */




int main()

{
    krui_err   ret_code         = KRERR_NO_ERROR;
    int        model            = 0;
    int        F1a_Cluster,
               F1b_Cluster,
               F2a_Cluster,
               F2b_Cluster,
               F1a_Rows,
               F1b_Rows,
               F2a_Rows,
               F2b_Rows;

    char    netname[80], file_name[80];


    title ();

    model = enter_ART_Model_Type ();

    switch (model) {

    case ART1_MODEL:
       printf ("\n-------- Making an ART1 Network ---------\n");
       F1a_Cluster = enter_NoOfClusters ("F1");
       F1a_Rows    = enter_NoOfRows ("F1");
       F2a_Cluster = enter_NoOfClusters ("F2");
       F2a_Rows    = enter_NoOfRows ("F2");

       if ((F1a_Cluster <= 0) || (F1a_Rows <= 0) || (F2a_Cluster <= 0) ||
           (F2a_Rows <= 0)
          )
       {
          printf("\nERROR: Invalid number of Clusters or Rows\n");
          exit(0);
       } /*if*/

       ret_code    = Make_ART1_Net (F1a_Cluster, F1a_Rows, F2a_Cluster, F2a_Rows);
       errChk (ret_code);

       break;

    case ARTMAP_MODEL:
       printf ("\n-------- Making an ARTMAP Network ---------\n");
       F1a_Cluster = enter_NoOfClusters ("ART_a F1");
       F1a_Rows    = enter_NoOfRows ("ART_a F1");
       F2a_Cluster = enter_NoOfClusters ("ART_a F2");
       F2a_Rows    = enter_NoOfRows ("ART_a F2");
       F1b_Cluster = enter_NoOfClusters ("ART_b F1");
       F1b_Rows    = enter_NoOfRows ("ART_b F1");
       F2b_Cluster = enter_NoOfClusters ("ART_b F2");
       F2b_Rows    = enter_NoOfRows ("ART_b F2");

       if ((F1a_Cluster <= 0) || (F1a_Rows <= 0) || (F2a_Cluster <= 0) ||
           (F2a_Rows <= 0) ||
           (F1b_Cluster <= 0) || (F1b_Rows <= 0) || (F2b_Cluster <= 0) ||
           (F2b_Rows <= 0)
          )
       {
          printf("\nERROR: Invalid number of Units or Rows\n");
          exit(0);
       } /*if*/

       ret_code    = Make_ARTMAP_Net (F1a_Cluster, F1a_Rows, F2a_Cluster, F2a_Rows,
                                      F1b_Cluster, F1b_Rows, F2b_Cluster, F2b_Rows
                                     );
       errChk (ret_code);

       break;
    case ART2_MODEL:
       printf ("\n-------- Making an ART2 Network ---------\n");
       F1a_Cluster = enter_NoOfClusters ("F1");
       F1a_Rows    = enter_NoOfRows ("F1");
       F2a_Cluster = enter_NoOfClusters ("F2");
       F2a_Rows    = enter_NoOfRows ("F2");

       if ((F1a_Cluster <= 0) || (F1a_Rows <= 0) || (F2a_Cluster <= 0) ||
           (F2a_Rows <= 0)
          )
       {
          printf("\nERROR: Invalid number of Clusters or Rows\n");
          exit(0);
       } /*if*/

       ret_code    = Make_ART2_Net (F1a_Cluster, F1a_Rows, F2a_Cluster, F2a_Rows);
       errChk (ret_code);

       break;

    case QUIT_MAKEART:
       exit (0);
       break;
    default :
       printf("\nERROR: There is no such model!\n");
       exit (1);
       break;
    } /* switch */

    /*  save the network */
    printf( "\nName of the network: " );
    scanf( "%s", netname );
    printf( "Filename of the network to save: " );
    scanf( "%s", file_name );
    printf( "Saveing the network ...\n" );
    ret_code = krui_saveNet( file_name, netname );
    errChk( ret_code );

    /*  before exiting: delete network  */
    krui_deleteNet();

    return (0);

} /* main () */
