/*****************************************************************************
  FILE           : strdup.c
  SHORTNAME      : 
  SNNS VERSION   : 3.1

  PURPOSE        : System V Library Function strdup.
  NOTES          : The strdup function is missing in the ULTRIX-32 operating system
                    environment.

  AUTHOR         : Niels Mache
  DATE           : 30.07.90

  CHANGED BY     : Sven Doering
  IDENTIFICATION : @(#)strdup.c	1.9 8/27/93
  SCCS VERSION   : 1.9
  LAST CHANGE    : 8/27/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#ifndef ultrix
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#ifndef strdup
#define  strdup  bsd_strdup
#endif

#else

#ifdef ultrix
   /* DEC's pseudo ansi C-compiler doesn't understand const  */
#  define const
#endif

#include <stdlib.h>
#include <sys/types.h>
#include <stddef.h>
#include <string.h>
#include <memory.h>

#include "strdup.ph"

char *strdup(const char *str )
{
	int len;
	char *copy;

        len = strlen( str ) + 1;
#ifdef  __BORLANDC__
        if (!(copy = malloc((size_t)len)))
                return((char *)NULL);
        memcpy(copy, str, (size_t)len);
#else
	if (!(copy = malloc((unsigned int)len)))
                return((char *)NULL);
	bcopy(str, copy, len);
#endif
	return(copy);
}

#endif
