/*****************************************************************************
  FILE           : learn_f.ph
  SHORTNAME      : learn_f
  SNNS VERSION   : 3.1

  PURPOSE        : SNNS-Kernel Learning Functions
  NOTES          : with following learning functions:
	           - Backpropagation
	           - Backpropagation with momentum term
                   - Quickprop
	           - Counterpropagation
	           - BackPercolation

  AUTHOR         : Niels Mache
  DATE           : 01.10.90

  CHANGED BY     : Sven Doering, Michael Vogt (Martin Reczko)
  IDENTIFICATION : @(#)learn_f.ph	1.9 8/23/93
  SCCS VERSION   : 1.9
  LAST CHANGE    : 8/23/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _LEARN_F_DEFINED_
#define  _LEARN_F_DEFINED_

/* begin global definition section */
krui_err  LEARN_ART1 (
                       int     start_pattern,
                       int     end_pattern,
                       float   parameterInArray[],
                       int     NoOfInParams,
                       float   * *parameterOutArray,
                       int     *NoOfOutParams
                     );

krui_err  LEARN_ART2 (
                       int     start_pattern,
                       int     end_pattern,
                       float   parameterInArray[],
                       int     NoOfInParams,
                       float   * *parameterOutArray,
                       int     *NoOfOutParams
                     );

krui_err  LEARN_ARTMAP (
                         int     start_pattern,
                         int     end_pattern,
                         float   parameterInArray[],
                         int     NoOfInParams,
                         float   * *parameterOutArray,
                         int     *NoOfOutParams
                       );

krui_err  LEARN_kohonen(                      
                       int     start_pattern,
                       int     end_pattern,
                       float   parameterInArray[],
                       int     NoOfInParams,
                       float   * *parameterOutArray,
                       int     *NoOfOutParams
                     );

krui_err  LEARN_backprop(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  LEARN_backpropBatch(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  LEARN_backpropMomentum(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err LEARN_quickprop(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  LEARN_CPN(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  LEARN_perc(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  RbfLearnClean(void);
krui_err  RbfLearnForward(int pattern_no);
float RbfLearnAdjustDelta(float para_center, float para_bias, float para_weight, float para_pain, float para_momentum, float para_delta_max, int learn_mask);
void RbfLearnAdjustWeights(float para_center, float para_bias, float para_weight, float para_momentum);
krui_err RbfTopoCheck(void);
krui_err  LEARN_RBF(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err LEARN_rprop(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  LEARN_BPTT(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  LEARN_BBPTT(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err  LEARN_QPTT(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);

krui_err  spanning_tree(void);

/* end global definition section */

/* begin private definition section */


#define  NET_ERROR( param )      param[ 0 ]  /*    returns the net error   */
#define  LEARN_PARAM1( param )   param[ 0 ]  /*    contains the 1st learning parameter  */
#define  LEARN_PARAM2( param )   param[ 1 ]  /*    contains the 2nd learning parameter  */
#define  LEARN_PARAM3( param )   param[ 2 ]  /*    contains the 3rd learning parameter  */
#define  LEARN_PARAM4( param )   param[ 3 ]  /*    contains the 4th learning parameter  */
#define  LEARN_PARAM5( param )   param[ 4 ]  /*    contains the 5th learning parameter  */

#define  SIGMOID_PRIME_OFFSET    0.1         /*    for modificated sigmoid function    */
#define SQR(x)  (x) * (x)

static int  NoOfLearnedPatterns;

/*  ------ ART 1 ------ */


static krui_err  put_ART1_in_pattern (
                                       int          pattern_no,
                                       TopoPtrArray topo_inp_ptr
                                     );


static krui_err adjust_ART1_weights (
                                      double        beta,
                                      TopoPtrArray  comp_ptr,
                                      TopoPtrArray  delay_ptr,
                                      struct Unit   *winner_ptr

                                    );


/*  ------ ART2 ------ */


static krui_err  put_ART2_in_pattern (
                                       int          pattern_no,
                                       TopoPtrArray topo_inp_ptr
                                     );


static krui_err adjust_ART2_weights (
                                      double        param_d,
                                      TopoPtrArray  p_ptr,
                                      struct Unit   *winner_ptr

                                    );


/*  ------ ARTMAP ------ */



static krui_err  put_ARTMAP_in_pattern (
                                         int          pattern_no,
                                         TopoPtrArray topo_inpa_ptr,
                                         TopoPtrArray topo_inpb_ptr
                                       );


static krui_err adjust_ARTMAP_weights (
                                        double        beta_a,
                                        double        beta_b,
                                        TopoPtrArray  compa_ptr,
                                        TopoPtrArray  compb_ptr,
                                        TopoPtrArray  dela_ptr,
                                        TopoPtrArray  delb_ptr,
                                        TopoPtrArray  map_ptr,
                                        struct Unit   *winner_ptr_a,
                                        struct Unit   *winner_ptr_b

                                      );





/*  --------------   Learning  Functions  ----------------------    */
static	void  propagateNetForward(int pattern_no);
static	float propagateNetBackward2(int pattern_no, float learn_parameter, float delta_max);
static	float propagateNetBackwardBatch(int pattern_no, float delta_max);
static krui_err clearDeltas(void);
static krui_err updateWeights(float eta);
static krui_err initializeBackpropMomentum(void);
static	float Backprop_momentum_FSE(int pattern_no, float learn_parameter, float mu, float FSE_term, float delta_max);
static krui_err initializeQuickprop(void);
static float  propagateNetBackwardQuickprop(int pattern_no, float delta_max);
static void MODI_quickprop(float learn_parameter, float max_factor, float decay);
static krui_err  initializeCPN(void);
static void normalize_weight(struct Unit *winner_ptr, float sum);
static void normalize_inputvector(float sum);
static float propagateNet_CPN(int pattern_no, float alpha, float beta, float threshold);
static	void  propagateNetForward_perc(int pattern_no);
static	float propagateNetBackward_perc(int pattern_no, float learn_parameter, float delta_max, float *perc_error);

static void MODI_rprop(float maxeps);
static krui_err initializeRprop(float update_val);
static float  propagateNetBackward(int pattern_no);

static krui_err  BPTT_clear_deltaw(void);
static krui_err initializeBPTT(void);
static void  BPTT_propagateNetForward(int pattern_no, int nhist);
static float initOldDeltas (int pattern_no );
static float oneStepBackprop (int backstep, int pattern_no, int nhist);
static void BPTTadapt (float step_size, float bptt_momentum);
static float BPTT_propagateNetBackward(int pattern_no, int nhist);
static float propagateNet_kohonen(int pattern_no, float  height, float width, int sizehor);
static krui_err initializeKohonenLearning(void);

/* end private definition section */

#endif 
