/*****************************************************************************
  FILE           : learn_f.h
  SHORTNAME      : learn_f
  SNNS VERSION   : 3.1

  PURPOSE        : SNNS-Kernel Learning Functions
  NOTES          : with following learning functions:
	           - Backpropagation
	           - Backpropagation with momentum term
                   - Quickprop
	           - Counterpropagation
	           - BackPercolation

  AUTHOR         : Niels Mache
  DATE           : 01.10.90

  CHANGED BY     : Sven Doering
  IDENTIFICATION : @(#)learn_f.h	1.7 8/23/93
  SCCS VERSION   : 1.7
  LAST CHANGE    : 8/23/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _LEARN_F_DEFINED_
#define  _LEARN_F_DEFINED_

extern krui_err  LEARN_ART1 (
                       int     start_pattern,
                       int     end_pattern,
                       float   parameterInArray[],
                       int     NoOfInParams,
                       float   * *parameterOutArray,
                       int     *NoOfOutParams
                     );

extern krui_err  LEARN_ART2 (
                       int     start_pattern,
                       int     end_pattern,
                       float   parameterInArray[],
                       int     NoOfInParams,
                       float   * *parameterOutArray,
                       int     *NoOfOutParams
                     );

extern krui_err  LEARN_ARTMAP (
                         int     start_pattern,
                         int     end_pattern,
                         float   parameterInArray[],
                         int     NoOfInParams,
                         float   * *parameterOutArray,
                         int     *NoOfOutParams
                       );

extern krui_err  LEARN_kohonen(                      
                       int     start_pattern,
                       int     end_pattern,
                       float   parameterInArray[],
                       int     NoOfInParams,
                       float   * *parameterOutArray,
                       int     *NoOfOutParams
  	 	     );

extern krui_err  LEARN_backprop(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err  LEARN_backpropBatch(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err  LEARN_backpropMomentum(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err LEARN_quickprop(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err  LEARN_CPN(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err  LEARN_perc(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err  RbfLearnClean(void);
extern krui_err  RbfLearnForward(int pattern_no);
extern float RbfLearnAdjustDelta(float para_center, float para_bias, float para_weight, float para_pain, float para_momentum, float para_delta_max, int learn_mask);
extern void RbfLearnAdjustWeights(float para_center, float para_bias, float para_weight, float para_momentum);
extern krui_err RbfTopoCheck(void);
extern krui_err  LEARN_RBF(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err LEARN_rprop(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);

extern krui_err  LEARN_BPTT(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err  LEARN_BBPTT(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
extern krui_err  LEARN_QPTT(int start_pattern, int end_pattern, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);

/* Function for evaluating Self-Organizing Maps */
extern krui_err  spanning_tree(void);


#endif 

/* 76 lines generated by deleteprivatedefinitions.awk */
