/*****************************************************************************
  FILE           : kr_ui.ph
  SHORTNAME      : 
  SNNS VERSION   : 3.1

  PURPOSE        : SNNS-Kernel User Interface Function Prototypes
  NOTES          :

  AUTHOR         : Niels Mache
  DATE           : 27.02.90

  CHANGED BY     : Sven Doering
  IDENTIFICATION : @(#)kr_ui.ph	1.7 8/18/93
  SCCS VERSION   : 1.7
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _KR_UI_DEFINED_
#define  _KR_UI_DEFINED_

/* begin global definition section */


#include "krui_typ.h"	/*  Interface function prototypes  */

/*
#ifdef __MSDOS__

#ifndef  int
#define  int long
#endif

#endif
*/
int  krui_getNoOfUnits(void);
int  krui_getFirstUnit(void);
int  krui_getNextUnit(void);
int  krui_getCurrentUnit(void);
krui_err  krui_setCurrentUnit(int unit_no);
char  *krui_getUnitName(int UnitNo);
krui_err  krui_setUnitName(int unit_no, char *unit_name);
int  krui_searchUnitName(char *unit_name);
int  krui_searchNextUnitName(void);
char  *krui_getUnitOutFuncName(int UnitNo);
krui_err  krui_setUnitOutFunc(int unit_no, char *unitOutFuncName);
char  *krui_getUnitActFuncName(int UnitNo);
krui_err  krui_setUnitActFunc(int unit_no, char *unitActFuncName);
char  *krui_getUnitFTypeName(int UnitNo);
FlintType  krui_getUnitActivation(int UnitNo);
krui_err  krui_setUnitActivation(int UnitNo, FlintTypeParam unit_activation);
FlintType  krui_getUnitInitialActivation(int UnitNo);
void  krui_setUnitInitialActivation(int UnitNo, FlintTypeParam unit_i_activation);
FlintType  krui_getUnitOutput(int UnitNo);
krui_err  krui_setUnitOutput(int unit_no, FlintTypeParam unit_output);
FlintType  krui_getUnitBias(int UnitNo);
void  krui_setUnitBias(int UnitNo, FlintTypeParam unit_bias);
FlintType  krui_getUnitValueA(int UnitNo);
void  krui_setUnitValueA(int UnitNo, FlintTypeParam unit_valueA);
int  krui_getUnitSubnetNo(int UnitNo);
void  krui_setUnitSubnetNo(int UnitNo, int subnet_no);
unsigned short	krui_getUnitLayerNo(int UnitNo);
void    krui_setUnitLayerNo(int UnitNo, int layer_no);
void    krui_getUnitPosition(int UnitNo, struct PosType *position);
void    krui_setUnitPosition(int UnitNo, struct PosType *position);
int   krui_getUnitNoAtPosition(struct PosType *position, int subnet_no);
int  krui_getUnitNoNearPosition(struct PosType *position, int subnet_no, int range, int gridWidth);
int  krui_getUnitTType(int unit_no);
krui_err  krui_setUnitTType(int unit_no, int UnitTType);
krui_err  krui_freezeUnit(int unit_no);
krui_err  krui_unfreezeUnit(int unit_no);
bool  krui_isUnitFrozen(int unit_no);
int  krui_getUnitInputType(int unit_no);
int  krui_createDefaultUnit(void);
int  krui_createUnit(char *unit_name, char *out_func_name, char *act_func_name, FlintTypeParam i_act, FlintTypeParam bias);
krui_err  krui_deleteUnit(int unit_no);
krui_err  krui_deleteUnitList(int no_of_units, int unit_list[]);
int  krui_createFTypeUnit(char *Ftype_symbol);
krui_err  krui_setUnitFType(int unit_no, char *Ftype_symbol);
int   krui_copyUnit(int unit_no, int copy_mode);
bool  krui_setFirstFTypeEntry(void);
bool  krui_setNextFTypeEntry(void);
bool  krui_setFTypeEntry(char *Ftype_symbol);
char  *krui_getFTypeName(void);
krui_err  krui_setFTypeName(char *Ftype_symbol);
char  *krui_getFTypeActFuncName(void);
krui_err  krui_setFTypeActFunc(char *act_func_name);
krui_err   krui_setFTypeOutFunc(char *out_func_name);
bool  krui_setFirstFTypeSite(void);
bool  krui_setNextFTypeSite(void);
char  *krui_getFTypeSiteName(void);
krui_err  krui_setFTypeSiteName(char *FType_site_name);
krui_err  krui_createFTypeEntry(char *Ftype_symbol, char *act_func_name, char *out_func_name, int no_of_sites, char **array_of_site_names);
krui_err    krui_deleteFTypeEntry(char *Ftype_symbol);
int  krui_getNoOfFunctions(void);
void  krui_getFuncInfo(int func_no, char **func_name, int *func_type);
bool  krui_isFunction(char *func_name, int func_type);
bool  krui_getFuncParamInfo(char *func_name, int func_type, int *no_of_input_params, int *no_of_output_params);
bool   krui_getFirstSiteTableEntry(char **site_name, char **site_func);
bool  krui_getNextSiteTableEntry(char **site_name, char **site_func);
char  *krui_getSiteTableFuncName(char *site_name);
krui_err  krui_createSiteTableEntry(char *site_name, char *site_func);
krui_err  krui_changeSiteTableEntry(char *old_site_name, char *new_site_name, char *new_site_func);
krui_err  krui_deleteSiteTableEntry(char *site_name);
bool  krui_setFirstSite(void);
bool  krui_setNextSite(void);
krui_err  krui_setSite(char *site_name);
FlintType   krui_getSiteValue(void);
char  *krui_getSiteName(void);
krui_err  krui_setSiteName(char *site_name);
char  *krui_getSiteFuncName(void);
krui_err  krui_addSite(char *site_name);
bool  krui_deleteSite(void);
int  krui_getFirstPredUnit(FlintType *strength);
int  krui_getNextPredUnit(FlintType *strength);
int  krui_getCurrentPredUnit(FlintType *strength);
int  krui_getFirstSuccUnit(int source_unit_no, FlintType *weight);
int  krui_getNextSuccUnit(FlintType *weight);
bool  krui_areConnected(int source_unit_no, int target_unit_no, FlintType *weight);
bool  krui_isConnected(int source_unit_no);
FlintType  krui_getLinkWeight(void);
void  krui_setLinkWeight(FlintTypeParam weight);
krui_err  krui_createLink(int source_unit_no, FlintTypeParam weight);
krui_err  krui_deleteLink(void);
krui_err  krui_deleteAllInputLinks(void);
krui_err  krui_deleteAllOutputLinks(void);

void  krui_jogWeights(FlintTypeParam minus, FlintTypeParam plus);
krui_err   krui_updateSingleUnit(int unit_no);
char  *krui_getUpdateFunc(void);
krui_err   krui_setUpdateFunc(char *update_func);
krui_err  krui_updateNet(float *parameterInArray, int NoOfInParams);
krui_err   krui_testNet(int pattern_no, float *updateParameterInArray, int updateNoOfInParams, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);

char  *krui_getInitialisationFunc(void);
krui_err   krui_setInitialisationFunc(char *initialisation_func);
krui_err  krui_initializeNet(float *parameterInArray, int NoOfInParams);

char  *krui_getLearnFunc(void);
krui_err   krui_setLearnFunc(char *learning_func);
krui_err   krui_learnAllPatterns(float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);
krui_err   krui_learnSinglePattern(int pattern_no, float *parameterInArray, int NoOfInParams, float **parameterOutArray, int *NoOfOutParams);

krui_err  krui_showPattern(int mode);
krui_err  krui_newPattern(void);
krui_err  krui_setPatternNo(int pattern_no);
krui_err  krui_deletePattern(void);
krui_err  krui_modifyPattern(void);
void  krui_deleteAllPatterns(void);
krui_err  krui_shufflePatterns(bool on_or_off);
krui_err  krui_newVectorPatternPair(float *input_patterns, int no_of_input_patterns, float *output_patterns, int no_of_output_patterns);
krui_err  krui_getPatternArrays(float **input_patterns, int *no_of_input_patterns, float **output_patterns, int *no_of_output_patterns);
krui_err  krui_allocatePatterns(int no_of_input_patterns, int no_of_output_patterns, int no_of_pattern_pairs);
krui_err  krui_setNoOfPatterns(int no_of_pattern_pairs);
int  krui_getNoOfPatterns(void);

krui_err  krui_saveNet(char *filename, char *netname);
krui_err  krui_loadNet(char *filename, char **netname);
krui_err  krui_loadPatterns(char *filename);
krui_err   krui_savePatterns(char *filename);
krui_err  krui_saveResult(char *filename, bool create, int startpattern, int endpattern, bool includeinput, bool includeoutput);
krui_err  krui_allocateUnits(int no_of_units);
void  krui_deleteNet(void);
bool  krui_getFirstSymbolTableEntry(char **symbol_name, int *symbol_type);
bool  krui_getNextSymbolTableEntry(char **symbol_name, int *symbol_type);
bool  krui_symbolSearch(char *symbol, int symbol_type);
char  *krui_getVersion(void);
void  krui_getNetInfo(int *no_of_sites, int *no_of_links, int *no_of_STable_entries, int *no_of_FTable_entries);
void  krui_getMemoryManagerInfo(int *unit_bytes, int *site_bytes, int *link_bytes, int *NTable_bytes, int *STable_bytes, int *FTable_bytes);
void  krui_getUnitDefaults(FlintType *act, FlintType *bias, int *st, int *subnet_no, int *layer_no, char **act_func, char **out_func);
krui_err  krui_setUnitDefaults(FlintTypeParam act, FlintTypeParam bias, int st, int subnet_no, int layer_no, char *act_func, char *out_func);
void  krui_resetNet(void);
void  krui_setSeedNo(long int seed);
int  krui_getNoOfInputUnits(void);
int  krui_getNoOfOutputUnits(void);
int  krui_getNoOfTTypeUnits(int UnitTType);

krui_err  krui_getXYTransTable(struct TransTable **xy_trans_tbl_ptr);
krui_err  krui_getUnitCenters(int unit_no, int center_no, struct PositionVector **unit_center);
krui_err  krui_setUnitCenters(int unit_no, int center_no, struct PositionVector *unit_center);

char  *krui_error(int error_code);

#ifdef MASPAR_KERNEL

krui_err  krui_MasPar( mode );
krui_err  krui_getMasParStatus(void);
krui_err  krui_MasParBenchmark( func_type, cycles, result );

#endif

krui_err  krui_setSpecialNetworkType(int net_type);
int  krui_getSpecialNetworkType(void);


/*
#ifdef __MSDOS__

#ifndef  KR_TYPES
#undef  int
#endif

#endif
*/


/* end global definition section */

/* begin private definition section */

static char  *krui_topo_err_msg(void);

/*#################################################

GROUP: Local Var's

#################################################*/

static int  UICurrentNameSearchUnitNo = 0;
static struct Site  *UICurrentFtypeSite = NULL;
static struct FtypeUnitStruct  *UICurrentFtypeEntry = NULL;
static char  *UICurrentNameSearchUnitSymbolPtr = NULL;


/*#################################################

GROUP: Macros

#################################################*/

/*  Check operation for compatibility with MasPar parallel 
    network implementation
*/
#ifdef MASPAR_KERNEL

#define  MASPAR_FF1_VALIDATE_OP \
if (specialNetworkType == NET_TYPE_FF1)\
  { KernelErrorCode = KRERR_MODE_FF1_INVALID_OP;\
    return( KRERR_MODE_FF1_INVALID_OP ); }\

#endif




/* end private definition section */


#endif 
