/*****************************************************************************
  FILE           : kr_td.ph
  SHORTNAME      : 
  SNNS VERSION   : 3.1

  PURPOSE        : Time delay learning and propagation functions
  NOTES          :

  AUTHOR         : Guenter Mamier
  DATE           : 20.02.93

  CHANGED BY     : Michael Vogt
  IDENTIFICATION : @(#)kr_td.ph	1.4 8/18/93
  SCCS VERSION   : 1.4
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#ifndef _KR_TD_DEFINED_
#define  _KR_TD_DEFINED_

/* begin global definition section */

void      propagateTDNetForward(int pattern_no);
krui_err  LEARN_TDbackprop(int start_pattern, int end_pattern, 
			   float parameterInArray[], int NoOfInParams,
			   float * *parameterOutArray, int *NoOfOutParams);
 
/* end global definition section */


/* begin private definition section */

#define  NET_ERROR( param )    param[ 0 ] /* returns the net error   */
#define  LEARN_PARAM1( param ) param[ 0 ] /* contains the 1st learning param.*/
#define  LEARN_PARAM2( param ) param[ 1 ] /* contains the 2nd learning param.*/
#define  LEARN_PARAM3( param ) param[ 2 ] /* contains the 3rd learning param.*/
#define  LEARN_PARAM4( param ) param[ 3 ] /* contains the 4th learning param.*/
#define  LEARN_PARAM5( param ) param[ 4 ] /* contains the 5th learning param.*/

static krui_err initializeTDBackprop(void);
static float    propagateTDNetBackward(int pattern_no, 
				       float learn_parameter, 
				       float delta_max );

/* end private definition section */

#endif 
