/*****************************************************************************
  FILE           : kr_io.h
  SHORTNAME      : kr_io.h
  SNNS VERSION   : 3.1

  PURPOSE        : SNNS-Kernel User Interface File I/O Function Prototypes 
  NOTES          :

  AUTHOR         : Niels Mache
  DATE           : 28.05.90

  CHANGED BY     : Sven Doering
  IDENTIFICATION : @(#)kr_io.h	1.10 8/18/93
  SCCS VERSION   : 1.10
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _KR_IO_DEFINED_
#define  _KR_IO_DEFINED_


/*  write complete network to disk
*/
extern krui_err  krio_saveNet( char  *filename, char  *netname );

/*  load network form disk
*/
extern krui_err krio_loadNet( char  *filename, char  **netname, char  **netfile_version );

/*  loading pattern file from disk
*/
extern krui_err krio_loadPatterns( char  *filename );

/*  write patterns to disk
*/
extern krui_err krio_savePatterns( char  *filename );

extern krui_err  krio_saveResult( char *filename,
                           bool create,
                           int  startpattern,
                           int  endpattern,
                           bool includeinput,
                           bool includeoutput);

#ifdef KERNEL3D
/*  Function for the 3D-Kernel	*/
/*  Return the base address of the XY-Translation Table
*/
extern struct TransTable  *krio_getXYTransTablePtr( void );
#endif

extern void krio_readTimeDelayDefs(void);



#endif 



/* 61 lines generated by deleteprivatedefinitions.awk */
