/*****************************************************************************
  FILE           : func_tbl.c
  SHORTNAME      : 
  SNNS VERSION   : 3.1

  PURPOSE        : SNNS-Kernel Function table
  NOTES          :

  AUTHOR         : Niels Mache
  DATE           : 25.06.90

  CHANGED BY     : Sven Doering, Michael Vogt, Ralf Huebner
  IDENTIFICATION : @(#)func_tbl.c	1.29 8/27/93
  SCCS VERSION   : 1.29
  LAST CHANGE    : 8/27/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#include <stdio.h>

#include "kr_typ.h"	    /*	Kernel Types and Constants  */
#include "kr_const.h"       /*  Constant Declarators for SNNS-Kernel  */
#include "learn_f.h"
#include "init_f.h"
#include "trans_f.h"
#include "update_f.h"
#include "arttr_f.h"
#include "tbl_func.h"
#include "kr_td.h"
#include "cc_learn.h"
#include "rcc_learn.h"
#include "dlvq_learn.h"
#include "func_tbl.ph"

/*  The function table contains 5 entries:
     - the XGUI-Identifier of this function (a pointer to a string constant),
       note that the identifier have to match [A-Za-z]^[|, ]* (i.e. the first
       character of the symbol must be a letter and all other characters must
       not match [|, ])

     - an integer constant that determine the class of the function.
       7 different classes are possible:
       OUT_FUNC, ACT_FUNC, ACT_DERIV_FUNC, SITE_FUNC, UPDATE_FUNC, LEARN_FUNC
       and INIT_FUNC

     - the number of input parameters for this function (only needed for Update,
       Init and Learning functions)

     - the number of output parameters returned by this function (only needed
       for Update and Learning functions)

     - a pointer to the (user defined) function.
*/

/*  *********************************************************************  */

/*  Here is the function table
*/
struct FuncTable  kernel_func_table[]	=
  {

/*  Output functions  */
/*  In 'kr_const.h' is defined that the NULL-pointer presents the
    identity function. So the "Out_Identity" function is represented
    by the NULL-pointer instead of the function pointer.
*/
/*  This is the DEFAULT FUNCTION  */
{"Out_Identity",     OUT_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) OUT_IDENTITY},

{"Out_Threshold05",  OUT_FUNC, 0, 0, (FunctionPtr) OUT_Threshold05},
{"Out_Clip_01",      OUT_FUNC, 0, 0, (FunctionPtr) OUT_Clip_01},
{"Out_Clip_11",      OUT_FUNC, 0, 0, (FunctionPtr) OUT_Clip_11},
{"Out_ART2_Noise_PLin", OUT_FUNC, 0, 0, (FunctionPtr) OUT_ART2_Noise_PLin},
{"Out_ART2_Noise_ContDiff", OUT_FUNC, 0, 0, (FunctionPtr) OUT_ART2_Noise_ContDiff},

/*  Activation functions  */
/*  This is the DEFAULT FUNCTION  */
{"Act_Logistic",     ACT_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) ACT_Logistic},
{"Act_Elliott",      ACT_FUNC, 0, 0, (FunctionPtr) ACT_Elliott},
{"Act_BSB",          ACT_FUNC, 0, 0, (FunctionPtr) ACT_BSBFunction},
{"Act_TanH",         ACT_FUNC, 0, 0, (FunctionPtr) ACT_TanHFunction},
{"Act_TanHPlusBias", ACT_FUNC, 0, 0, (FunctionPtr) ACT_TanHFunctionPlusBias},
{"Act_TanH_Xdiv2",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_TanHFunction_Xdiv2},
{"Act_Perceptron",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_Perceptron},
{"Act_Signum",       ACT_FUNC, 0, 0, (FunctionPtr) ACT_Signum},
{"Act_Signum0",      ACT_FUNC, 0, 0, (FunctionPtr) ACT_Signum0},
{"Act_StepFunc",     ACT_FUNC, 0, 0, (FunctionPtr) ACT_StepFunction},
{"Act_BAM",          ACT_FUNC, 0, 0, (FunctionPtr) ACT_BAMFunction},
{"Logistic_notInhibit" , ACT_FUNC, 0, 0, (FunctionPtr) ACT_LogisticI},
{"Act_MinOutPlusWeight", ACT_FUNC, 0, 0, (FunctionPtr) ACT_MinOutPlusWeight},
{"Act_Identity",     ACT_FUNC, 0, 0, (FunctionPtr) ACT_Linear},
{"Act_IdentityPlusBias", ACT_FUNC, 0, 0, (FunctionPtr) ACT_Linear_bias},
{"Act_LogisticTbl",  ACT_FUNC, 0, 0, (FunctionPtr) ACT_LogisticTbl},
{"Act_RBF_Gaussian", ACT_FUNC, 0, 0, (FunctionPtr) ACT_RBF_Gaussian},
{"Act_RBF_MultiQuadratic", ACT_FUNC, 0, 0, (FunctionPtr) ACT_RBF_Multiquadratic},
{"Act_RBF_ThinPlateSpline", ACT_FUNC, 0, 0, (FunctionPtr) ACT_RBF_Thinplatespline},
{"Act_less_than_0",  ACT_FUNC, 0, 0, (FunctionPtr) ACT_less_than_0},
{"Act_at_most_0",    ACT_FUNC, 0, 0, (FunctionPtr) ACT_at_most_0},
{"Act_at_least_2",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_at_least_2},
{"Act_at_least_1",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_at_least_1},
{"Act_exactly_1",    ACT_FUNC, 0, 0, (FunctionPtr) ACT_exactly_1},
{"Act_Product",      ACT_FUNC, 0, 0, (FunctionPtr) ACT_Product},

{"Act_ART1_NC",      ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART1_NC},
{"Act_ART2_Identity",ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART2_Linear},
{"Act_ART2_NormP",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART2_NormP},
{"Act_ART2_NormV",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART2_NormV},
{"Act_ART2_NormW",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART2_NormW},
{"Act_ART2_NormIP",  ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART2_NormIP},
{"Act_ART2_Rec",     ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART2_Rec},
{"Act_ART2_Rst",     ACT_FUNC, 0, 0, (FunctionPtr) ACT_ART2_Rst},
{"Act_ARTMAP_NCa",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_ARTMAP_NCa},
{"Act_ARTMAP_NCb",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_ARTMAP_NCb},
{"Act_ARTMAP_DRho",  ACT_FUNC, 0, 0, (FunctionPtr) ACT_ARTMAP_DRho},
{"Act_RCC_Logistic",    ACT_FUNC, 1, 0, (FunctionPtr) ACT_RCC_Logistic},
{"Act_RCC_LogisticSym", ACT_FUNC, 1, 0, (FunctionPtr) ACT_RCC_LogisticSym},
{"Act_RCC_Tanh",        ACT_FUNC, 1, 0, (FunctionPtr) ACT_RCC_Tanh},
{"Act_RCC_Linear",      ACT_FUNC, 1, 0, (FunctionPtr) ACT_RCC_Linear},
{"Act_LogSym",          ACT_FUNC, 0, 0, (FunctionPtr) ACT_LogisticSym},
{"Act_TD_Logistic",  ACT_FUNC, 0, 0, (FunctionPtr) ACT_TD_Logistic},
{"Act_TD_Elliott",  ACT_FUNC, 0, 0, (FunctionPtr) ACT_TD_Elliott},
{"Act_Euclid",       ACT_FUNC, 0, 0, (FunctionPtr) ACT_Euclid},
{"Act_Component",    ACT_FUNC, 0, 0, (FunctionPtr) ACT_Component},



/*  Derivation functions of the activation functions
    NOTE: The derivative function of the activation function MUST have
	  the same name as the belonging activation function.
*/
{"Act_Logistic",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Logistic},
{"Act_Elliott",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Elliott},
{"Act_BSB",          ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_BSBFunction},
{"Act_TanH",         ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_TanHFunction},
{"Act_TanHPlusBias", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_TanHFunction},
{"Act_TanH_Xdiv2",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_TanHFunction_Xdiv2},
{"Act_Perceptron",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_Signum",       ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_Signum0",      ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_StepFunc",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_BAM",          ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Logistic_notInhibit",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_MinOutPlusWeight", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_Identity",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Identity},
{"Act_IdentityPlusBias", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Identity},
{"Act_LogisticTbl",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Logistic},
{"Act_RBF_Gaussian", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_RBF_Gaussian},
{"Act_RBF_MultiQuadratic", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_RBF_Multiquadratic},
{"Act_RBF_ThinPlateSpline", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_RBF_Thinplatespline},
{"Act_less_than_0",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_at_most_0",    ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_at_least_1",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_at_least_2",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_exactly_1",    ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_Product",      ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},

{"Act_ART1_NC",      ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ART2_Identity",ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ART2_NormP",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ART2_NormV",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ART2_NormW",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ART2_NormIP",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ART2_Rec",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ART2_Rst",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ARTMAP_NCa",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ARTMAP_NCb",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_ARTMAP_DRho",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_RCC_Logistic",    ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Logistic},
{"Act_RCC_LogisticSym", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_LogisticSym},
{"Act_RCC_Tanh",        ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_tanh},
{"Act_RCC_Linear",      ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Identity},
{"Act_LogSym",          ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_LogisticSym},
{"Act_TD_Logistic",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_TD_Logistic},
{"Act_TD_Elliott",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_TD_Elliott},
{"Act_Euclid",       ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},
{"Act_Component",    ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy},


/*  Site functions  */
{"Site_WeightedSum", SITE_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) SITE_WeightedSum},
{"Site_Pi",          SITE_FUNC, 0, 0, (FunctionPtr) SITE_ProductA},
{"Site_Produkt",     SITE_FUNC, 0, 0, (FunctionPtr) SITE_Product},
{"Site_Max",         SITE_FUNC, 0, 0, (FunctionPtr) SITE_Max},
{"Site_Min",         SITE_FUNC, 0, 0, (FunctionPtr) SITE_Min},
{"Site_at_least_2",  SITE_FUNC, 0, 0, (FunctionPtr) SITE_at_least_2},
{"Site_at_least_1",  SITE_FUNC, 0, 0, (FunctionPtr) SITE_at_least_1},
{"Site_at_most_0",   SITE_FUNC, 0, 0, (FunctionPtr) SITE_at_most_0},
{"Site_Reciprocal",  SITE_FUNC, 0, 0, (FunctionPtr) SITE_Reciprocal_WeightedSum},

/*  Update functions  */
/*  This is the DEFAULT FUNCTION  */
{"Topological_Order", UPDATE_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) UPDATE_topologicalPropagate},

{"Kohonen_Order",     UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_KohonenPropagate},
{"Serial_Order",      UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_serialPropagate},
{"ART1_Synchronous",  UPDATE_FUNC, 1, 0, (FunctionPtr) UPDATE_ART1_syncPropagate},
{"Synchonous_Order",  UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_syncPropagate},
{"ART1_Stable",       UPDATE_FUNC, 1, 0, (FunctionPtr) UPDATE_ART1_Propagate},
{"Random_Order",      UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_randomOrderPropagate},
{"ART2_Synchronous",  UPDATE_FUNC, 1, 0, (FunctionPtr) UPDATE_ART2_syncPropagate},
{"Random_Permutation",UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_randomPermutPropagate},
{"ART2_Stable",       UPDATE_FUNC, 1, 0, (FunctionPtr) UPDATE_ART2_Propagate},
{"ARTMAP_Synchronous",UPDATE_FUNC, 3, 0, (FunctionPtr) UPDATE_ARTMAP_syncPropagate},
{"CounterPropagation",UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_CPNPropagate},
{"ARTMAP_Stable",     UPDATE_FUNC, 3, 0, (FunctionPtr) UPDATE_ARTMAP_Propagate},
{"CC_Order",          UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_CC_Propagate},
{"Dynamic_LVQ",       UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_DLVQ_Propagate},
{"RCC_Order",         UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_RCC_Propagate},
{"TimeDelay_Order",   UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_TimeDelayPropagate},
{"BPTT_Order",        UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_BPTT},
{"BAM_Order",        UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_BAM},

/*  Leaning Functions  */
/*  This is the DEFAULT FUNCTION  */
{"Std_Backpropagation", LEARN_FUNC | DEFAULT_FUNC, 2, 1, (FunctionPtr) LEARN_backprop},

{"ART1",                LEARN_FUNC, 1, 0, (FunctionPtr) LEARN_ART1},
{"BackpropBatch",       LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_backpropBatch},
{"ART2",                LEARN_FUNC, 5, 0, (FunctionPtr) LEARN_ART2},
{"BackpropMomentum",    LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_backpropMomentum},
{"ARTMAP",              LEARN_FUNC, 3, 0, (FunctionPtr) LEARN_ARTMAP},
{"TimeDelayBackprop",   LEARN_FUNC, 2, 1, (FunctionPtr) LEARN_TDbackprop},
{"BackPercolation",     LEARN_FUNC, 3, 1, (FunctionPtr) LEARN_perc},
{"Quickprop",           LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_quickprop},
{"Counterpropagation",  LEARN_FUNC, 3, 1, (FunctionPtr) LEARN_CPN},
{"Rprop",               LEARN_FUNC, 3, 1, (FunctionPtr) LEARN_rprop},
{"RadialBasisLearning", LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_RBF},
{"Dynamic_LVQ",         LEARN_FUNC, 5, 1, (FunctionPtr) LEARN_DLVQ},
{"BPTT",                LEARN_FUNC, 3, 1, (FunctionPtr) LEARN_BPTT},
{"CC",                  LEARN_FUNC, 5, 1, (FunctionPtr) LEARN_CasCor},
{"BBPTT",               LEARN_FUNC, 3, 1, (FunctionPtr) LEARN_BBPTT},
{"RCC",                 LEARN_FUNC, 5, 1, (FunctionPtr) LEARN_RecCasCor},
{"QPTT",                LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_QPTT},
{"Kohonen",             LEARN_FUNC, 2, 1, (FunctionPtr) LEARN_kohonen},


/*  Initialisation Functions  */
/*  This is the DEFAULT FUNCTION  */
{"Randomize_Weights",   INIT_FUNC | DEFAULT_FUNC, 2, 0, (FunctionPtr) INIT_randomizeWeights},

{"Random_Weights_Perc", INIT_FUNC, 2, 0, (FunctionPtr) INIT_randomizeWeights_perc},
{"CPN_Weights",         INIT_FUNC, 2, 0, (FunctionPtr) INIT_Weights_CPN},
{"RBF_Weights",         INIT_FUNC, 5, 0, (FunctionPtr) INIT_RBF_Weights},
{"RBF_Weights_Redo",    INIT_FUNC, 5, 0, (FunctionPtr) INIT_RBF_Weights_redo},
{"RBF_Weights_Kohonen", INIT_FUNC, 4, 0, (FunctionPtr) INIT_RBF_Weights_kohonen},
{"ART1_Weights",        INIT_FUNC, 2, 0, (FunctionPtr) INIT_Weights_ART1},
{"ART2_Weights",        INIT_FUNC, 2, 0, (FunctionPtr) INIT_Weights_ART2},
{"ARTMAP_Weights",      INIT_FUNC, 4, 0, (FunctionPtr) INIT_Weights_ARTMAP},
{"CC_Weights",          INIT_FUNC, 2, 0, (FunctionPtr) INIT_CC_Weights},
{"RCC_Weights",         INIT_FUNC, 2, 0, (FunctionPtr) INIT_RCC_Weights},
{"DLVQ_Weights",        INIT_FUNC, 2, 0, (FunctionPtr) INIT_CC_Weights},
{"KOHONEN_Weights",     INIT_FUNC, 2, 0, (FunctionPtr) INIT_SOM_Weights}


  };


/*  Define the function table size
*/
const int  NoOfKernelFuncs = (sizeof (kernel_func_table) / sizeof (struct FuncTable));
/*  **********************************************************************  */













