/*****************************************************************************
  FILE           : cc_learn.ph
  SHORTNAME      : 
  SNNS VERSION   : 3.1

  PURPOSE        : Header file of correspondent '.c' file
  NOTES          :

  AUTHOR         : Michael Schmalzl
  DATE           : 5.2.1993

  CHANGED BY     : Michael Schmalzl
  IDENTIFICATION : @(#)cc_learn.ph	1.5 8/18/93
  SCCS VERSION   : 1.5
  LAST CHANGE    : 8/18/93

             Copyright (c) 1990-1993  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/
#ifndef _CC_LEARN_DEFINED_
#define  _CC_LEARN_DEFINED_

/* begin global definition section */
krui_err LEARN_CasCor(int StartPattern, int EndPattern,
                      float *ParameterInArray, int NoOfInParams,
                      float **ParameterOutArray, int *NoOfOutParams);
/* end   global definition section */

/* begin privat definition section */
static void cc_calculateSpecialUnitActivation(int startPattern,int endPattern);
static krui_err cc_generateSpecialUnits(int MaxSpecialUnitNo, int OutputXMax,int type);
static int  cc_test(int StartPattern,int EndPattern,float maxPixelError); 
static void  cc_propagateNetForward(int PatternNo);
static void  cc_calculateOutputUnitError(int StartPattern,int EndPattern);

static void  cc_QPS_trainNet(int maxNoOfCovarianceUpdateCycles, float minCovarianceChange, 
                             int specialPatience,int StartPattern,int EndPattern,
                             float param4, float param5, float param6, int MaxSpecialUnitNo);
static float cc_QPS_propagateNetBackward(int StartPattern,int EndPattern,int counter);
static void  cc_QPS_updateNet(float epsilon,float mu, float decay);

static void  cc_QPO_trainNet(int maxNoOfErrorUpdateCycles, float minErrorChange, 
                             int outPatience, int StartPattern,int EndPattern,
                             float param1, float param2,float param3,
                             float **ParameterOutArray,int *NoOfOutParams);
static float cc_QPO_propagateNetBackward(int PatternNo);
static void  cc_QPO_updateNet(float epsilon, float mu, float decay);

static void  cc_BPS_trainNet(int maxNoOfCovarianceUpdateCycles, float minCovarianceChange, 
                             int specialPatience,int StartPattern,int EndPattern,
                             float param4, float param5, float param6, int MaxSpecialUnitNo);
static float cc_BPS_propagateNetBackward(int StartPattern, int endPattern , int counter, float eta, float mu);

static void  cc_BPO_trainNet(int maxNoOfErrorUpdateCycles, float minErrorChange, 
                             int outPatience, int StartPattern,int EndPattern,
                             float param1, float param2,float param3,
                             float **ParameterOutArray,int *NoOfOutParams);
static float cc_BPO_propagateNetBackward(int PatternNo, float eta, float mu, float fse);

static void  cc_RPS_trainNet(int maxNoOfCovarianceUpdateCycles, float minCovarianceChange, 
                             int specialPatience,int StartPattern,int EndPattern,
                             float param4, float param5, float param6, int MaxSpecialUnitNo);
static float cc_RPS_propagateNetBackward(int StartPattern,int EndPattern,int counter);
static void  cc_RPS_updateNet(float epsilon, float mu, float decay);

static void  cc_RPO_trainNet(int maxNoOfErrorUpdateCycles, float minErrorChange, 
                             int outPatience, int StartPattern,int EndPattern,
                             float param1, float param2,float param3,
                             float **ParameterOutArray,int *NoOfOutParams);
static float cc_RPO_propagateNetBackward(int PatternNo);
static void  cc_RPO_updateNet(float epsilon, float mu, float decay);

static krui_err cc_generateHiddenUnit(int maxYPosOfHiddenUnit,int *xPosOfLastInsertedHiddenUnit,
                                      int *yPosOfLastInsertedHiddenUnit);


/* end privat definition section */


#endif /* _CC_LEARN_DEFINED_ */
