// This function interpolates the value at the point (x, y)
// using a second order polynomial fitted to the six nearest
// neighboring elements of an M by N array of real numbers.
// The array is assumed to repeat infinitly in every direction.
#include <double.Matrix.h>

inline	mod(int i, int m) {
  return i < 0 ? m - i%m : i%m;
  }

double	doubleArray::f(double x, double y) const {
  int	i = nint(x);
  int	j = nint(y);
  int	r = signbit(x - i);
  int	e = signbit(y - j);
	x = fabs(x - i);
	y = fabs(x - i);
  return   (1.0 - x*x - y*y + x*y)*X[mod(i  ,M)*L+mod(j  ,N)]
	 +   (0.5*(x*x + x) - x*y)*X[mod(i+r,M)*L+mod(j  ,N)]
	 +   (0.5*(x*x - x)      )*X[mod(i-r,M)*L+mod(j  ,N)]
	 +   (0.5*(y*y - y)      )*X[mod(i  ,M)*L+mod(j-s,N)]
	 +   (0.5*(y*y + y) - x*y)*X[mod(i  ,M)*L+mod(j+s,N)]
	 +                   (x*y)*X[mod(i+r,M)*L+mod(j+s,N)];
  }
