#define PI M_PI
#include <math.h>
#include <libc.h>
#include <bool.h>
#include <stream.h>
#include <GetOpt.h>

int
main (int argc, char **argv)
  {
    int		examples = 0;			// number of examples
    int		verbose  = FALSE;		// verbose reporting off
    long	seedval	 = 43;			// random number seed value
    double	turns	 = 1.0;			// number of 180 degree turns
    GetOpt	getopt (argc, argv, "e:s:t:v");

  int option;
  while ((option = getopt()) != EOF)
    switch (option)
      {
        case 'e':				// number of examples
	  examples	= atoi(getopt.optarg);
          break;
        case 's':				// seed value
	  seedval	= atoi(getopt.optarg);
          break;
        case 't':				// 180 degree turns
	  turns		= atoi(getopt.optarg);
          break;
        case 'v':				// verbose reporting on
	  verbose	= TRUE;
          break;
        case '?':
          cerr << "Unrecognized option!\n";
      };

    if (verbose)
      cerr	<< " seedval = "	<< seedval
		<< " turns = "		<< turns
		<< " examples = "	<< examples << "\n";
    cout << examples << "\n";			// training set
    srand48(seedval);
    for (int example = 0; example < examples; example++)
      {
	double rho = PI*turns*drand48();
	double phi = PI*turns*drand48();
	cout << form("%20.12e", rho) << form("%20.12e", phi)
	     << form("%20.12e",   rho*cos(rho - phi))
	     << form("%20.12e\n", rho*sin(rho - phi));
      };
    cout.flush();
  }
