#define EXTERN
#include "cog.h"

#ifdef __TURBOC__
#	include <alloc.h>
#endif

main(argc, argv)
int argc; char *argv[];
{
  int l,i;
  int x,y;
  int c, pat;
  char *basename();
  FILE *inwfp, *outwfp;

  progname = basename(argv[0]);

  while (--argc > 0 && (*++argv)[0] == '-')
	while (c = *++argv[0]) switch(c) {
		default:  panic("%s:  illegal option -%c\n",progname,c);
	}

  if (argc < 2 || argc > 3)
	panic("Usage:  %s <wgt-file> <in-file> [<out-file>]\n", progname);

  if ((inwfp = fopen(*argv, "rb")) == NULL)
	panic("%s:  can't open %s\n", *argv);

  argv++; argc--;

  read_data(*argv++); argc--;

  if (argc == 1 && (outwfp = fopen(*argv, "w")) == NULL)
	panic("%s:  can't create %s\n", *argv);
  else
	outwfp = stdout;

  get_and_print(inwfp, outwfp);
}





get_and_print(inwfp, outwfp)
FILE *inwfp, *outwfp;
{
  int layer, xcoord, ycoord, vx, vy;
  FLOAT *a, *b;

  a = (FLOAT *)calloc(S_SIZE, sizeof(FLOAT));
  b = (FLOAT *)calloc(SIZE, sizeof(FLOAT));
  if (a==NULL || b==NULL)
	panic("%s:  can't allocate\n");

  /* Count through all layers, and through all cells in each layer */
  for (layer=1; layer<LAYERS; layer++)
  {
    fprintf(outwfp, "Layer %d to %d:\n", layer-1, layer);
    for (xcoord=0; xcoord<SIZE; xcoord++)
    {
	for (ycoord=0; ycoord<SIZE; ycoord++)
	{
		fprintf(outwfp, "a[%d][%d]:\n", xcoord, ycoord);
		for (vx=0; vx<S_SIZE; vx++) {
			if (fread(a, sizeof(FLOAT), S_SIZE, inwfp) != S_SIZE)
				panic("\nIncorrect weight file\n");
			for (vy=0; vy<S_SIZE; vy++)
				fprintf(outwfp, "%f ", a[vy]);
		}
		fprintf(outwfp, "\n");
	}
	fprintf(outwfp, "b[%d]:\n", xcoord);
	if (fread(b, sizeof(FLOAT), SIZE, inwfp) != SIZE)
		panic("\nIncorrect weight file\n");
	for (ycoord=0; ycoord<SIZE; ycoord++)
		fprintf(outwfp, "%f ", b[ycoord]);
	fprintf(outwfp, "\n");
    }
  }

  fclose(inwfp); fclose(outwfp);
  free(a); free(b);
}



/* Function read_data() inputs a pattern from a cursor sized file created
 * by iconedit and uses this as an input to layer 0 of the cognitron
 */
read_data(name)
char *name;
{
  FILE *fp;

  /* Try to open the file */
  if ((fp = fopen(name, "r")) == NULL) {
	perror(name);
	exit(1);
  }

  if (fscanf(fp, "%d", &ITERATIONS) != 1)
	panic("%s:  can't read #iterations from %s\n", progname, name);
  if (fscanf(fp, "%d", &LAYERS) != 1)
	panic("%s:  can't read #layers from %s\n", progname, name);
  if (fscanf(fp, "%d", &SIZE) != 1)
	panic("%s:  can't read size from %s\n", progname, name);
  if (fscanf(fp, "%d", &S_SIZE) != 1)
	panic("%s:  can't read s_size from %s\n", progname, name);
  if (fscanf(fp, "%d", &O_SIZE) != 1)
	panic("%s:  can't read o_size from %s\n", progname, name);
  if (fscanf(fp, "%d", &H_SIZE) != 1)
	panic("%s:  can't read h_size from %s\n", progname, name);
  if (fscanf(fp, F_CAST, &Q0) != 1)
	panic("%s:  can't read q0 from %s\n", progname, name);
  if (fscanf(fp, F_CAST, &Q1) != 1)
	panic("%s:  can't read q1 from %s\n", progname, name);
  if (fscanf(fp, "%d", &PATTERNS) != 1)
	panic("%s:  can't read #patterns from %s\n", progname, name);

  fclose(fp);
}



#ifdef __MSDOS__

	char *basename(char *name)
	{
	  char *path, *p, *strrchr(const char *, int);

	  if ((path = strrchr(name,'\\')) == NULL) path = name;
	  else path += 1;

	  /* we don't want to include <string.h> just for tolower() function */
	  for (p=path; *p; p++) if (*p>='A' && *p<='Z') *p += 'a'-'A';

	  return path;
	}

#else

	char *basename(name)
	char *name;
	{
	  return name;
	}

#endif


#ifdef ANSI
#	include <stdarg.h>

	panic(char *fmt, ...)
	{
	  va_list arg_pointer;

#	ifdef __GRAPHX_DEF__
	  restorecrtmode();
#	endif

	  va_start(arg_pointer, fmt);
	  vfprintf(stderr, fmt, arg_pointer);
	  va_end(arg_pointer);
	  exit(1);
	}

#else
#	include <varargs.h>

	panic(va_alist)
	va_dcl
	{
	  va_list arg_pointer;
	  char *fmt;

	  va_start(arg_pointer);
	  fmt = va_arg(arg_pointer, char *);
	  vfprintf(stderr, fmt, arg_pointer);
	  va_end(arg_pointer);
	  exit(1);
	}
#endif
