#define EXTERN

#include "cog.h"

#ifdef __TURBOC__
#	include <alloc.h>
#endif

main(argc, argv)
int argc; char *argv[];
{
  int l,i;
  int x,y;
  int c, pat;
  char *basename(), *help, *infile;
  FILE *wfp;

  progname = basename(argv[0]); wfp = NULL;

  while (--argc > 0 && (*++argv)[0] == '-')
	while (c = *++argv[0]) switch(c) {
		case 'v': verbose = 1; break;
		case 'w':
			if (*((*argv)+1)) 
				help = (*argv)+1;
			else {
				if (--argc == 0)
					panic("Need weights file name\n");
				help = *(++argv);
			}
			if ((wfp = fopen(help, "rb")) == NULL)
				panic("%s:  can't open %s\n", progname, help);
			*((*argv)+1) = 0;
			break;
		default:  panic("%s:  illegal option -%c\n",progname,c);
	}

  if (argc < 1 || argc > 2)
	panic("Usage:  %s [-v] [-w <wgt-file>] <in-file> [<out-file>]\n",
								progname);

  read_data(infile = *argv++); argc--;

  if (argc == 1) {
	if ((runfp = fopen(infile = *argv, "w")) == NULL) {
		perror(*argv);
		exit(1);
	}
  } else
	runfp = stdout;

  zero(wfp);

  for (i=1; i<=ITERATIONS; i++)
  {
	fprintf(runfp, "Iteration %d\n", i);
	if (runfp != stdout) printf("\n\nIteration %d\nPattern",i);

	for (pat=0; pat<PATTERNS; pat++)
	{
		fprintf(runfp, "Pattern %d\n", pat);
		if (runfp != stdout) {
			printf(" %d", pat); fflush(stdout);
		}

		clamp(pat);

		for (l=1; l<LAYERS; l++)
		{
			forward(l);
			doweights(l);
		}

		show_layers(); putc('\n', runfp);
	}
  }

  fflush(runfp);

  if (ITERATIONS)
	print_weights(infile);
  else
  {
	fprintf(runfp, "\nFinal Values\n");
	if (!verbose && runfp != stdout) printf("\n\nFinal values:\n\t");
	for (pat=0; pat<PATTERNS; pat++)
	{
		DOUBLE max = 0.0, **pu;

		fprintf(runfp, "Pattern %d\nForward:\n", pat);
		if (!verbose && runfp != stdout) printf(" %d", pat);
		clamp(pat);

		for (l=1; l<LAYERS; l++)
			forward(l);
		show_layers();

		fprintf(runfp, "Backward:\n");
		if (!verbose && runfp != stdout) printf("-%d", pat);
		for (l=LAYERS-1; l>0; l--)
			reverse(l);
		show_layers();

		/* show feedback of maximum output */
		fprintf(runfp, "Backward of maximum output only:\n");
		if (!verbose && runfp != stdout) printf("-%d",pat);
		pu = u[LAYERS-1];
		for (x=0; x<SIZE; x++) for (y=0; y<SIZE; y++)
			if (pu[x][y] > max) max = pu[x][y];
		for (x=0; x<SIZE; x++) for (y=0; y<SIZE; y++)
			if (pu[x][y] < max) pu[x][y] = 0.0;
		for (l=LAYERS-1; l>0; l--)
			reverse(l);
		show_layers();

		putc('\n', runfp);
	}
  }
}





/* Function "zero" zeroes all modifiable weights and all cell values in
 * the cognitron
 */
zero(wfp)
FILE *wfp;
{
  /* Local variables
   *   layer: counts through layers
   *   xcoord: counts through x-dimension of each layer
   *   ycoord: counts through y-dimension of each layer
   *   vx: counts through x-dimension of a-weight plane
   *   vy: counts through y-dimension of a-weight plane
   */
  int layer, xcoord, ycoord, vx, vy;

  printf("Initialising...");
  if (wfp != NULL) printf("reading weights...");
  fflush(stdout);

  /* Count through all layers, and through all cells in each layer */
  for (layer=0; layer<LAYERS; layer++)
     for (xcoord=0; xcoord<SIZE; xcoord++)
     {
	for (ycoord=0; ycoord<SIZE; ycoord++)
	{
		/* Zero u, udash and v values, and b weights */
		u[layer][xcoord][ycoord] = 0;
		v[layer][xcoord][ycoord] = 0;
		udash[layer][xcoord][ycoord] = 0;

		/* Zero all weights in a-weight plane for each cell */
		if (wfp == NULL && layer > 0)
		{
			for (vx=0; vx<S_SIZE; vx++) for (vy=0; vy<S_SIZE; vy++)
				a[layer][xcoord][ycoord][vx][vy]=0;
			b[layer][xcoord][ycoord]=0;
		} else if (layer > 0) {
			for (vx=0; vx<S_SIZE; vx++)
				if (fread(a[layer][xcoord][ycoord][vx],
					sizeof(FLOAT), S_SIZE, wfp) != S_SIZE)
					panic("\nIncorrect weight file\n");
		}
	}
	if (wfp != NULL && layer > 0 &&
	fread(b[layer][xcoord], sizeof(FLOAT), SIZE, wfp) != SIZE)
			panic("\nIncorrect weight file\n");
     }

  /* Initialise the c weights to the v[] inhibitory neurons and the g weights
   * for lateral inhibition */
  c = 1/(FLOAT)(S_SIZE*S_SIZE);
  g = 1/(FLOAT)(H_SIZE*H_SIZE);

  if (wfp != NULL) fclose(wfp);

  printf("ready\n");
}



/* Function read_data() inputs a pattern from a cursor sized file created
 * by iconedit and uses this as an input to layer 0 of the cognitron
 */
read_data(name)
char *name;
{
  FILE *fp;
  char ***alloc3d(), *****alloc4d();
  int p, i, j, extra;

  /* Try to open the file */
  if ((fp = fopen(name, "r")) == NULL) {
	perror(name);
	exit(1);
  }

  if (fscanf(fp, "%d", &ITERATIONS) != 1)
	panic("%s:  can't read #iterations from %s\n", progname, name);
  if (fscanf(fp, "%d", &LAYERS) != 1)
	panic("%s:  can't read #layers from %s\n", progname, name);
  if (fscanf(fp, "%d", &SIZE) != 1)
	panic("%s:  can't read size from %s\n", progname, name);
  if (fscanf(fp, "%d", &S_SIZE) != 1)
	panic("%s:  can't read s_size from %s\n", progname, name);
  if (fscanf(fp, "%d", &O_SIZE) != 1)
	panic("%s:  can't read o_size from %s\n", progname, name);
  if (fscanf(fp, "%d", &H_SIZE) != 1)
	panic("%s:  can't read h_size from %s\n", progname, name);
  if (fscanf(fp, F_CAST, &Q0) != 1)
	panic("%s:  can't read q0 from %s\n", progname, name);
  if (fscanf(fp, F_CAST, &Q1) != 1)
	panic("%s:  can't read q1 from %s\n", progname, name);
  if (fscanf(fp, "%d", &PATTERNS) != 1)
	panic("%s:  can't read #patterns from %s\n", progname, name);

  extra = S_SIZE > O_SIZE ? S_SIZE : O_SIZE;
  if ((u = (DOUBLE ***) alloc3d(LAYERS, SIZE+extra, SIZE+extra, sizeof(DOUBLE))) == NULL)
	panic("%s:  out of memory allocating u[][][]\n", progname);

  for (i=0; i<LAYERS; i++) {
	for (j=0; j<SIZE+extra; j++)
		u[i][j] += (extra-1)/2;
	u[i] += (extra-1)/2;
  }

  if ((v = (DOUBLE ***) alloc3d(LAYERS, SIZE, SIZE, sizeof(DOUBLE))) == NULL)
	panic("%s:  out of memory allocating v[][][]\n", progname);

  extra = S_SIZE > H_SIZE ? S_SIZE : H_SIZE;
  if ((udash = (DOUBLE ***) alloc3d(LAYERS, SIZE+extra, SIZE+extra, sizeof(DOUBLE))) == NULL)
	panic("%s:  out of memory allocating udash[][][]\n", progname);

  for (i=0; i<LAYERS; i++) {
	for (j=0; j<SIZE+extra; j++)
		udash[i][j] += (extra-1)/2;
	udash[i] += (extra-1)/2;
  }

  if ((a = (FLOAT *****) calloc(LAYERS-1, sizeof(FLOAT ****))) == NULL)
	panic("%s:  out of memory allocating a[]\n", progname);
  a = a-1;
  for (i=1; i<LAYERS; i++) {
	if ((a[i] = (FLOAT ****) alloc4d(SIZE, SIZE, S_SIZE, S_SIZE,
						sizeof(FLOAT))) == NULL)
	panic("%s:  out of memory allocating a[%d][][][][]\n", progname, i);
  }

  if ((b = (FLOAT ***) alloc3d(LAYERS-1, SIZE, SIZE, sizeof(FLOAT))) == NULL)
	panic("%s:  out of memory allocating b[][][]\n", progname);
  b = b-1;

  if ((pattern = alloc3d(PATTERNS, SIZE, SIZE, sizeof(char))) == NULL)
	panic("%s:  out of memory allocating pattern array\n", progname);

  for (p=0; p<PATTERNS; p++)
  {
	int x, y, val;
	for (y=0; y<SIZE; y++) {
		/* Read in the integer */
		if (fscanf(fp, " 0x%x,", &val) != 1)
			panic("%s:  incorrect # inputs\n", progname);

		for (x=0; x<SIZE; x++)
		{
			pattern[p][SIZE-x-1][y] = val&1;
			val = val>>1;
		}
	}
  }

  /* Once finished, close the file */
  fclose(fp);
}



#ifdef __MSDOS__

	char *basename(char *name)
	{
	  char *path, *p, *strrchr(const char *, int);

	  if ((path = strrchr(name,'\\')) == NULL) path = name;
	  else path += 1;

	  /* we don't want to include <string.h> just for tolower() function */
	  for (p=path; *p; p++) if (*p>='A' && *p<='Z') *p += 'a'-'A';

	  return path;
	}

#else

	char *basename(name)
	char *name;
	{
	  return name;
	}

#endif


#ifdef ANSI
#	include <stdarg.h>

	panic(char *fmt, ...)
	{
	  va_list arg_pointer;

#	ifdef __GRAPHX_DEF__
	  restorecrtmode();
#	endif

	  va_start(arg_pointer, fmt);
	  vfprintf(stderr, fmt, arg_pointer);
	  va_end(arg_pointer);
	  exit(1);
	}

#else
#	include <varargs.h>

	panic(va_alist)
	va_dcl
	{
	  va_list arg_pointer;
	  char *fmt;

	  va_start(arg_pointer);
	  fmt = va_arg(arg_pointer, char *);
	  vfprintf(stderr, fmt, arg_pointer);
	  va_end(arg_pointer);
	  exit(1);
	}
#endif
