#include "cog.h"


address(xcoord, ycoord, size, wx, wy, wsize, abs_x, abs_y)
int xcoord, ycoord, size, wx, wy, wsize, *abs_x, *abs_y;
{
  int wrad;

  wrad = (wsize-1) / 2;

  *abs_x = xcoord + wx - wrad;
  *abs_y = ycoord + wy - wrad;

  if (*abs_x < 0 || *abs_y >= size || *abs_y <0 || *abs_y >= size)
	return 0;

  return 1;
}




/* Function phi()
 * the following function implements the non-linearity in a
 * cognitron cell i.e., 0 for x < 0 and x otherwise
 */
DOUBLE phi(x)
DOUBLE x;
{
  return x < 0  ?  0  :  x;
}



/* Function excite() returns the exitatory input to the cell in a
 * specific layer at the specified location.
 */
DOUBLE excite(layer, xcoord, ycoord)
int layer, xcoord, ycoord;
{
  DOUBLE sum, **pu;
  FLOAT **ppa;
  int vx, vy, x_u, y_u;

  ppa = a[layer][xcoord][ycoord];
  pu  = u[layer-1];

  /* Now add weighted excitatory inputs to this sum from each cell in
   * the connectable area of this cell (looping over vx and vy) */
  sum = 0.0;
  for (vx=0, x_u=xcoord-(S_SIZE-1)/2; vx<S_SIZE; vx++, x_u++) {
	FLOAT *pa;
	pa = *ppa++;

	for (vy=0, y_u=ycoord-(S_SIZE-1)/2; vy<S_SIZE; vy++, y_u++)
		sum += pu[x_u][y_u] * (DOUBLE) *pa++;
  }

  /* Return the calculated sum of weighted inputs */
  return sum;
}


/* Function inhibit() returns the inhibitory input to the cell in a
 * specific layer at the specified location.  It also sets up the value
 * of the inhibitory "v" cell.
 */
DOUBLE inhibit(layer, xcoord, ycoord)
int layer, xcoord, ycoord;
{
  DOUBLE inhib, **pu, dc;
  int vx, vy, x_u, y_u;

  /* Find a value for c
   * There are two methods I can see to do this
   * (1) to let c=1/(S_SIZE*S_SIZE)
   * (2) to account for effects near the edge of the plane and let c=1/area
   *     of input plane
   * I am using approach (1) for simplicity
   */
  /* c=1/(S_SIZE*S_SIZE)  is calculated in function zero() */

  pu = u[layer-1]; dc = (DOUBLE) c;

  /* Loop over connectable area, adding weighted inputs to sum so far.  vx and
   * vy are used to loop over this area
   */
  inhib = 0;
  for (vx=0, x_u=xcoord-(S_SIZE-1)/2; vx<S_SIZE; vx++, x_u++)
	for (vy=0, y_u=ycoord-(S_SIZE-1)/2; vy<S_SIZE; vy++, y_u++)
		inhib += pu[x_u][y_u] * dc;

  /* Assign this value to appropriate "v" cell */
  v[layer-1][xcoord][ycoord] = inhib;

  /* Return this value weighted by the b-weight */
  return inhib * (DOUBLE) b[layer][xcoord][ycoord];
}



/* Function lat_inhib() returns the sum of the laterally inhibiting inputs
 * to the cell specified.
 */
DOUBLE lat_inhib(layer, xcoord, ycoord)
int layer, xcoord, ycoord;
{
  DOUBLE inhib, **pudash, dg;
  int vx, vy, x_udash, y_udash;

  /* Calculate a value for g, the weight of laterally inhibiting inputs
   * Similar comments apply to this as apply to c in the function inhibit().
   * Again, the simpler approach is used
   */
  /* g = 1/(H_SIZE*H_SIZE)  is initialised in function zero() */

  pudash = udash[layer]; dg = (DOUBLE) g;

  /* Sum inhibitory values in inhib over area H */
  inhib = 0;
  for (vx=0, x_udash=xcoord-(H_SIZE-1)/2; vx<H_SIZE; vx++, x_udash++)
	for (vy=0, y_udash=ycoord-(H_SIZE-1)/2; vy<H_SIZE; vy++, y_udash++)
		inhib += pudash[x_udash][y_udash] * dg;

  /* Return the inhibitory input */
  return inhib;
}




/* Function forward() calculates the outputs of a layer.
 * This is done by first calculating the outputs before lateral inhibition
 * and then lateral inhibition is applied.
 *
 * This function uses the functions excite(), inhibit(), phi() and lat_inhib().
 */
void forward(layer)
int layer;
{
  int xcoord, ycoord;
  DOUBLE **ppudash, **ppu;

  /* First calculate outputs of cells before lateral inhibition using
   * U' = phi(   (1+excite) / (1+inhib)   -  1  )
   */
  ppudash = udash[layer];

  for (xcoord=0; xcoord<SIZE; xcoord++) {
	DOUBLE *pudash;

	pudash = *ppudash++;

	for (ycoord=0; ycoord<SIZE; ycoord++)
#if DEBUG
	{
		DOUBLE e, i, eps = 0.0000000001;
		e = excite(layer, xcoord, ycoord);
		i = inhibit(layer, xcoord, ycoord);
		*pudash = phi((1.0+e)/(1.0+i) - 1.0);
		printf("[%2d,%2d]: e=%2.7lf i=%2.7lf u'=%2.7lf\n",
			xcoord, ycoord, e+eps, i+eps, *pudash++ + eps);
	}
#else
		*pudash++ = phi( (1.0+excite(layer, xcoord, ycoord)) /
				(1.0+inhibit(layer, xcoord, ycoord))  - 1.0  );
#endif
  }

  /* Then perform lateral inhibition on these outputs */
  ppudash = udash[layer]; ppu = u[layer];

  for (xcoord=0; xcoord<SIZE; xcoord++) {
	DOUBLE *pu, *pudash;

	pu = *ppu++;
	pudash = *ppudash++;

	for (ycoord=0; ycoord<SIZE; ycoord++)
#if DEBUG
	{
		DOUBLE li, eps=0.0000000001;
		li = lat_inhib(layer, xcoord, ycoord);
		printf("lat_i[%d,%d] = %lf\n", xcoord, ycoord, li);
		*pu = phi((1.0+*pudash)/(1.0+li)-1.0);
		printf("[%d,%d]: u'=%2.7lf l_i=%2.7lf u=%2.7lf\n",
			xcoord, ycoord, *pudash++ + eps, l_i+eps, *pu++ + eps);
	}
#else
		*pu++ = phi(          (1.0 + *pudash++) /
				(1.0+lat_inhib(layer, xcoord, ycoord)) - 1.0 );
#endif
  }
}



/*
 * Reverse feeding activation values to the previous layer
 */
void reverse(layer)
{
  int xcoord, ycoord, layer_1;
  DOUBLE inhib, excite;

  layer_1 = layer-1;

  for (xcoord=0; xcoord<SIZE; xcoord++) for (ycoord=0; ycoord<SIZE; ycoord++)
	u[layer_1][xcoord][ycoord] = v[layer_1][xcoord][ycoord] = 0.0;

  for (xcoord=0; xcoord<SIZE; xcoord++) for (ycoord=0; ycoord<SIZE; ycoord++)
  {
	int vx, vy;
	DOUBLE uval;

	uval = u[layer][xcoord][ycoord];

	for (vx=0; vx<S_SIZE; vx++) for (vy=0; vy<S_SIZE; vy++)
	{
		int x, y;

		if (address(xcoord, ycoord, SIZE, vx, vy, S_SIZE, &x, &y) == 0)
			continue;
		u[layer_1][x][y] += a[layer][xcoord][ycoord][vx][vy] * uval;
	}
	v[layer_1][xcoord][ycoord] += b[layer][xcoord][ycoord] * uval;
  }
  for (xcoord=0; xcoord<SIZE; xcoord++) for (ycoord=0; ycoord<SIZE; ycoord++)
  {
	int vx, vy;
	DOUBLE inhib = 0.0;

	for (vx=0; vx<S_SIZE; vx++) for (vy=0; vy<S_SIZE; vy++)
	{
		int x, y;

		if (address(xcoord, ycoord, SIZE, vx, vy, S_SIZE, &x, &y) == 0)
			continue;
		inhib += c * v[layer_1][x][y];
	}
	u[layer_1][xcoord][ycoord] = phi( (1 + u[layer_1][xcoord][ycoord]) /
						(1 + inhib)		 - 1);
  }
}


/* Function delta() is 1 if no cells in the vicinity of this are firing
 * more strongly than this one, and 0 if there are some which are
 */
int delta(layer,xcoord,ycoord)
int layer, xcoord, ycoord;
{
  int vx, vy, x_u, y_u;
  DOUBLE u_val, **pu;

  pu = u[layer];
  u_val = pu[xcoord][ycoord];

  /* Now loop over vicinity area, and set strongest to 0 if any
   * cell in the area is firing stronger than this one */
  for (vx=0, x_u=xcoord-(O_SIZE-1)/2; vx<O_SIZE; vx++, x_u++)
	for (vy=0, y_u=ycoord-(O_SIZE-1)/2; vy<O_SIZE; vy++, y_u++)
		if (pu[x_u][y_u] > u_val)
			return 0;
  return 1;
}



/* Function delta_a() returns the value by which the weight a must be
 * increased
 */
FLOAT delta_a(layer, xcoord, ycoord, vx, vy)
int layer, xcoord, ycoord, vx, vy;
{
  int a = (S_SIZE-1)/2;
  return (FLOAT) (
		((u[layer][xcoord][ycoord]==0.0) ? Q0 : Q1) *
		c * u[layer-1][xcoord+vx-a][ycoord+vy-a]
	);
}




/* Function delta_b() returns the value by which the weight b must be
 * increased
 */
FLOAT delta_b(layer, xcoord, ycoord)
int layer, xcoord, ycoord;
{
  FLOAT change, sum;
  int vx, vy;

  /* There are two formulae depending on whether u[] is 0 or not */
  if (u[layer][xcoord][ycoord] == 0)
	/* Case for u[]=0 */
	return (FLOAT) (Q0*v[layer-1][xcoord][ycoord]);

  /* Case for u[]<>0 */

  /* sum c * u^2 over area S in last layer */
  sum = 0.0;
  for (vx=0; vx<S_SIZE; vx++) for (vy=0; vy<S_SIZE; vy++) {
	int a; FLOAT uval;
	a = (S_SIZE-1)/2;
	uval = u[layer-1][xcoord+vx-a][ycoord+vy-a];
	sum += c * uval * uval;
  }
  return (FLOAT) (Q1*sum / (2 * v[layer-1][xcoord][ycoord]));
}




/* Function "doweights" adjusts the modifiable a- and b-weights in a layer
 * 
 * This function uses the functions "delta", "delta_a" and "delta_b"
 */
void doweights(layer)
int layer;
{
  int xcoord, ycoord, vx, vy;

  /* for each cell in this layer */
  for (xcoord=0; xcoord<SIZE; xcoord++) for (ycoord=0; ycoord<SIZE; ycoord++)
	if (delta(layer,xcoord,ycoord))
        {
		/* Adjust each a-weight by delta-a */
		for (vx=0; vx<S_SIZE; vx++) {
			FLOAT *pa;
			pa = a[layer][xcoord][ycoord][vx];
			for (vy=0; vy<S_SIZE; vy++)
				*pa++ += delta_a(layer,xcoord,ycoord,vx,vy);
		}
		/* Adjust the b-weights by delta-b */
		b[layer][xcoord][ycoord] += delta_b(layer, xcoord, ycoord);

	}
}



clamp(p)
int p;
{
  register int x, y;

  for (y=0; y<SIZE; y++)
	for (x=0; x<SIZE; x++)
		u[0][x][y] = pattern[p][x][y];
}
