      real function uni(jd)

**begin prologue  uni

**date written   810915
c***revision date  810915
c***category no.  g4a23
c***keywords  random numbers, uniform random numbers
c***author    blue, james, scientific computing division, nbs
c             kahaner, david, scientific computing division, nbs
c             marsaglia, george, computer science dept., wash state univ
c
c***purpose  this routine generates quasi uniform random numbers on [0,1)
c             and can be used on any computer with at least 16 bit integers,
c             e.g., with a largest integer at least 32767.
c***description
c
c       this routine generates quasi uniform random numbers on the interval
c       [0,1).  it can be used with any computer with at least 16 bit
c       integers, e.g., with a largest integer at least equal to 32767.
c
c
c   use
c       first time....
c                   z = uni(jd)
c                     here jd is any  n o n - z e r o  integer.
c                     this causes initialization of the program
c                     and the first random number to be returned as z.
c       subsequent times...
c                   z = uni(0)
c                     causes the next random number to be returned as z.
c
c   machine dependencies...
c      mdig = a lower bound on the number of binary digits available
c              for representing integers.  this value is defaulted
c              internally to 16, but may be increased in line with
c              remark a below.
c
c   remarks...
c     a. this program can be used in two ways:
c        (1) to obtain repeatable results on different computers,
c            set 'mdig' to the smallest of its values on each, or,
c        (2) to allow the longest sequence of random numbers to be
c            generated without cycling (repeating) set 'mdig' to the
c            largest possible value.
c     b. the sequence of numbers generated depends on the initial
c          input 'jd' as well as the value of 'mdig'.
c          if mdig=16 (the default) one should find that
c            the first evaluation
c              z=uni(305) gives z=.027832881...
c            the second evaluation
c              z=uni(0) gives   z=.56102176...
c            the third evaluation
c              z=uni(0) gives   z=.41456343...
c            the thousandth evaluation
c              z=uni(0) gives   z=.19797357...
c
c***references  (none)
c***routines called  (none)
c***end prologue  uni
      integer m(17)
c
      save i,j,m,m1,m2
c
c  note... if a fortran 77 compiler is  n o t  available, the preceding
c          save statement should be removed.
c
comment      data mdig / 16 /
      data mdig / 32 /
      data m(1),m(2),m(3),m(4),m(5),m(6),m(7),m(8),m(9),m(10),m(11),
     1     m(12),m(13),m(14),m(15),m(16),m(17)
     2                   / 30788,23052,2053,19346,10646,19427,23975,
     3                     19049,10949,19693,29746,26748,2796,23890,
     4                     29168,31924,16499 /
      data m1,m2,i,j / 32767,256,5,17 /
c***first executable statement  uni
      if(jd .eq. 0) go to 3
c  fill
        m1 = 2**(mdig-2) + (2**(mdig-2)-1)
        m2 = 2**(mdig/2)
        jseed = min0(iabs(jd),m1)
        if( mod(jseed,2).eq.0 ) jseed=jseed-1
        k0 =mod(9069,m2)
        k1 = 9069/m2
        j0 = mod(jseed,m2)
        j1 = jseed/m2
        do 2 i=1,17
          jseed = j0*k0
          j1 = mod(jseed/m2+j0*k1+j1*k0,m2/2)
          j0 = mod(jseed,m2)
    2     m(i) = j0+m2*j1
        i=5
        j=17
c  begin main loop here
    3 k=m(i)-m(j)
      if(k .lt. 0) k=k+m1
      m(j)=k
      i=i-1
      if(i .eq. 0) i=17
      j=j-1
      if(j .eq. 0) j=17
      uni=float(k)/float(m1)
      return
      end
