# driver.r 14-Feb-92 15:38

# main 14-Feb-92 15:38

include sizcom.h

real w   (MAXWSIZE)					# combined w's; w1 then w2
real wsav(MAXWSIZE)					# combined w's; w1 then w2

real error			# latest error value
integer j			# index output layer
integer p			# index pattern number
integer r			# index run number
integer nruns		# number of runs 
integer nseed		# initializer for the PSRG

include errcom.h
include netcom.h
include outcom.h
include filcom.h
include parcom.h

character fnout*40    # various filenames (pathnames)
character fnrun*40
character fnpat*40
character fngetw*40
character fnputw*40
character pres*1, ch*1

fpspec	=  9
fppat	= 10
fpgetw	= 11
fpputw 	= 12
fpout	= 13
fprun	= 14
fpstd	=  6			# or whatever the "standard output" is

open(fpspec, file = 'spec', status = 'old')

# Read first line: number of runs 
read(fpspec, *) nruns
write(fpstd, 999) nruns

do r = 1, nruns
{
	# read file names, one per line
	read(fpspec, 998) fnout		# output results file name
	read(fpspec, 998) fnrun		# run output file name
	read(fpspec, 998) fnpat		# pattern input file name
	read(fpspec, 998) fngetw	# initial weights file name
	read(fpspec, 998) fnputw	# final weights output file name

	# read network parameters for the run
	read(fpspec, *)	 npats,			# number of input patterns
					 ninp,			# number of input nodes
					 nhid,			# number of hidden nodes
					 nout,			# number of output nodes
					 eta,			# learning rate
					 alpha,			# momentum factor
					 wfactor,		# coefficient of |w| in error
									# nseed is 0 if reading weights, else
					 nseed			# the random number seed

	if (npats > MAXPAT)
	{	print *, 'Have ', npats, ' patterns; limit is ', MAXPAT
		stop
	}
	if (ninp > MAXINS)
	{	print *, 'Have ', ninp, ' input nodes; limit is ', MAXINS
		stop
	}
	if (nhid > MAXHID)
	{	print *, 'Have ', nhid, ' hidden nodes; limit is ', MAXHID
		stop
	}
	if (nout > MAXOUT)
	{	print *, 'Have ', nout, ' output nodes; limit is ', MAXOUT
		stop
	}

	# read convergence parameters for the run
	read(fpspec, *)	 niter,			# number of iterations through the data
					 egoal, 		# goal for error (RMS)
					 gwgoal, 		# goal for g (RMS) / w (RMS)
					 nfreq,			# frequency for checking convergence
					 errdel,		# quit if error reduction too small
					 oklvl, 		# level for okay activation
					 nokdel			# quit if OK increase too small

	num1 = nhid*(ninp+1)
	num2 = nout*(nhid+1)
	numw = num1 + num2

	# open output file for the run
	open(fprun, file = fnrun, status = 'unknown')
	if (niter > 0) 
	{	write(fpstd    , 988) ' Training on ', fnpat
		write(fprun    , 988) ' Training on ', fnpat
	}
	else
	{	print *, ' '
		write(fpstd    , 988) ' Testing on ', fnpat
		write(fprun    , 988) ' Testing on ', fnpat
	}
	# get the inputs and target patterns to be learned
	open(fppat, file = fnpat, status = 'old')
	call getpat(fppat)
	close(fppat)

	write(fpstd, 989) ninp, nhid, nout, npats
	write(fprun, 989) ninp, nhid, nout, npats

	# get initial weights
	if (nseed <= 0)
	{	open(fpgetw, file = fngetw, status = 'old')
		write(fpstd, 987) fngetw
		write(fprun, 987) fngetw
		call setwts(fpgetw, w, w(num1+1), 0)
		close(fpgetw)
	}
	else
	{	write(fpstd, 986) nseed
		write(fprun, 986) nseed
		call setwts(0, w, w(num1+1), nseed)
	}
	write(fpstd, 984) wfactor
	write(fprun, 984) wfactor
	do n = 1, numw
		wsav(n) = w(n)

	if (niter > 0)
	{	write(fpstd, 982) egoal, gwgoal, errdel, nfreq, nfreq, nokdel, oklvl
		write(fprun, 982) egoal, gwgoal, errdel, nfreq, nfreq, nokdel, oklvl
	}
	time = cputim(0.0)
	ncalls = 0

	# Do the training or testing

	call optwts(niter, numw, w, error, gw, iter, ierr)
	
	if (niter > 0)
	{	call endopt(fprun, fpstd, iter, ncalls, ierr, error, gw)
		do n = 1, numw
			wsav(n) = wsav(n) - w(n)
		dif = snrm2(numw, wsav, 1) / sqrt(float(numw))
		write(fpstd, 985) dif
		write(fprun, 985) dif
		ch = 'r'
	}
	else
		ch = 's'
	
	call errhist(ch)

	time = cputim(time)
	write(fpstd, 991) time
	write(fprun, 991) time
	
	# print final weights 
	if (niter > 0)
	{	open(fpputw, file = fnputw, status = 'unknown')
		call putwts(fpputw, w, w(num1+1))
		close(fpputw)
		write(fpstd, 983) fnputw
		write(fprun, 983) fnputw
	}

	close(fprun)

	# Print final activation values
	open(fpout, file = fnout, status = 'unknown')
	write(fpout, 995) npats, ninp, nhid, nout, nseed, inint(1000*oklvl)
	do p = 1, npats
	{	if (idres(p) < 1 | idpat(p) < 1)
			pres = 'U'
		else if (idres(p) == idpat(p))
			pres = 'R'
		else 
			pres = 'W'
		write(fpout, 996) p, idpat(p), pres, idres(p),
			(nint(1000*vout(p, j)), j = 1, nout)
	}
	close(fpout)


}		# loop on nruns

close(fpspec)

stop
982 format( ' stopping criteria: ' / _
	'  (RMS err)  <= ', 1pe12.3, ' OR '  / _
	'  (RMS g)    <= ', 1pe12.3, ' * (RMS w) OR '  / _
	'  (RMS err)  >  ', 1pe12.3, ' * (RMS err ', i4, ' iterations ago) OR '  / _
	'  (OK count) <  (OK count ', i4, ' iterations ago) + ', i4,
		' (OK level is ', f5.3, ')')
983 format(' Weights written to file ', a40)
984 format(' Wfactor ', 1pe12.3)
985 format(' Rms change in weights', f6.3)
986 format(' Random initial weights, seed ', i10)
987 format(' Initial weights from file ', a41)
988 format(' '/a12, a41)
989 format(' Input, hidden, output nodes ', 3i4, '; ', i6, ' patterns')
991 format(/' Elapsed time ', f8.1, ' seconds')
995 format(6i8)
996 format(i6, ' = ', i2, 1x, a1, 1x, i2, 11i6 / (12i6))
998 format(a40)		# this format has to match the file name lengths
999 format(' Doing ', i3, ' run(s)')
end

# setwts 14-Feb-92 15:38
#		Set up the initial weights.
#		If fp >  0, read from there.
#		If fp <= 0, use pseudo-random weights in the range
#	(-SCALE, SCALE), first initializing the generator to nseed.

subroutine setwts(fp, w1, w2, nseed)
	integer fp
	real w1(nhid, ninp+1)
	real w2(nout, nhid+1)

include netcom.h

parameter(SCALE = 0.5)

integer h, i, j, minp, mhid, mout

if (fp > 0)
{	read(fp, *) minp, mhid, mout
	if (ninp != minp | nhid != mhid | nout != mout)
	{	if (ninp != minp)
			print *, ' Saved network has ', minp, ' inputs; using ', ninp
		if (nhid != mhid)
			print *, ' Saved network has ', mhid, ' hidden nodes; using ', nhid
		if (nout != mout)
			print *, ' Saved network has ', mout, ' outdput nodes; using ', nout
		stop
	}
	# read input:hidden weights
	do h = 1, nhid
		read(fp, *) (w1(h,i), i = 1, ninp+1)

	# read hidden:out weights
	do j = 1, nout
		read(fp, *) (w2(j,h), h = 1, nhid+1)
}
else
{	z = uni(nseed)		# initialize random numbers to given seed
	# set input:hidden weights
	do h = 1, nhid
		do i = 1, ninp+1
			w1(h,i) = 2.0 * SCALE *(uni(0) - 0.5)

	# set hidden:out weights
	do j = 1, nout
		do h = 1, nhid+1
			w2(j,h) = 2.0 * SCALE *(uni(0) - 0.5)
}
return
end

# getpat 14-Feb-92 15:38
#		Read the input, the target, and calculate the ID for each pattern

subroutine getpat(fppat)
	integer fppat

include sizcom.h
include outcom.h
include netcom.h

parameter (MAXCHR = 32)
# NOTE: must also change the 32 in outcom.h if this is changed.

integer i, j, p
character buff(81)*1

read(fppat, *) mpats, minp, mout
if (mpats < npats | ninp != minp | nout != mout)
{	if (npats > mpats)
		print *, ' File has ', mpats, ' patterns; using ', npats
	if (ninp != minp)
		print *, ' File has ', minp, ' inputs; using ', ninp
	if (nout != mout)
		print *, ' File has ', mout, ' outdput nodes; using ', nout
	stop
}

	# correspondence of character to output position
ib = 81
do j = 1, nout
	call getsub(fppat, buff, ib, MAXCHR, codes(j))

	# make short code translation strings
do j = 1, nout
{	len = MAXCHR
	do i = 1, MAXCHR
		if (codes(j)(i:i) == ' ')
		{	len = i - 1
			break
		}
	if (len > 3)
		break
	chtrans(j) = '   '
	k = 4 - len
	do i = 1, len
	{	chtrans(j)(k:k) = codes(j)(i:i)
		k = k + 1
	}
}
trans = (len > 3)
if (trans)
{	trans = .true.
	do j = 1, nout
		write(chtrans(j), 998) j
}

# assume pattern starts on new line, 
# target and identifier start on new line
do p = 1, npats
{	read(fppat, *) (vinp(p,i), i = 1, ninp)
		# the last weight of each hidden node is really its bias, 
		# so its input value is 1
	vinp(p,ninp+1) = 1.0
	read(fppat, *) (target(p,j), j = 1, nout)
		# assume the identifier is the only activation near 1
		# assign valid id in range 1, 2, ..., nout
		# or error id of -1 (no high activation)
		# or error id of -2 (more than one high activation)
	idpat(p) = -1
	do j = 1, nout
		if (target(p,j) >= 0.99)
		{	if (idpat(p) == -1)
				idpat(p) = j
			else
				idpat(p) = -2
		}
}
                                    
return
998 format(i3)
end

# getsub 14-Feb-92 15:38
#		Get next substring of length n or less.
#		Read from file fp. Unread characters are in buff(1:80).
#		Next char to read is position ib.
#
#		On exit, sub has substring. If less than n chars, it is
#		left-adjusted. Position ib is next char to be read.
subroutine getsub(fp, buff, ib, n, sub)
	integer fp
	character*1 buff(81)
	character*(*) sub

	# read new line if necessary; skip over blank characters
for ( ; ; )
{	if (ib > 80)
	{	read(fp, 999) (buff(i), i = 1, 80)
		buff(81) = ' '
		ib = 1
	}
	while (buff(ib) == ' ' & ib <= 80)
		ib = ib + 1
	if (buff(ib) != ' ')
		break
}
	# now buff(ib) is not blank and ib <= 80
init = ib
do i = 1, n
{	len = i
	ib = ib + 1
	if (buff(ib) == ' ' | ib > 80)
		break
}
	# in case the string is longer than n, skip past the rest
while (buff(ib) != ' ' & ib <= 80)
	ib = ib + 1

	# copy the non-blank chars
do i = 1, len
	sub(i:i) = buff(init + i - 1)
	# pad with blanks
do i = len+1, n
	sub(i:i) = ' '

return
999 format(80a1)
end

# func 14-Feb-92 15:38
#		Layer between optwts and forward
subroutine func(dograd, num, wt, err, gm)
	logical dograd
	real wt(*), err, gm(*)

include netcom.h
include parcom.h

call forward(dograd, wt, wt(num1+1), err, gm, gm(num1+1))

wsq = sdot(numw, wt, 1, wt, 1) / (2 * numw)
e1 = sqrt(2*err)
e2 = sqrt(2*wsq)

err = err + wfactor * wsq

wf = wfactor / numw
if (dograd)
	do n = 1, numw
		gm(n) = gm(n) - wf * wt(n) 

return
end


# forward 14-Feb-92 15:38
#		Calculate outputs and (optionally) negative gradient.

subroutine forward(dograd, w1, w2, error, gm1, gm2)
	logical dograd					# do negative grads?
	real w1	(nhid, ninp + 1)
	real w2	(nout, nhid + 1)
	real gm1(nhid, ninp + 1)
	real gm2(nout, nhid + 1)

include sizcom.h
include outcom.h
include netcom.h

real vhid	(MAXPAT, MAXHID+1)		# hidden layer
real delta2	(MAXPAT, MAXOUT)		# delta at output layer
real delta1	(MAXPAT, MAXHID)		# delta at hidden layer

real hderiv(MAXHID)
real oderiv(MAXOUT)
integer h, i, j, p

	# SMIN should be small enough so that exp(SMIN) is negligible,
	# but large enough so that exp(-SMIN) does not overflow.
parameter (SMIN = -40.0)	

ncalls = ncalls +1
error = 0.0

do p = 1, npats
{
	do h = 1, nhid
	{	## sum = 0
		##do i = 1, ninp+1
		##	sum = sum + w1(h,i) * vinp(p,i)
		sum = sdot(ninp+1, w1(h,1), nhid, vinp(p,1), MAXPAT)
		# assume exponential sigmoid function
		if (sum >= SMIN)
			vhid(p,h) = 1.0 / (1.0 + exp(-sum))
		else
			vhid(p,h) = 0.0
		hderiv(h) = vhid(p,h)*(1.0-vhid(p,h))
	}
	# the last weight of each output node is really its bias, 
	# so its input value is 1
	vhid(p,nhid+1) = 1.0
	#
	do j = 1, nout
	{	##sum = 0
		##do h = 1, nhid+1
		##	sum = sum + w2(j,h) * vhid(p,h)
		sum = sdot(nhid+1, w2(j,1), nout, vhid(p,1), MAXPAT)
		# assume exponential sigmoid function
		if (sum >= SMIN)
			vout(p,j) = 1.0 / (1.0 + exp(-sum))
		else
			vout(p,j) = 0.0
		oderiv(j) = vout(p,j)*(1.0-vout(p,j))

		error = error + (target(p,j) - vout(p,j)) ** 2
	}
	if (dograd)
	{
		# output deltas
		# assume exponential sigmoid function
		do j = 1, nout
			delta2(p,j) = (target(p,j) - vout(p,j)) * oderiv(j)
	
		# hidden deltas
		# assume exponential sigmoid function
		do h = 1, nhid
		{	##sum = 0.0
			##do j = 1, nout
			##	sum = sum + delta2(p,j) * w2(j,h)
			sum = sdot(nout, delta2(p,1), MAXPAT, w2(1,h), 1)
			delta1(p,h) = sum * hderiv(h)
		}
	}
}
# Average error per node over all patterns and nodes
div = (npats * nout)
error = error / (2 * div)

if (dograd)
{	# calculate negative gradient of error
		# with respect to input weights
	do h = 1, nhid
		do i = 1, ninp+1
			gm1(h,i) = sdot(npats, delta1(1,h), 1, vinp(1,i), 1) / div

		# with respect to output weights
	do j = 1, nout
		do h = 1, nhid+1
			gm2(j,h) = sdot(npats, delta2(1,j), 1, vhid(1,h), 1) / div
}
return
end

# putwts 14-Feb-92 15:38
#		Write the weights to file fp.
#		Weights for each node start on a new line.

subroutine putwts(fp, w1, w2)
	integer fp
	real w1(nhid, ninp+1)
	real w2(nout, nhid+1)

include netcom.h

integer h, i, j

write(fp, 998) ninp, nhid, nout

do h = 1, nhid
	write(fp, 999) (w1(h,i), i = 1, ninp+1)

do j = 1, nout
	write(fp, 999) (w2(j,h), h = 1, nhid+1)

return
998 format(3i5)
999 format(1x,1p5e14.6)
end

# isokay 14-Feb-92 15:38
#		Return true if decide that answer is believable
#		Big1 is highest output level, big2 is next highest
logical function isokay(big1, big2, out, nouts)
	real out(nouts)

include errcom.h

isokay = (big1 > oklvl) 

return
end

# confuse 14-Feb-92 15:38
#	Find number right, unknown, wrong.
#	Calculate idres array.
#	If flag is true, also find and print the confusion matrix and 
#	the matrix of the average output level.
#	Output goes to already-open files iout1 and iout2, 
#	if file numbers are non-negative
subroutine confuse(flag, iter, c, error, iout1, iout2, nright)
	logical flag
	character *1 c

include sizcom.h
include errcom.h
include outcom.h
include filcom.h
include netcom.h

integer ireslt(MAXOUT, MAXOUT)		# row: correct; column actual result
integer iunkn (MAXOUT)				# unknowns
									# average activation levels
real    outlvl(MAXOUT, MAXOUT)		# corresponding to ireslt matrix
real    outunk(MAXOUT)
real    out(MAXOUT)					# outputs for a given pattern
integer nerrs(11)
real    errs(11)
integer j, k, p
logical okay, isokay

nright = 0
nwrong = 0
nunkwn = 0
do j = 1, nout
	iunkn(j) = 0
do j = 1, 11
{	errs(j) = 2.0**(j-11)
	nerrs(j) = 0
}
if (flag)
{	do j = 1, nout
	{	outunk(j) = 0.0
		do k = 1, nout
		{	outlvl(j,k) = 0.0
			ireslt(j,k) = 0
		}
	}
}
sum1 = 0.0
sum2 = 0.0
do p = 1, npats
{	# find biggest two activation levels in case isokay() wants them.
	if (vout(p,1) >= vout(p,2))
		ibig1 = 1
	else
		ibig1 = 2
	ibig2 = 3 - ibig1
	big1 = vout(p, ibig1)
	big2 = vout(p, ibig2)
	do j = 3, nout
		if (vout(p,j) > big1)
		{	big2 = big1
			ibig2 = ibig1
			big1 = vout(p,j)
			ibig1 = j
		}
		else if (vout(p,j) > big2)
		{	big2 = vout(p,j)
			ibig2 = j
		}
	# copy activation levels in case isokay() wants them.
	do j = 1, nout
		out(j) = vout(p,j)
	okay = isokay(big1, big2, out, nout)

	iright = idpat(p)
	if (iright < 1)
		okay = .false.

	if (okay)
	{	idres(p) = ibig1
		if (flag)
		{	outlvl(iright, ibig1) = outlvl(iright, ibig1) + big1
			ireslt(iright, ibig1) = ireslt(iright, ibig1) + 1
		}
		if (iright == ibig1)
			nright = nright + 1
		else
			nwrong = nwrong + 1
	}
	else		# unknown
	{	nunkwn = nunkwn + 1
		if (iright >= 1)
		{	iunkn(iright) = iunkn(iright) + 1
			outunk(iright) = outunk(iright) + big1
		}
		idres(p) = -1
	}
	sum1 = sum1 + big1
	sum2 = sum2 + big2
	if (flag)
	{	do j = 1, nout
		{	e = abs(vout(p,j) - target(p,j))
			jj = 11
			do k = 1, 10
				if (e <= errs(k))
				{	jj = k
					break
				}
			nerrs(jj) = nerrs(jj) + 1
		}
	}

}

if (flag)
{	sum1 = sum1 / float(npats)
	sum2 = sum2 / float(npats)
	do j = 1, nout
	{	outunk(j) = outunk(j) * 100 / max(1, iunkn(j))
		do k = 1, nout
			outlvl(j,k) = outlvl(j,k) * 100 / max(1, ireslt(j,k))
	}
	total = nout * npats
	ifile = iout1
	do i = 1, 2
	{	if (ifile >= 0)
		{	write(ifile, 996) oklvl
			write(ifile, 990) sum1, sum2, sum1 - sum2
			if (trans)
			{	write(ifile, 985)
				do j = 1, nout
					write(ifile,  986) chtrans(j), codes(j)
			}
			write(ifile, 988) (chtrans(j), j = 1, nout)
			if (nwrong == 0)
			{	# if no errors, just print number in each category
				write(ifile, 987) (ireslt(k,k), k = 1, nout)
			}
			else
			{	# if errors, print the confusion matrix
				write(ifile, 992)
				do j = 1, nout
					write(ifile, 991) chtrans(j), (ireslt(j,k), k = 1, nout)
			}
			write(ifile, 994) 
			write(ifile, 987) (iunkn(j),j=1,nout)
			write(ifile, 993)
			write(ifile, 992)
			write(ifile, 988) (chtrans(j), j = 1, nout)
			do j = 1, nout
				write(ifile, 991) chtrans(j), (nint(outlvl(j,k)), k = 1, nout)
			write(ifile, 994)
			write(ifile, 987) (nint(outunk(k)), k = 1, nout)
			write(ifile, 989) (nerrs(j),j=1,11), 
								(float(100*nerrs(j))/total, j=1,11)
			write(ifile, 983) (float(100*hhist(j))/(nhid*npats), j=1,MAXHIST)
			write(ifile, 982)
		}
		ifile = iout2
	}
}

rmserr = sqrt(error * 2)
call sumout(iout1, iout2, iter, c, rmserr, nright, nwrong, npats)

return
982 format(' ')
983 format(10f7.1)
985 format('   key   code string')
986 format(3x, a3, 3x, a32)
987 format(' #    * ', 40i4)
988 format(' #  key:', 40a4)
989 format(/' Histogram of errors, from 2**(-10) to 1'/ _
			11i7/11f7.1,'%'/)
990 format(' # Highest two outputs (mean)', 2f7.3, ' ; mean diff', f7.3)
991 format(' # ', a4, ':', 40i4)
992 format(' #  row: correct, column: actual')
993 format(/' #  mean highest activation level')
994 format(' #  unknown' )
996 format(/' oklvl', f6.2)
end

# errhist 14-Feb-92 15:38
#	Vary some threshhold parameter to generate data for a graph of
#	percent correct vs. percent rejected.
subroutine errhist(ch)
	character *1 ch

include sizcom.h
include filcom.h
include netcom.h
include outcom.h

logical right(MAXPAT)
real    value(MAXPAT)

parameter (NUMPCT = 16)
integer prej(NUMPCT), j, p
data  prej / 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0, 
			15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0 /

do p = 1, npats
{	# find highest activation level
	ibig = 1
	big = vout(p, 1)
	sum = big
	do j = 2, nout
	{	sum = sum + vout(p,j)
		if (vout(p,j) > big)
		{	big = vout(p,j)
			ibig = j
		}
	}
	value(p) = big
	right(p) = (ibig == idpat(p))
}

call shsort(npats, value, right)

write(fprun, 999)
write(    *, 999)

do irej = 1, NUMPCT
{		# get approximate threshold
	if (irej == 1)
		thresh = min(0.0, value(1))
	else
	{	x = 1 + prej(irej) * npats / 100.0
		ix = anint(x)
		thresh = value(ix)
	}

	nright = 0
	nwrong = 0
	nunkwn = 0
		# count
	do p = 1, npats
	{	if (value(p) >= thresh)
		{	if (right(p)) nright = nright + 1
			else		  nwrong = nwrong + 1
		}
		else
			nunkwn = nunkwn + 1
	}
	correct  = 100 * float(nright) / float(nright + nwrong)
	reject   = 100 * float(nunkwn) / float(npats)
	write(fprun, 998) irej, ch, thresh, nright, nunkwn, nwrong, correct, reject
	write(    *, 998) irej, ch, thresh, nright, nunkwn, nwrong, correct, reject
}

return
998 format(i2, 't', a1, f12.6, 3i10, 2f10.2)
999 format(/8x, 'thresh       right   unknown     wrong   correct  rejected')
end

# sumout 14-Feb-92 15:38
#		Do some summary output to standard output and iout
#
subroutine sumout(iout1, iout2, iter, c, error, nright, nwrong, npats)
	character *1 c

include parcom.h

nquest = npats - (nright + nwrong)
fright = float(100*nright)/npats
fquest = float(100*nquest)/npats
fwrong = float(100*nwrong)/npats

if (iter >= 0) 
{	if (iout1 > 0) 
	{	if (iter == 0 | c == 'F')
			write(iout1, 999) ' Iter'
		write(iout1, 995) c, iter, error, e1, e2, nright, nquest, nwrong, 
								  fright, fquest, fwrong 
	}
	if (iout2 > 0) 
	{	if (iter == 0 | c == 'F')
			write(iout2, 999) ' Iter'
		write(iout2, 995) c, iter, error, e1, e2, nright, nquest, nwrong, 
								  fright, fquest, fwrong 
	}
}
else
{	if (iout1 > 0) 
	{	write(iout1, 999) '     '
		write(iout1, 994) error, e1, e2, nright, nquest, nwrong, 
							fright, fquest, fwrong 
	}
	if (iout2 > 0) 
	{	write(iout2, 999) '     '
		write(iout2, 994) error, e1, e2, nright, nquest, nwrong, 
							fright, fquest, fwrong 
	}
}
return
994 format('     Test', f6.3, ' (', f5.3, f6.3, ')', 3i5, ' = ', 3f6.1,'%')
995 format(2x,   a1,i6, f6.3, ' (', f5.3, f6.3, ')', 3i5, ' = ', 3f6.1,'%')
999 format(4x, a5, 2x, 'Err  (  Ep    Ew )   OK  UNK   NG      OK   UNK    NG')
end

# endopt 14-Feb-92 15:38
#		Do some output at the end of the optimization
#
subroutine endopt(fprun, fpstd, iter, ncalls, ierr, err, gw)
	integer fprun, fpstd

assign 900 to ifmt
if (ierr == 1) assign 901 to ifmt
if (ierr == 2) assign 902 to ifmt
if (ierr == 3) assign 903 to ifmt
if (ierr == 4) assign 904 to ifmt
write(fpstd, ifmt) iter, ierr
write(fprun, ifmt) iter, ierr

write(fpstd, 989) iter, ncalls, err, gw
write(fprun, 989) iter, ncalls, err, gw

return
900 format(' Iter', i6, '; ierr ', i1, ' : achieved error goal')
901 format(' Iter', i6, '; ierr ', i1, ' : iteration limit')
902 format(' Iter', i6, '; ierr ', i1, ' : gradient small')
903 format(' Iter', i6, '; ierr ', i1, ' : slow convergence of error')
904 format(' Iter', i6, '; ierr ', i1, ' : slow convergence of OK')

989 format(' Used', i6, ' iterations; ', i6, ' function calls; Err ', f6.3,
			'; |g|/|w| ', 1pe9.3)
end

# shsort 14-Feb-92 15:38
#		Sort v array and carry along r array
#		(Shell sort because of simplicity)
subroutine shsort(n, v, r)
	real v(n)
	logical r(n)

integer gap
logical ltemp
real temp

for (gap = n/2; gap > 0; gap = gap/2)
	do i = gap, n
		for (j = i-gap; j >= 1 & v(j) > v(j+gap); j = j-gap)
		{	temp = v(j)
			v(j) = v(j+gap)
			v(j+gap) = temp
			ltemp = r(j)
			r(j) = r(j+gap)
			r(j+gap) = ltemp
		}

return
end

## end of driver.r
