c driver.r 14-Feb-92 15:38
c main 14-Feb-92 15:38
c Standard parameters. NOTE: These must be the same everywhere.
c maximum allowed input patterns
      parameter (maxpat = 3500)
c maximum allowed input nodes
      parameter (maxins = 32)
c maximum allowed hidden nodes
      parameter (maxhid = 48)
c maximum allowed output nodes
      parameter (maxout = 26)
      parameter (maxwsize = maxhid*(maxins+1) + maxout*(maxhid+1))
      parameter(maxhist = 20)
c combined w's; w1 then w2
      real w (maxwsize)
c combined w's; w1 then w2
      real wsav(maxwsize)
c latest error value
      real error
c index output layer
      integer j
c index pattern number
      integer p
c index run number
      integer r
c number of runs 
      integer nruns
c initializer for the PSRG
      integer nseed
c common block with error checking and convergence parameters
      common / errcom / egoal, gwgoal, errdel, oklvl, nfreq, nokdel
c goal for RMS error
c      real egoal			
c goal for RMS g / RMS w
c      real gwgoal			
c Required reduction factor in RMS error every nfreq iterations
c      real errdel
c Activation level for accepting output as okay
c      real oklvl
c frequency for checking convergence, printing progress
c      integer nfreq		
c Required improvement in number OK every nfreq iterations
c      integer nokdel
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c common block with output items
      common /outcom/ vinp, vout, target, idpat, idres, codes, trans, 
     & chtrans
c input values
      real vinp(maxpat, maxins+1)
c output values
      real vout(maxpat, maxout)
c target output values
      real target(maxpat, maxout)
c identifier for each stored pattern (1, 2, 3, ..., nout)
      integer idpat(maxpat)
c result for each stored pattern (-1 means unknown)
      integer idres(maxpat)
c code string for identifier index ('A', '3v12', 'funny character', etc.)
      character*32 codes(maxout)
c character translation of identifier index ('A', '3v12', etc.)
      character*3 chtrans(maxout)
c Do we need to print a translation table?
      logical trans
c common block with file numbers
      common /filcom/ fpspec, fppat, fpgetw, fpputw, fpout, fprun, 
     & fpstd
c input:  file names and run parameters
      integer fpspec
c input:  input patterns
      integer fppat
c input:  initial weights
      integer fpgetw
c output: final weights
      integer fpputw
c output: activation levels
      integer fpout
c output: summary and error messages
      integer fprun
c output: standard output
      integer fpstd
c common block containing parameters
      common /parcom/ hscale, wfactor, hfactor, e1, e2
c various filenames (pathnames)
      character fnout*40
      character fnrun*40
      character fnpat*40
      character fngetw*40
      character fnputw*40
      character pres*1, ch*1
      fpspec= 9
      fppat= 10
      fpgetw= 11
      fpputw = 12
      fpout= 13
      fprun= 14
c or whatever the "standard output" is
      fpstd= 6
      open(fpspec, file = 'spec', status = 'old')
c Read first line: number of runs 
      read(fpspec, *) nruns
      write(fpstd, 999) nruns
      do 23000 r = 1, nruns
c read file names, one per line
c output results file name
         read(fpspec, 998) fnout
c run output file name
         read(fpspec, 998) fnrun
c pattern input file name
         read(fpspec, 998) fnpat
c initial weights file name
         read(fpspec, 998) fngetw
c final weights output file name
         read(fpspec, 998) fnputw
c read network parameters for the run
c number of input patterns
c number of input nodes
c number of hidden nodes
c number of output nodes
c learning rate
c momentum factor
c coefficient of |w| in error
c nseed is 0 if reading weights, else
c the random number seed
         read(fpspec, *)npats,ninp,nhid,nout,eta,alpha,wfactor,nseed
         if(.not.(npats  .gt.  maxpat))goto 23002
            print *, 'Have ', npats, ' patterns; limit is ', maxpat
            stop
23002    continue
         if(.not.(ninp  .gt.  maxins))goto 23004
            print *, 'Have ', ninp, ' input nodes; limit is ', maxins
            stop
23004    continue
         if(.not.(nhid  .gt.  maxhid))goto 23006
            print *, 'Have ', nhid, ' hidden nodes; limit is ', maxhid
            stop
23006    continue
         if(.not.(nout  .gt.  maxout))goto 23008
            print *, 'Have ', nout, ' output nodes; limit is ', maxout
            stop
c read convergence parameters for the run
23008    continue
c number of iterations through the data
c goal for error (RMS)
c goal for g (RMS) / w (RMS)
c frequency for checking convergence
c quit if error reduction too small
c level for okay activation
c quit if OK increase too small
         read(fpspec, *)niter,egoal,gwgoal,nfreq,errdel,oklvl,nokdel
         num1 = nhid*(ninp+1)
         num2 = nout*(nhid+1)
         numw = num1 + num2
c open output file for the run
         open(fprun, file = fnrun, status = 'unknown')
         if(.not.(niter  .gt.  0))goto 23010
            write(fpstd , 988) ' Training on ', fnpat
            write(fprun , 988) ' Training on ', fnpat
            goto 23011
c        else
23010       continue
            print *, ' '
            write(fpstd , 988) ' Testing on ', fnpat
            write(fprun , 988) ' Testing on ', fnpat
23011    continue
c get the inputs and target patterns to be learned
         open(fppat, file = fnpat, status = 'old')
         call getpat(fppat)
         close(fppat)
         write(fpstd, 989) ninp, nhid, nout, npats
         write(fprun, 989) ninp, nhid, nout, npats
c get initial weights
         if(.not.(nseed  .le.  0))goto 23012
            open(fpgetw, file = fngetw, status = 'old')
            write(fpstd, 987) fngetw
            write(fprun, 987) fngetw
            call setwts(fpgetw, w, w(num1+1), 0)
            close(fpgetw)
            goto 23013
c        else
23012       continue
            write(fpstd, 986) nseed
            write(fprun, 986) nseed
            call setwts(0, w, w(num1+1), nseed)
23013    continue
         write(fpstd, 984) wfactor
         write(fprun, 984) wfactor
         do 23014 n = 1, numw
            wsav(n) = w(n)
23014       continue
         if(.not.(niter  .gt.  0))goto 23016
            write(fpstd, 982) egoal, gwgoal, errdel, nfreq, nfreq, 
     &       nokdel, oklvl
            write(fprun, 982) egoal, gwgoal, errdel, nfreq, nfreq, 
     &       nokdel, oklvl
23016    continue
         time = cputim(0.0)
         ncalls = 0
c Do the training or testing
         call optwts(niter, numw, w, error, gw, iter, ierr)
         if(.not.(niter  .gt.  0))goto 23018
            call endopt(fprun, fpstd, iter, ncalls, ierr, error, gw)
            do 23020 n = 1, numw
               wsav(n) = wsav(n) - w(n)
23020          continue
            dif = snrm2(numw, wsav, 1) / sqrt(float(numw))
            write(fpstd, 985) dif
            write(fprun, 985) dif
            ch = 'r'
            goto 23019
c        else
23018       continue
            ch = 's'
23019    continue
         call errhist(ch)
         time = cputim(time)
         write(fpstd, 991) time
         write(fprun, 991) time
c print final weights 
         if(.not.(niter  .gt.  0))goto 23022
            open(fpputw, file = fnputw, status = 'unknown')
            call putwts(fpputw, w, w(num1+1))
            close(fpputw)
            write(fpstd, 983) fnputw
            write(fprun, 983) fnputw
23022    continue
         close(fprun)
c Print final activation values
         open(fpout, file = fnout, status = 'unknown')
         write(fpout, 995) npats, ninp, nhid, nout, nseed, inint(1000*
     &    oklvl)
         do 23024 p = 1, npats
            if(.not.(idres(p)  .lt.  1  .or.  idpat(p)  .lt.  1))goto 23
     &       026
               pres = 'U'
               goto 23027
c           else
23026          continue
               if(.not.(idres(p)  .eq.  idpat(p)))goto 23028
                  pres = 'R'
                  goto 23029
c              else
23028             continue
                  pres = 'W'
23029          continue
23027       continue
            write(fpout, 996) p, idpat(p), pres, idres(p),(nint(1000*
     &       vout(p, j)), j = 1, nout)
23024       continue
         close(fpout)
23000    continue
c loop on nruns
      close(fpspec)
      stop
982   format( ' stopping criteria: ' /'  (RMS err)  <= ', 1pe12.3, 
     & ' OR ' /'  (RMS g)    <= ', 1pe12.3, ' * (RMS w) OR ' /
     & '  (RMS err)  >  ', 1pe12.3, ' * (RMS err ', i4, 
     & ' iterations ago) OR ' /'  (OK count) <  (OK count ', i4, 
     & ' iterations ago) + ', i4,' (OK level is ', f5.3, ')')
983   format(' Weights written to file ', a40)
984   format(' Wfactor ', 1pe12.3)
985   format(' Rms change in weights', f6.3)
986   format(' Random initial weights, seed ', i10)
987   format(' Initial weights from file ', a41)
988   format(' '/a12, a41)
989   format(' Input, hidden, output nodes ', 3i4, '; ', i6, 
     & ' patterns')
991   format(/' Elapsed time ', f8.1, ' seconds')
995   format(6i8)
996   format(i6, ' = ', i2, 1x, a1, 1x, i2, 11i6 / (12i6))
c this format has to match the file name lengths
998   format(a40)
999   format(' Doing ', i3, ' run(s)')
      end
c setwts 14-Feb-92 15:38
c		Set up the initial weights.
c		If fp >  0, read from there.
c		If fp <= 0, use pseudo-random weights in the range
c	(-SCALE, SCALE), first initializing the generator to nseed.
      subroutine setwts(fp, w1, w2, nseed)
      integer fp
      real w1(nhid, ninp+1)
      real w2(nout, nhid+1)
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
      parameter(scale = 0.5)
      integer h, i, j, minp, mhid, mout
      if(.not.(fp  .gt.  0))goto 23030
         read(fp, *) minp, mhid, mout
         if(.not.(ninp  .ne.  minp  .or.  nhid  .ne.  mhid  .or.  nout 
     &     .ne.  mout))goto 23032
            if(.not.(ninp  .ne.  minp))goto 23034
               print *, ' Saved network has ', minp, ' inputs; using ', 
     &          ninp
23034       continue
            if(.not.(nhid  .ne.  mhid))goto 23036
               print *, ' Saved network has ', mhid, 
     &          ' hidden nodes; using ', nhid
23036       continue
            if(.not.(nout  .ne.  mout))goto 23038
               print *, ' Saved network has ', mout, 
     &          ' outdput nodes; using ', nout
23038       continue
            stop
c read input:hidden weights
23032    continue
         do 23040 h = 1, nhid
            read(fp, *) (w1(h,i), i = 1, ninp+1)
23040       continue
c read hidden:out weights
         do 23042 j = 1, nout
            read(fp, *) (w2(j,h), h = 1, nhid+1)
23042       continue
         goto 23031
c     else
23030    continue
c initialize random numbers to given seed
         z = uni(nseed)
c set input:hidden weights
         do 23044 h = 1, nhid
            do 23046 i = 1, ninp+1
               w1(h,i) = 2.0 * scale *(uni(0) - 0.5)
23046          continue
23044       continue
c set hidden:out weights
         do 23048 j = 1, nout
            do 23050 h = 1, nhid+1
               w2(j,h) = 2.0 * scale *(uni(0) - 0.5)
23050          continue
23048       continue
23031 continue
      return
      end
c getpat 14-Feb-92 15:38
c		Read the input, the target, and calculate the ID for each pattern
      subroutine getpat(fppat)
      integer fppat
c Standard parameters. NOTE: These must be the same everywhere.
c maximum allowed input patterns
      parameter (maxpat = 3500)
c maximum allowed input nodes
      parameter (maxins = 32)
c maximum allowed hidden nodes
      parameter (maxhid = 48)
c maximum allowed output nodes
      parameter (maxout = 26)
      parameter (maxwsize = maxhid*(maxins+1) + maxout*(maxhid+1))
      parameter(maxhist = 20)
c common block with output items
      common /outcom/ vinp, vout, target, idpat, idres, codes, trans, 
     & chtrans
c input values
      real vinp(maxpat, maxins+1)
c output values
      real vout(maxpat, maxout)
c target output values
      real target(maxpat, maxout)
c identifier for each stored pattern (1, 2, 3, ..., nout)
      integer idpat(maxpat)
c result for each stored pattern (-1 means unknown)
      integer idres(maxpat)
c code string for identifier index ('A', '3v12', 'funny character', etc.)
      character*32 codes(maxout)
c character translation of identifier index ('A', '3v12', etc.)
      character*3 chtrans(maxout)
c Do we need to print a translation table?
      logical trans
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
      parameter (maxchr = 32)
c NOTE: must also change the 32 in outcom.h if this is changed.
      integer i, j, p
      character buff(81)*1
      read(fppat, *) mpats, minp, mout
      if(.not.(mpats  .lt.  npats  .or.  ninp  .ne.  minp  .or.  nout 
     &  .ne.  mout))goto 23052
         if(.not.(npats  .gt.  mpats))goto 23054
            print *, ' File has ', mpats, ' patterns; using ', npats
23054    continue
         if(.not.(ninp  .ne.  minp))goto 23056
            print *, ' File has ', minp, ' inputs; using ', ninp
23056    continue
         if(.not.(nout  .ne.  mout))goto 23058
            print *, ' File has ', mout, ' outdput nodes; using ', nout
23058    continue
         stop
c correspondence of character to output position
23052 continue
      ib = 81
      do 23060 j = 1, nout
         call getsub(fppat, buff, ib, maxchr, codes(j))
23060    continue
c make short code translation strings
      do 23062 j = 1, nout
         len = maxchr
         do 23064 i = 1, maxchr
            if(.not.(codes(j)(i:i)  .eq.  ' '))goto 23066
               len = i - 1
               goto 23065
23066       continue
23064       continue
23065    continue
         if(.not.(len  .gt.  3))goto 23068
            goto 23063
23068    continue
         chtrans(j) = '   '
         k = 4 - len
         do 23070 i = 1, len
            chtrans(j)(k:k) = codes(j)(i:i)
            k = k + 1
23070       continue
23062    continue
23063 continue
      trans = (len  .gt.  3)
      if(.not.(trans))goto 23072
         trans = .true.
         do 23074 j = 1, nout
            write(chtrans(j), 998) j
23074       continue
c assume pattern starts on new line, 
c target and identifier start on new line
23072 continue
      do 23076 p = 1, npats
         read(fppat, *) (vinp(p,i), i = 1, ninp)
c the last weight of each hidden node is really its bias, 
c so its input value is 1
         vinp(p,ninp+1) = 1.0
         read(fppat, *) (target(p,j), j = 1, nout)
c assume the identifier is the only activation near 1
c assign valid id in range 1, 2, ..., nout
c or error id of -1 (no high activation)
c or error id of -2 (more than one high activation)
         idpat(p) = -1
         do 23078 j = 1, nout
            if(.not.(target(p,j)  .ge.  0.99))goto 23080
               if(.not.(idpat(p)  .eq.  -1))goto 23082
                  idpat(p) = j
                  goto 23083
c              else
23082             continue
                  idpat(p) = -2
23083          continue
23080       continue
23078       continue
23076    continue
      return
998   format(i3)
      end
c getsub 14-Feb-92 15:38
c		Get next substring of length n or less.
c		Read from file fp. Unread characters are in buff(1:80).
c		Next char to read is position ib.
c
c		On exit, sub has substring. If less than n chars, it is
c		left-adjusted. Position ib is next char to be read.
      subroutine getsub(fp, buff, ib, n, sub)
      integer fp
      character*1 buff(81)
      character*(*) sub
c read new line if necessary; skip over blank characters
c     for
23084 continue
         if(.not.(ib  .gt.  80))goto 23087
            read(fp, 999) (buff(i), i = 1, 80)
            buff(81) = ' '
            ib = 1
23087    continue
c        while
23089    if(.not.(buff(ib)  .eq.  ' '  .and.  ib  .le.  80))goto 23090
            ib = ib + 1
            goto 23089
c        endwhile
23090    continue
         if(.not.(buff(ib)  .ne.  ' '))goto 23091
            goto 23086
23091    continue
         goto 23084
c     endfor
23086 continue
c now buff(ib) is not blank and ib <= 80
      init = ib
      do 23093 i = 1, n
         len = i
         ib = ib + 1
         if(.not.(buff(ib)  .eq.  ' '  .or.  ib  .gt.  80))goto 23095
            goto 23094
23095    continue
23093    continue
23094 continue
c in case the string is longer than n, skip past the rest
c     while
23097 if(.not.(buff(ib)  .ne.  ' '  .and.  ib  .le.  80))goto 23098
         ib = ib + 1
         goto 23097
c     endwhile
23098 continue
c copy the non-blank chars
      do 23099 i = 1, len
         sub(i:i) = buff(init + i - 1)
23099    continue
c pad with blanks
      do 23101 i = len+1, n
         sub(i:i) = ' '
23101    continue
      return
999   format(80a1)
      end
c func 14-Feb-92 15:38
c		Layer between optwts and forward
      subroutine func(dograd, num, wt, err, gm)
      logical dograd
      real wt(*), err, gm(*)
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c common block containing parameters
      common /parcom/ hscale, wfactor, hfactor, e1, e2
      call forward(dograd, wt, wt(num1+1), err, gm, gm(num1+1))
      wsq = sdot(numw, wt, 1, wt, 1) / (2 * numw)
      e1 = sqrt(2*err)
      e2 = sqrt(2*wsq)
      err = err + wfactor * wsq
      wf = wfactor / numw
      if(.not.(dograd))goto 23103
         do 23105 n = 1, numw
            gm(n) = gm(n) - wf * wt(n)
23105       continue
23103 continue
      return
      end
c forward 14-Feb-92 15:38
c		Calculate outputs and (optionally) negative gradient.
      subroutine forward(dograd, w1, w2, error, gm1, gm2)
c do negative grads?
      logical dograd
      real w1(nhid, ninp + 1)
      real w2(nout, nhid + 1)
      real gm1(nhid, ninp + 1)
      real gm2(nout, nhid + 1)
c Standard parameters. NOTE: These must be the same everywhere.
c maximum allowed input patterns
      parameter (maxpat = 3500)
c maximum allowed input nodes
      parameter (maxins = 32)
c maximum allowed hidden nodes
      parameter (maxhid = 48)
c maximum allowed output nodes
      parameter (maxout = 26)
      parameter (maxwsize = maxhid*(maxins+1) + maxout*(maxhid+1))
      parameter(maxhist = 20)
c common block with output items
      common /outcom/ vinp, vout, target, idpat, idres, codes, trans, 
     & chtrans
c input values
      real vinp(maxpat, maxins+1)
c output values
      real vout(maxpat, maxout)
c target output values
      real target(maxpat, maxout)
c identifier for each stored pattern (1, 2, 3, ..., nout)
      integer idpat(maxpat)
c result for each stored pattern (-1 means unknown)
      integer idres(maxpat)
c code string for identifier index ('A', '3v12', 'funny character', etc.)
      character*32 codes(maxout)
c character translation of identifier index ('A', '3v12', etc.)
      character*3 chtrans(maxout)
c Do we need to print a translation table?
      logical trans
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c hidden layer
      real vhid(maxpat, maxhid+1)
c delta at output layer
      real delta2(maxpat, maxout)
c delta at hidden layer
      real delta1(maxpat, maxhid)
      real hderiv(maxhid)
      real oderiv(maxout)
      integer h, i, j, p
c SMIN should be small enough so that exp(SMIN) is negligible,
c but large enough so that exp(-SMIN) does not overflow.
      parameter (smin = -40.0)
      ncalls = ncalls +1
      error = 0.0
      do 23107 p = 1, npats
         do 23109 h = 1, nhid
c# sum = 0
c#do i = 1, ninp+1
c#	sum = sum + w1(h,i) * vinp(p,i)
            sum = sdot(ninp+1, w1(h,1), nhid, vinp(p,1), maxpat)
c assume exponential sigmoid function
            if(.not.(sum  .ge.  smin))goto 23111
               vhid(p,h) = 1.0 / (1.0 + exp(-sum))
               goto 23112
c           else
23111          continue
               vhid(p,h) = 0.0
23112       continue
            hderiv(h) = vhid(p,h)*(1.0-vhid(p,h))
23109       continue
c the last weight of each output node is really its bias, 
c so its input value is 1
         vhid(p,nhid+1) = 1.0
c
         do 23113 j = 1, nout
c#sum = 0
c#do h = 1, nhid+1
c#	sum = sum + w2(j,h) * vhid(p,h)
            sum = sdot(nhid+1, w2(j,1), nout, vhid(p,1), maxpat)
c assume exponential sigmoid function
            if(.not.(sum  .ge.  smin))goto 23115
               vout(p,j) = 1.0 / (1.0 + exp(-sum))
               goto 23116
c           else
23115          continue
               vout(p,j) = 0.0
23116       continue
            oderiv(j) = vout(p,j)*(1.0-vout(p,j))
            error = error + (target(p,j) - vout(p,j)) ** 2
23113       continue
         if(.not.(dograd))goto 23117
c output deltas
c assume exponential sigmoid function
            do 23119 j = 1, nout
               delta2(p,j) = (target(p,j) - vout(p,j)) * oderiv(j)
23119          continue
c hidden deltas
c assume exponential sigmoid function
            do 23121 h = 1, nhid
c#sum = 0.0
c#do j = 1, nout
c#	sum = sum + delta2(p,j) * w2(j,h)
               sum = sdot(nout, delta2(p,1), maxpat, w2(1,h), 1)
               delta1(p,h) = sum * hderiv(h)
23121          continue
23117    continue
23107    continue
c Average error per node over all patterns and nodes
      div = (npats * nout)
      error = error / (2 * div)
      if(.not.(dograd))goto 23123
c calculate negative gradient of error
c with respect to input weights
         do 23125 h = 1, nhid
            do 23127 i = 1, ninp+1
               gm1(h,i) = sdot(npats, delta1(1,h), 1, vinp(1,i), 1) / 
     &          div
23127          continue
23125       continue
c with respect to output weights
         do 23129 j = 1, nout
            do 23131 h = 1, nhid+1
               gm2(j,h) = sdot(npats, delta2(1,j), 1, vhid(1,h), 1) / 
     &          div
23131          continue
23129       continue
23123 continue
      return
      end
c putwts 14-Feb-92 15:38
c		Write the weights to file fp.
c		Weights for each node start on a new line.
      subroutine putwts(fp, w1, w2)
      integer fp
      real w1(nhid, ninp+1)
      real w2(nout, nhid+1)
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
      integer h, i, j
      write(fp, 998) ninp, nhid, nout
      do 23133 h = 1, nhid
         write(fp, 999) (w1(h,i), i = 1, ninp+1)
23133    continue
      do 23135 j = 1, nout
         write(fp, 999) (w2(j,h), h = 1, nhid+1)
23135    continue
      return
998   format(3i5)
999   format(1x,1p5e14.6)
      end
c isokay 14-Feb-92 15:38
c		Return true if decide that answer is believable
c		Big1 is highest output level, big2 is next highest
      logical function isokay(big1, big2, out, nouts)
      real out(nouts)
c common block with error checking and convergence parameters
      common / errcom / egoal, gwgoal, errdel, oklvl, nfreq, nokdel
c goal for RMS error
c      real egoal			
c goal for RMS g / RMS w
c      real gwgoal			
c Required reduction factor in RMS error every nfreq iterations
c      real errdel
c Activation level for accepting output as okay
c      real oklvl
c frequency for checking convergence, printing progress
c      integer nfreq		
c Required improvement in number OK every nfreq iterations
c      integer nokdel
      isokay = (big1  .gt.  oklvl)
      return
      end
c confuse 14-Feb-92 15:38
c	Find number right, unknown, wrong.
c	Calculate idres array.
c	If flag is true, also find and print the confusion matrix and 
c	the matrix of the average output level.
c	Output goes to already-open files iout1 and iout2, 
c	if file numbers are non-negative
      subroutine confuse(flag, iter, c, error, iout1, iout2, nright)
      logical flag
      character *1 c
c Standard parameters. NOTE: These must be the same everywhere.
c maximum allowed input patterns
      parameter (maxpat = 3500)
c maximum allowed input nodes
      parameter (maxins = 32)
c maximum allowed hidden nodes
      parameter (maxhid = 48)
c maximum allowed output nodes
      parameter (maxout = 26)
      parameter (maxwsize = maxhid*(maxins+1) + maxout*(maxhid+1))
      parameter(maxhist = 20)
c common block with error checking and convergence parameters
      common / errcom / egoal, gwgoal, errdel, oklvl, nfreq, nokdel
c goal for RMS error
c      real egoal			
c goal for RMS g / RMS w
c      real gwgoal			
c Required reduction factor in RMS error every nfreq iterations
c      real errdel
c Activation level for accepting output as okay
c      real oklvl
c frequency for checking convergence, printing progress
c      integer nfreq		
c Required improvement in number OK every nfreq iterations
c      integer nokdel
c common block with output items
      common /outcom/ vinp, vout, target, idpat, idres, codes, trans, 
     & chtrans
c input values
      real vinp(maxpat, maxins+1)
c output values
      real vout(maxpat, maxout)
c target output values
      real target(maxpat, maxout)
c identifier for each stored pattern (1, 2, 3, ..., nout)
      integer idpat(maxpat)
c result for each stored pattern (-1 means unknown)
      integer idres(maxpat)
c code string for identifier index ('A', '3v12', 'funny character', etc.)
      character*32 codes(maxout)
c character translation of identifier index ('A', '3v12', etc.)
      character*3 chtrans(maxout)
c Do we need to print a translation table?
      logical trans
c common block with file numbers
      common /filcom/ fpspec, fppat, fpgetw, fpputw, fpout, fprun, 
     & fpstd
c input:  file names and run parameters
      integer fpspec
c input:  input patterns
      integer fppat
c input:  initial weights
      integer fpgetw
c output: final weights
      integer fpputw
c output: activation levels
      integer fpout
c output: summary and error messages
      integer fprun
c output: standard output
      integer fpstd
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c row: correct; column actual result
      integer ireslt(maxout, maxout)
c unknowns
      integer iunkn (maxout)
c average activation levels
c corresponding to ireslt matrix
      real outlvl(maxout, maxout)
      real outunk(maxout)
c outputs for a given pattern
      real out(maxout)
      integer nerrs(11)
      real errs(11)
      integer j, k, p
      logical okay, isokay
      nright = 0
      nwrong = 0
      nunkwn = 0
      do 23137 j = 1, nout
         iunkn(j) = 0
23137    continue
      do 23139 j = 1, 11
         errs(j) = 2.0**(j-11)
         nerrs(j) = 0
23139    continue
      if(.not.(flag))goto 23141
         do 23143 j = 1, nout
            outunk(j) = 0.0
            do 23145 k = 1, nout
               outlvl(j,k) = 0.0
               ireslt(j,k) = 0
23145          continue
23143       continue
23141 continue
      sum1 = 0.0
      sum2 = 0.0
      do 23147 p = 1, npats
c find biggest two activation levels in case isokay() wants them.
         if(.not.(vout(p,1)  .ge.  vout(p,2)))goto 23149
            ibig1 = 1
            goto 23150
c        else
23149       continue
            ibig1 = 2
23150    continue
         ibig2 = 3 - ibig1
         big1 = vout(p, ibig1)
         big2 = vout(p, ibig2)
         do 23151 j = 3, nout
            if(.not.(vout(p,j)  .gt.  big1))goto 23153
               big2 = big1
               ibig2 = ibig1
               big1 = vout(p,j)
               ibig1 = j
               goto 23154
c           else
23153          continue
               if(.not.(vout(p,j)  .gt.  big2))goto 23155
                  big2 = vout(p,j)
                  ibig2 = j
c copy activation levels in case isokay() wants them.
23155          continue
23154       continue
23151       continue
         do 23157 j = 1, nout
            out(j) = vout(p,j)
23157       continue
         okay = isokay(big1, big2, out, nout)
         iright = idpat(p)
         if(.not.(iright  .lt.  1))goto 23159
            okay = .false.
23159    continue
         if(.not.(okay))goto 23161
            idres(p) = ibig1
            if(.not.(flag))goto 23163
               outlvl(iright, ibig1) = outlvl(iright, ibig1) + big1
               ireslt(iright, ibig1) = ireslt(iright, ibig1) + 1
23163       continue
            if(.not.(iright  .eq.  ibig1))goto 23165
               nright = nright + 1
               goto 23166
c           else
23165          continue
               nwrong = nwrong + 1
23166       continue
            goto 23162
c        else
23161       continue
c unknown
            nunkwn = nunkwn + 1
            if(.not.(iright  .ge.  1))goto 23167
               iunkn(iright) = iunkn(iright) + 1
               outunk(iright) = outunk(iright) + big1
23167       continue
            idres(p) = -1
23162    continue
         sum1 = sum1 + big1
         sum2 = sum2 + big2
         if(.not.(flag))goto 23169
            do 23171 j = 1, nout
               e = abs(vout(p,j) - target(p,j))
               jj = 11
               do 23173 k = 1, 10
                  if(.not.(e  .le.  errs(k)))goto 23175
                     jj = k
                     goto 23174
23175             continue
23173             continue
23174          continue
               nerrs(jj) = nerrs(jj) + 1
23171          continue
23169    continue
23147    continue
      if(.not.(flag))goto 23177
         sum1 = sum1 / float(npats)
         sum2 = sum2 / float(npats)
         do 23179 j = 1, nout
            outunk(j) = outunk(j) * 100 / max(1, iunkn(j))
            do 23181 k = 1, nout
               outlvl(j,k) = outlvl(j,k) * 100 / max(1, ireslt(j,k))
23181          continue
23179       continue
         total = nout * npats
         ifile = iout1
         do 23183 i = 1, 2
            if(.not.(ifile  .ge.  0))goto 23185
               write(ifile, 996) oklvl
               write(ifile, 990) sum1, sum2, sum1 - sum2
               if(.not.(trans))goto 23187
                  write(ifile, 985)
                  do 23189 j = 1, nout
                     write(ifile, 986) chtrans(j), codes(j)
23189                continue
23187          continue
               write(ifile, 988) (chtrans(j), j = 1, nout)
               if(.not.(nwrong  .eq.  0))goto 23191
c if no errors, just print number in each category
                  write(ifile, 987) (ireslt(k,k), k = 1, nout)
                  goto 23192
c              else
23191             continue
c if errors, print the confusion matrix
                  write(ifile, 992)
                  do 23193 j = 1, nout
                     write(ifile, 991) chtrans(j), (ireslt(j,k), k = 1, 
     &                nout)
23193                continue
23192          continue
               write(ifile, 994)
               write(ifile, 987) (iunkn(j),j=1,nout)
               write(ifile, 993)
               write(ifile, 992)
               write(ifile, 988) (chtrans(j), j = 1, nout)
               do 23195 j = 1, nout
                  write(ifile, 991) chtrans(j), (nint(outlvl(j,k)), k = 
     &             1, nout)
23195             continue
               write(ifile, 994)
               write(ifile, 987) (nint(outunk(k)), k = 1, nout)
               write(ifile, 989) (nerrs(j),j=1,11),(float(100*nerrs(j))/
     &          total, j=1,11)
               write(ifile, 983) (float(100*hhist(j))/(nhid*npats), j=1,
     &          maxhist)
               write(ifile, 982)
23185       continue
            ifile = iout2
23183       continue
23177 continue
      rmserr = sqrt(error * 2)
      call sumout(iout1, iout2, iter, c, rmserr, nright, nwrong, npats)
      return
982   format(' ')
983   format(10f7.1)
985   format('   key   code string')
986   format(3x, a3, 3x, a32)
987   format(' #    * ', 40i4)
988   format(' #  key:', 40a4)
989   format(/' Histogram of errors, from 2**(-10) to 1'/11i7/11f7.1,
     & '%'/)
990   format(' # Highest two outputs (mean)', 2f7.3, ' ; mean diff', f7.
     & 3)
991   format(' # ', a4, ':', 40i4)
992   format(' #  row: correct, column: actual')
993   format(/' #  mean highest activation level')
994   format(' #  unknown' )
996   format(/' oklvl', f6.2)
      end
c errhist 14-Feb-92 15:38
c	Vary some threshhold parameter to generate data for a graph of
c	percent correct vs. percent rejected.
      subroutine errhist(ch)
      character *1 ch
c Standard parameters. NOTE: These must be the same everywhere.
c maximum allowed input patterns
      parameter (maxpat = 3500)
c maximum allowed input nodes
      parameter (maxins = 32)
c maximum allowed hidden nodes
      parameter (maxhid = 48)
c maximum allowed output nodes
      parameter (maxout = 26)
      parameter (maxwsize = maxhid*(maxins+1) + maxout*(maxhid+1))
      parameter(maxhist = 20)
c common block with file numbers
      common /filcom/ fpspec, fppat, fpgetw, fpputw, fpout, fprun, 
     & fpstd
c input:  file names and run parameters
      integer fpspec
c input:  input patterns
      integer fppat
c input:  initial weights
      integer fpgetw
c output: final weights
      integer fpputw
c output: activation levels
      integer fpout
c output: summary and error messages
      integer fprun
c output: standard output
      integer fpstd
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c common block with output items
      common /outcom/ vinp, vout, target, idpat, idres, codes, trans, 
     & chtrans
c input values
      real vinp(maxpat, maxins+1)
c output values
      real vout(maxpat, maxout)
c target output values
      real target(maxpat, maxout)
c identifier for each stored pattern (1, 2, 3, ..., nout)
      integer idpat(maxpat)
c result for each stored pattern (-1 means unknown)
      integer idres(maxpat)
c code string for identifier index ('A', '3v12', 'funny character', etc.)
      character*32 codes(maxout)
c character translation of identifier index ('A', '3v12', etc.)
      character*3 chtrans(maxout)
c Do we need to print a translation table?
      logical trans
      logical right(maxpat)
      real value(maxpat)
      parameter (numpct = 16)
      integer prej(numpct), j, p
      data prej / 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0,15.0, 20.0, 
     & 25.0, 30.0, 35.0, 40.0, 45.0, 50.0 /
      do 23197 p = 1, npats
c find highest activation level
         ibig = 1
         big = vout(p, 1)
         sum = big
         do 23199 j = 2, nout
            sum = sum + vout(p,j)
            if(.not.(vout(p,j)  .gt.  big))goto 23201
               big = vout(p,j)
               ibig = j
23201       continue
23199       continue
         value(p) = big
         right(p) = (ibig  .eq.  idpat(p))
23197    continue
      call shsort(npats, value, right)
      write(fprun, 999)
      write( *, 999)
      do 23203 irej = 1, numpct
c get approximate threshold
         if(.not.(irej  .eq.  1))goto 23205
            thresh = min(0.0, value(1))
            goto 23206
c        else
23205       continue
            x = 1 + prej(irej) * npats / 100.0
            ix = anint(x)
            thresh = value(ix)
23206    continue
         nright = 0
         nwrong = 0
         nunkwn = 0
c count
         do 23207 p = 1, npats
            if(.not.(value(p)  .ge.  thresh))goto 23209
               if(.not.(right(p)))goto 23211
                  nright = nright + 1
                  goto 23212
c              else
23211             continue
                  nwrong = nwrong + 1
23212          continue
               goto 23210
c           else
23209          continue
               nunkwn = nunkwn + 1
23210       continue
23207       continue
         correct = 100 * float(nright) / float(nright + nwrong)
         reject = 100 * float(nunkwn) / float(npats)
         write(fprun, 998) irej, ch, thresh, nright, nunkwn, nwrong, 
     &    correct, reject
         write( *, 998) irej, ch, thresh, nright, nunkwn, nwrong, 
     &    correct, reject
23203    continue
      return
998   format(i2, 't', a1, f12.6, 3i10, 2f10.2)
999   format(/8x, 
     & 'thresh       right   unknown     wrong   correct  rejected')
      end
c sumout 14-Feb-92 15:38
c		Do some summary output to standard output and iout
c
      subroutine sumout(iout1, iout2, iter, c, error, nright, nwrong, 
     & npats)
      character *1 c
c common block containing parameters
      common /parcom/ hscale, wfactor, hfactor, e1, e2
      nquest = npats - (nright + nwrong)
      fright = float(100*nright)/npats
      fquest = float(100*nquest)/npats
      fwrong = float(100*nwrong)/npats
      if(.not.(iter  .ge.  0))goto 23213
         if(.not.(iout1  .gt.  0))goto 23215
            if(.not.(iter  .eq.  0  .or.  c  .eq.  'F'))goto 23217
               write(iout1, 999) ' Iter'
23217       continue
            write(iout1, 995) c, iter, error, e1, e2, nright, nquest, 
     &       nwrong,fright, fquest, fwrong
23215    continue
         if(.not.(iout2  .gt.  0))goto 23219
            if(.not.(iter  .eq.  0  .or.  c  .eq.  'F'))goto 23221
               write(iout2, 999) ' Iter'
23221       continue
            write(iout2, 995) c, iter, error, e1, e2, nright, nquest, 
     &       nwrong,fright, fquest, fwrong
23219    continue
         goto 23214
c     else
23213    continue
         if(.not.(iout1  .gt.  0))goto 23223
            write(iout1, 999) '     '
            write(iout1, 994) error, e1, e2, nright, nquest, nwrong,
     &       fright, fquest, fwrong
23223    continue
         if(.not.(iout2  .gt.  0))goto 23225
            write(iout2, 999) '     '
            write(iout2, 994) error, e1, e2, nright, nquest, nwrong,
     &       fright, fquest, fwrong
23225    continue
23214 continue
      return
994   format('     Test', f6.3, ' (', f5.3, f6.3, ')', 3i5, ' = ', 3f6.
     & 1,'%')
995   format(2x, a1,i6, f6.3, ' (', f5.3, f6.3, ')', 3i5, ' = ', 3f6.1,
     & '%')
999   format(4x, a5, 2x, 
     & 'Err  (  Ep    Ew )   OK  UNK   NG      OK   UNK    NG')
      end
c endopt 14-Feb-92 15:38
c		Do some output at the end of the optimization
c
      subroutine endopt(fprun, fpstd, iter, ncalls, ierr, err, gw)
      integer fprun, fpstd
      assign 900 to ifmt
      if(.not.(ierr  .eq.  1))goto 23227
         assign 901 to ifmt
23227 continue
      if(.not.(ierr  .eq.  2))goto 23229
         assign 902 to ifmt
23229 continue
      if(.not.(ierr  .eq.  3))goto 23231
         assign 903 to ifmt
23231 continue
      if(.not.(ierr  .eq.  4))goto 23233
         assign 904 to ifmt
23233 continue
      write(fpstd, ifmt) iter, ierr
      write(fprun, ifmt) iter, ierr
      write(fpstd, 989) iter, ncalls, err, gw
      write(fprun, 989) iter, ncalls, err, gw
      return
900   format(' Iter', i6, '; ierr ', i1, ' : achieved error goal')
901   format(' Iter', i6, '; ierr ', i1, ' : iteration limit')
902   format(' Iter', i6, '; ierr ', i1, ' : gradient small')
903   format(' Iter', i6, '; ierr ', i1, 
     & ' : slow convergence of error')
904   format(' Iter', i6, '; ierr ', i1, ' : slow convergence of OK')
989   format(' Used', i6, ' iterations; ', i6, ' function calls; Err ', 
     & f6.3,'; |g|/|w| ', 1pe9.3)
      end
c shsort 14-Feb-92 15:38
c		Sort v array and carry along r array
c		(Shell sort because of simplicity)
      subroutine shsort(n, v, r)
      real v(n)
      logical r(n)
      integer gap
      logical ltemp
      real temp
c     for
      gap = n/2
23235 if(.not.(gap .gt. 0))goto 23237
         do 23238 i = gap, n
c           for
            j = i-gap
23240       if(.not.(j .ge. 1 .and. v(j) .gt. v(j+gap)))goto 23242
               temp = v(j)
               v(j) = v(j+gap)
               v(j+gap) = temp
               ltemp = r(j)
               r(j) = r(j+gap)
               r(j+gap) = ltemp
                j = j-gap
               goto 23240
c           endfor
23242       continue
23238       continue
          gap = gap/2
         goto 23235
c     endfor
23237 continue
      return
      end
c# end of driver.r
