c cg 14-Feb-92 15:38
c
c optwts 14-Feb-92 15:38
c	Solve neural net least squares problem by scaled conjugate gradients.
c	Return weight vector, error, |g|/|w|.
c	Stop if any of the following is true (return value as ierr)
c		0) rmserr <= egoal
c		1) Used itermax iterations.
c		2) Size of gradient vector < GWRATIO * size of weight vector
c		3) Error hasn't gone down by EFACTOR in nfreq iterations
c		4) Number right hasn't improved in nfreq iterations
c
      subroutine optwts(itermax, num, w, rmserr, gw, iter, ierr)
c the weights
      real w(num)
c
c Standard parameters. NOTE: These must be the same everywhere.
c maximum allowed input patterns
      parameter (maxpat = 3500)
c maximum allowed input nodes
      parameter (maxins = 32)
c maximum allowed hidden nodes
      parameter (maxhid = 48)
c maximum allowed output nodes
      parameter (maxout = 26)
      parameter (maxwsize = maxhid*(maxins+1) + maxout*(maxhid+1))
      parameter(maxhist = 20)
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c common block with error checking and convergence parameters
      common / errcom / egoal, gwgoal, errdel, oklvl, nfreq, nokdel
c goal for RMS error
c      real egoal			
c goal for RMS g / RMS w
c      real gwgoal			
c Required reduction factor in RMS error every nfreq iterations
c      real errdel
c Activation level for accepting output as okay
c      real oklvl
c frequency for checking convergence, printing progress
c      integer nfreq		
c Required improvement in number OK every nfreq iterations
c      integer nokdel
c common block with file numbers
      common /filcom/ fpspec, fppat, fpgetw, fpputw, fpout, fprun, 
     & fpstd
c input:  file names and run parameters
      integer fpspec
c input:  input patterns
      integer fppat
c input:  initial weights
      integer fpgetw
c output: final weights
      integer fpputw
c output: activation levels
      integer fpout
c output: summary and error messages
      integer fprun
c output: standard output
      integer fpstd
c
c negative grad of error wrt w's
      real gm(maxwsize)
c new weights
      real wnew(maxwsize)
c direction vector
      real p(maxwsize)
c remembered gm
      real r(maxwsize)
c second derivative info along p direction
      real s(maxwsize)
c number of steps since last restart
      integer icount
c number of consecutive failures
      integer fcount
      logical success
      equivalence(ee, ii)
c
c starting value for xl
      parameter (xlstart = 0.01)
c
      if(.not.(itermax  .gt.  0))goto 23000
         write(fpstd, 999) itermax, num
         write(fprun, 999) itermax, num
c get inital error and gradient
23000 continue
      call func(itermax  .gt.  0, num, w, error, gm)
      wsiz = snrm2(num, w, 1)
c
      if(.not.(itermax  .le.  0))goto 23002
         iter = -1
         goto 23003
c     else
23002    continue
         iter = 0
23003 continue
      call confuse((itermax  .le.  0), iter, ' ', error, fprun, fpstd, 
     & nright)
      rmserr = sqrt(error * 2)
      nrtprv = nright
c
      if(.not.(itermax  .le.  0))goto 23004
         return
c
23004 continue
      ierr = 1
c relative distance for numerical derivative
      sigma = 1.e-4
c lambda_k
      xl = xlstart
c lambda_k bar
      xlb = 0
      deltak = 0
      success = .true.
c
      rmsold = rmserr
      do 23006 n = 1, num
         p(n) = gm(n)
         r(n) = gm(n)
23006    continue
c 	how often to restart the algorithm
      iover = num
c
c number of iterations since last restart
      icount = 0
c number of failed iterations in a row
      fcount = 0
c number of iterations since last convergence check
      ncount = 0
      iter = itermax
      k = 0
c     while
23008 if(.not.(k  .lt.  itermax))goto 23009
         icount = icount + 1
         psiz = snrm2(num, p, 1)
         psq = psiz**2
         if(.not.(success))goto 23010
c get second derivative info
            sigmak = sigma * wsiz / psiz
            do 23012 n = 1, num
               wnew(n) = w(n) + sigmak * p(n)
23012          continue
c get error and gradient 2nd derivative information
            call func(.true., num, wnew, enew, s)
c dE/d(dist) along p is (enew-error)/sigmak
            do 23014 n = 1, num
               s(n) = (gm(n) - s(n)) / sigmak
23014          continue
            deltak = sdot(num, s, 1, p, 1)
23010    continue
         c = xl - xlb
         if(.not.(c  .ne.  0.0))goto 23016
            do 23018 n = 1, num
               s(n) = s(n) + c * p(n)
23018          continue
            deltak = deltak + c * psq
c maybe need to make "Hessian" positive definite
23016    continue
         if(.not.(deltak  .le.  0))goto 23020
            c = xl - 2 * deltak / psq
            do 23022 n = 1, num
               s(n) = s(n) + c * p(n)
23022          continue
            xlb = 2 * (xl - deltak / psq)
            deltak = - deltak + xl * psq
            xl = xlb
c get the right step size
23020    continue
         xmu = sdot(num, p, 1, r, 1)
         alpha = xmu / deltak
c
         do 23024 n = 1, num
            wnew(n) = w(n) + alpha * p(n)
23024       continue
c get new error and gradient
         call func(.true., num, wnew, enew, gm)
         delta = 2 * deltak * (error - enew) / xmu**2
c
         if(.not.(delta  .ge.  0.0))goto 23026
c successful step
            k = k + 1
            ncount = ncount + 1
cmay want additional reporting here
c if (mod(k, nfreq)   !=   0)
c	call confuse(.false., k, ' ', error, fprun, fpstd, nright)
            fcount = 0
            do 23028 n = 1, num
               w(n) = wnew(n)
23028          continue
            wsiz = snrm2(num, w, 1)
            error = enew
            xlb = 0
            success = .true.
            if(.not.(mod(icount, iover)  .eq.  0))goto 23030
c restart
               do 23032 n = 1, num
                  p(n) = gm(n)
23032             continue
               goto 23031
c           else
23030          continue
c find conjugate direction
               beta = (sdot(num, gm, 1, gm, 1) - sdot(num, gm, 1, r, 1))
     &           / xmu
               do 23034 n = 1, num
                  p(n) = gm(n) + beta * p(n)
23034             continue
23031       continue
            do 23036 n = 1, num
               r(n) = gm(n)
23036          continue
            if(.not.(delta  .ge.  0.75))goto 23038
c trustworthy
c maybe try something else
               xl = xl / 2
23038       continue
c end if (delta >= 0)
            goto 23027
c        else
23026       continue
c unsuccessful step
            xlb = xl
            success = .false.
            fcount = fcount + 1
            if(.not.(fcount  .gt.  2))goto 23040
               if(.not.(icount  .gt.  fcount))goto 23042
c at least one good step since restart
cDwrite(fpstd, 773) k
cDwrite(fprun, 773) k
cD773 format(' restart cg', i5)
                  do 23044 n = 1, num
                     p(n) = gm(n)
23044                continue
c lambda_k
                  xl = xlstart
c lambda_k bar
                  xlb = 0
                  success = .true.
                  delta = 1.0
                  aveprog = 0.0
                  icount = 0
                  fcount = 0
                  goto 23043
c              else
23042             continue
                  ierr = 3
                  iter = k
                  goto 23009
23043          continue
23040       continue
23027    continue
c If not nearly as good as predicted, increase xl
         if(.not.(delta  .lt.  0.25))goto 23046
            xl = 4.0 * xl
c maybe try xl = xl + deltak * (1 - delta) / psq
c
23046    continue
         rmserr = sqrt(error * 2)
         gsiz = snrm2(num, r, 1)
         if(.not.(success  .and.  ncount  .ge.  nfreq))goto 23048
            ncount = 0
            call confuse(.false., k, ' ', error, fprun, fpstd, nright)
c Terminate if convergence too slow
            if(.not.(rmserr  .gt.  errdel * rmsold))goto 23050
               ierr = 3
               iter = k
               goto 23009
23050       continue
            rmsold = rmserr
c Terminate if number OK not improving
            if(.not.(nright  .lt.  nrtprv + nokdel))goto 23052
               ierr = 4
               iter = k
               goto 23009
23052       continue
            nrtprv = nright
c Terminate when error satisfactory
23048    continue
         if(.not.(rmserr  .lt.  egoal))goto 23054
            ierr = 0
            iter = k
            goto 23009
c Terminate when gradient is too small
23054    continue
         if(.not.(gsiz  .lt.  gwgoal * max(1.0, wsiz)))goto 23056
            ierr = 2
            iter = k
            goto 23009
23056    continue
         goto 23008
c     endwhile
23009 continue
      gw = gsiz / wsiz
c
c print matrices
      call confuse(.true., iter, 'F', error, fprun, fpstd, nright)
c
      return
999   format(/' Conjgrad: doing ', i6, ' iterations; ', i5, 
     & ' variables')
      end
c#
c# end of cg.r
