c bp.r 14-Feb-92 15:38
c
c optwts 14-Feb-92 15:38
c	Solve neural net least squares problem by back propagation.
c	Return weight vector,  error, and |g| / |w|.
c	Stop if any of the following is true (return value as ierr)
c		0) rmserr <= goal
c		1) Used itermax iterations.
c		2) Size of gradient vector < GWRATIO * size of weight vector
c		3) Error hasn't gone down by EFACTOR in nfreq iterations
c		4) Number right hasn't improved in nfreq iterations
c
      subroutine optwts(itermax, num, w, rmserr, gw, iter, ierr)
c the weights
      real w(*)
c
c Standard parameters. NOTE: These must be the same everywhere.
c maximum allowed input patterns
      parameter (maxpat = 3500)
c maximum allowed input nodes
      parameter (maxins = 32)
c maximum allowed hidden nodes
      parameter (maxhid = 48)
c maximum allowed output nodes
      parameter (maxout = 26)
      parameter (maxwsize = maxhid*(maxins+1) + maxout*(maxhid+1))
      parameter(maxhist = 20)
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c common block with error checking and convergence parameters
      common / errcom / egoal, gwgoal, errdel, oklvl, nfreq, nokdel
c goal for RMS error
c      real egoal			
c goal for RMS g / RMS w
c      real gwgoal			
c Required reduction factor in RMS error every nfreq iterations
c      real errdel
c Activation level for accepting output as okay
c      real oklvl
c frequency for checking convergence, printing progress
c      integer nfreq		
c Required improvement in number OK every nfreq iterations
c      integer nokdel
c common block with file numbers
      common /filcom/ fpspec, fppat, fpgetw, fpputw, fpout, fprun, 
     & fpstd
c input:  file names and run parameters
      integer fpspec
c input:  input patterns
      integer fppat
c input:  initial weights
      integer fpgetw
c output: final weights
      integer fpputw
c output: activation levels
      integer fpout
c output: summary and error messages
      integer fprun
c output: standard output
      integer fpstd
c
c negative grad of error wrt w's
      real g (maxwsize)
c new last delta(w)
      real dw(maxwsize)
c The next two parameters are so small that the actual stopping
c criterion will be the number right.
c for stopping with small gradient
      parameter (gwratio = 1.e-12)
c for stopping with slow convergence
      parameter (efactor = 1.e-06)
c
c NOTE: Our eta is the usual eta divided by the number of patterns and by
c the number of outputs.
c The current definition allows eta to remain the same even if the number
c of patterns changes. 
c
      if(.not.(itermax  .gt.  0))goto 23000
         write(fpstd, 999) itermax, num, eta, alpha
         write(fprun, 999) itermax, num, eta, alpha
23000 continue
      eta = eta * nout
c
      do 23002 n = 1, maxwsize
         dw(n) = 0.0
23002    continue
c get initial error and gradient
      call func(itermax  .gt.  0, num, w, error, g)
c
      if(.not.(itermax  .le.  0))goto 23004
         iter = -1
         goto 23005
c     else
23004    continue
         iter = 0
23005 continue
      call confuse((itermax  .le.  0), iter, ' ', error,fprun, fpstd, 
     & nright)
      rmserr = sqrt(error * 2)
      nrtprv = nright
c
      if(.not.(itermax  .le.  0))goto 23006
         return
c
23006 continue
      ierr = 1
      rmsold = rmserr
c
c     for
      k = 1
23008 if(.not.(k .le. itermax))goto 23010
c adjust the weights with back propagation.
         call backward(w, w(num1+1), error, gsq, dw, dw(num1+1), g, g(
     &    num1+1))
c check error and do new gradient
         call func(.true., num, w, error, g)
c
         rmserr = sqrt(error * 2 )
c
         if(.not.(mod(k, nfreq)  .eq.  0))goto 23011
            call confuse(.false., k, ' ', error, fprun, fpstd, nright)
c Terminate if convergence too slow
            rmserr = sqrt(2 * error)
            if(.not.(rmserr  .gt.  (1.0 - efactor) * rmsold))goto 23013
               ierr = 3
               iter = k
               goto 23010
23013       continue
            rmsold = rmserr
c Terminate if number OK not improving
            if(.not.(nright  .le.  nrtprv))goto 23015
               ierr = 4
               iter = k
               goto 23010
23015       continue
            nrtprv = nright
c Terminate when error satisfactory
23011    continue
         if(.not.(rmserr  .lt.  goal))goto 23017
            ierr = 0
            goto 23010
c Terminate when gradient is too small
23017    continue
         gsiz = snrm2(num, g, 1)
         wsiz = snrm2(num, w, 1)
c#print *, ' g2 ', gsiz, ' g2/w2 ', gsiz/wsiz
         if(.not.(gsiz  .lt.  gwratio * max(1.0, wsiz)))goto 23019
            ierr = 2
            goto 23010
23019    continue
          k = k + 1
         goto 23008
c     endfor
23010 continue
      gw = gsiz / wsiz
      iter = min(k, itermax)
c
c print matrices
      call confuse(.true., iter, 'F', error, fprun, fpstd, nright)
c
      return
999   format(/' Backprop: doing ', i6, ' iterations; ', i5, 
     & ' variables; ','eta ', f7.4, '; alpha ', f7.4)
      end
c
c backward 14-Feb-92 15:38
c		back propagation to adjust weights
c
      subroutine backward(w1, w2, error, gsq, dw1, dw2, gm1, gm2)
      real w1(nhid, ninp + 1)
      real w2(nout, nhid + 1)
      real dw1(nhid, ninp + 1)
      real dw2(nout, nhid + 1)
      real gm1(nhid, ninp + 1)
      real gm2(nout, nhid + 1)
c common block containing network parameters
      common /netcom/ eta, alpha, npats, ninp, nhid, nout, ncalls, num1,
     & num2, numw
c the usual BP parameters: learning rate, momentum factor
      real eta, alpha
c number of input patterns being used
      integer npats
c number of input nodes
      integer ninp
c number of hidden nodes
      integer nhid
c number of output nodes
      integer nout
c number of calls to subroutine forward
      integer ncalls
c number of weights on first and second layers
      integer num1, num2
c total number of weights = num1 + num2
      integer numw
c
      integer h, i, j
c
      do 23021 j = 1, nout
         do 23023 h = 1, nhid
            tmp = eta * gm2(j,h) + alpha * dw2(j,h)
            w2(j,h) = w2(j,h) + tmp
            dw2(j,h) = tmp
23023       continue
23021    continue
c
      do 23025 h = 1, nhid
         do 23027 i = 1, ninp
            tmp = eta * gm1(h,i) + alpha * dw1(h,i)
            w1(h,i) = w1(h,i) + tmp
            dw1(h,i) = tmp
23027       continue
23025    continue
      return
      end
c#
c# end of bp.r
