#include <stdio.h>
#include <math.h>

/* compile with: cc linear-lib.c -c -lm -o linear-lib.o */
/* set of functions to run the linear code in the linear.lisp.  This should */
/* be  a library which is connected to the lisp via the foriegn function */
/* interface. This should be called in the linear package or the user */
/* should load the linear package from lisp. */

/* Multiplies two matrices and places the result in a third.  Inputs are */
/* given as pointers to consecutive doubles for matrices. */
void matrix_multiply (result, matrix1, matrix2, rows, width, cols)
double *result, *matrix1, *matrix2;
int rows, cols, width;
{
  int i,j,k;
  for (i=0;i<rows;i++)
    for (j=0;j<cols;j++)
      {
	result[i*cols+j]=(double) 0;
	for (k=0; k<width; k++)
	  result[i*cols+j] += matrix1[i*width+k] * matrix2[k*cols+j];
      }
}

/* */
void matrix_scalar_add (result, matrix, val, rows, cols)
double *result, *matrix, val;
int rows, cols;
{
  int i;
  for (i=0;i<rows*cols;i++)
    result[i]=matrix[i]+val;
}

/* */
void matrix_scalar_mult (result, matrix, val, rows, cols)
double *result, *matrix, val;
int rows, cols;
{
  int i;
  for (i=0;i<rows*cols;i++)
    result[i]=matrix[i]*val;
}

/* */
void matrix_matrix_add (result, matrix1, matrix2, rows, cols)
double *result, *matrix1, *matrix2;
int rows, cols;
{
  int i;
  for (i=0;i<rows*cols;i++)
    result[i]=matrix1[i]+matrix2[i];
}

/* */
void matrix_matrix_mult (result, matrix1, matrix2, rows, cols)
double *result, *matrix1, *matrix2;
int rows, cols;
{
  int i;
  for (i=0;i<rows*cols;i++)
    result[i]=matrix2[i]*matrix2[i];
}

/* gets the desired row from the matrix and places it in the result */
/* vector */
void getrow (result, matrix, rownum, rows, cols)
double *result,*matrix;
int rownum, rows, cols;
{
  int i;
  for (i=0;i<cols;i++)
      result[i]=matrix[rownum*cols+i];
}

/* places desired column in result */
void getcolumn (result, matrix, colnum, rows, cols)
double *result,*matrix;
int colnum,rows,cols;
{
  int i;
  for (i=0;i<rows;i++)
    result[i]=matrix[i*cols+colnum];
}

/* computes the dot product and returns the value */
double dot_product (vector1, vector2, len)
double *vector1,*vector2;
int len;
{
  double result;
  int i;
  result=0.0;
  for (i=0;i<len;i++)
    result+= vector1[i] * vector2[i];
  return result;
}

/* computes the vector product, which is a matrix of size len1Xlen2 */
void vector_product (result, vector1, vector2, len1, len2)
double *result,*vector1,*vector2;
int len1,len2;
{
  int i,j;
  for (i=0;i<len1;i++)
    for (j=0;j<len2;j++)
      result[i*len2+j] = vector1[i] * vector2[j];
}

/* changes the rownumth row to be what is in the vector */  
void set_row (matrix, rownum, vector, rows, cols)
double *matrix,*vector;
int rownum,rows,cols;
{
  int i;
  for (i=0;i<cols;i++)
    matrix[rownum*cols+i] = vector[i];
}

/* changes the colnumth column of the matrix to be what is stored in the */
/* vector */  
void set_column (matrix, colnum, vector, rows, cols)
double *matrix,*vector;
int colnum, rows,cols;
{
  int i;
  for (i=0;i<rows;i++)
    matrix[i*cols+colnum] = vector[i];
}

/* compute the euclidean distance between the two vectors */
double vector_distance (vector1, vector2, len)
double *vector1,*vector2;
int len;
{
  double result;
  int i;
  result=0.0;
  for (i=0;i<len;i++)
    result+= (vector1[i] - vector2[i]) * (vector1[i] - vector2[i]);
  return (result);
}

void copy_matrix (result, matrix, rows, cols)
double *result,*matrix;
int rows,cols;
{
  int i;
  for (i=0;i<rows*cols;i++)
    result[i] = matrix[i];
}

/* Some vector apply routines */

#define two ((double) 2.0)
#define one ((double) 1.0)
#define zero ((double) 0.0)

double sigmoid (x)
double x;
{
  double exp();
  return (one / (one + exp(-x)));
}

void vector_apply_sigmoid (vector, len)
double *vector;
int len;
{
  double sigmoid();
  int i;
  for (i=0;i<len;i++)
    vector[i]=sigmoid(vector[i]);
}

void vector_vector_mult (result, vector1, vector2, len)
double *result, *vector1, *vector2;
int len;
{
  int i;
  for (i=0;i<len;i++) result[i]=vector1[i]*vector2[i];
}

void vector_vector_add (result, vector1, vector2, len)
double *result, *vector1, *vector2;
int len;
{
  int i;
  for (i=0;i<len;i++) result[i]=vector1[i]+vector2[i];
}

void vector_scalar_mult (result, vector, val, len)
double *result, *vector, val;
int len;
{
  int i;
  for (i=0;i<len;i++) result[i]=vector[i]*val;
}

void vector_scalar_add (result, vector, val, len)
double *result, *vector, val;
int len;
{
  int i;
  for (i=0;i<len;i++) result[i]=vector[i]+val;
}

void vector_diff (result, vector, adder, len)
double *result, *vector, adder;
int len;
{
  int i;
  for (i=0;i<len;i++) 
    result[i] = adder + (vector[i] * (one - vector[i])); 
}

/* when tol is zero it always does the function. */
void vector_binary_diff (result, vector1, vector2, adder, tol, start, end)
double *result, *vector1, *vector2, adder, tol;
int start, end;
{
  int i;
  double fabs();
  for (i=start;i<=end;i++)
    {
      if (tol >= fabs(vector1[i] - vector2[i]))
	{
	  result[i] = zero;
	}
      else
	{
	  result[i] = (vector1[i] - vector2[i]) * 
	    (adder + (vector2[i] * (one - vector2[i]))); 
	} 
    }
}


/* compute the midpoint between two vectors */
void vector_midpoint (result, vector1, vector2, len)
double *result, *vector1, *vector2;
int len;
{
  int i;
  for (i=0; i<len;i++)
    result[i] = vector1[i] + ((vector2[i] - vector1[i]) / two);
}
