;;; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;
;;;     			     ANSIL
;;; 		      Advanced Network Simulator In Lisp
;;; 		      ----------------------------------
;;;
;;;				  Written By
;;;			       Peter J. Angeline
;;;			      Gregory M. Saunders
;;;
;;;			   The Ohio State University
;;;		       Laboratory for AI Research (LAIR)
;;;			     Columbus, Ohio, 43210
;;;
;;;			      Copyright (c) 1991
;;;
;;; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


;;;--------------------------------------------------------------------------
;;;
;;;                            Filename: go.lisp
;;;                            Author: Peter J Angeline
;;;
;;; Comments: Loads the generic version of the ANSIL system.
;;;
;;;---------------------------------------------------------------------------

;; variables
(defvar *ansil-path*)
(defvar *fasl-extension*)

;; the path name for the ANSIL system.
(setf *ansil-path* "/n/nervous/1/ansil/source/")

;; the file extension for the compiled versions of the lisp files.
(setf *fasl-extension* ".fasl")

;; the list of files to compile.
(setf file-list '("random" "matrixbp" "raam1" "raam2"))

#+allegro (setf file-list (cons "clinear" file-list))
#-allegro (setf file-list (cons "linear" file-list))

(print "Loading ANSIL ...")

(mapc #'(lambda (x)
	  (load (concatenate 'string *ansil-path* x *fasl-extension*)))
      file-list)

;; package stuff
(in-package 'user)
(use-package 'mbp)
(use-package 'mraam)

(print "Load complete")
